<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script src="https://code.jquery.com/jquery-3.3.1.js"></script>
<script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.19/js/dataTables.jqueryui.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.19/css/dataTables.jqueryui.min.css">

<aside class="right-side">
	<!-- Content Header (Page header) -->
	<section class="content-header">
		<h1>» ADD CALLER</h1>
		<p>
		</p>
	</section>
	<!-- Main content -->
	<section class="content">
		<div class="row">
			<div class="col-xs-12">
				<div class="box box-primary">
					<div class="box-body">
						<div class="row">
							<div class="col-sm-8 col-lg-8">
								<label for="inputEmail" class="col-md-2 control-label">Search Employee :</label>
								<div class="col-md-10">
									<input type="text" class="form-control" style="width:100%;"  value="" id="emp_name" onkeyup="get_emp()">
								</div><br><br>
								<input type="hidden" id="emp_id">
								<div id="no-more-tab" class="table-responsive" style = "overflow-y:scroll;height:270px; background:#f9ece3;display:none;"></div>
							</div>
						</div><br>
						<div class="row">
							<div class="col-sm-8 col-lg-8">
								<div class="form-group">
									<label for="inputEmail" class="col-md-2">Mobile :</label>
									<div class="col-md-2">
										<input type="text" class="form-control" value="+91" readonly>
									</div>
									<div class="col-md-8">
										<input type="text" id="mobile" class="form-control" maxlength="10" onkeypress="return isNumberKey(event)">
									</div>
								</div>
							</div>
						</div></br></br>
						<button type="button" class="btn btn-primary" onclick="insert_data();" style="margin-left:450px;">Add</button>
						</br></br>
						<div id="no_more_tables" class="table-responsive"></div>
					</div>
				</div>
			</div>	
		</div>
	</section>
</aside>

<!--Edit Model Starts Here-->

<div class="modal fade" id="myModal" role="dialog">
    <div class="modal-dialog">
    	<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="myModal">&times;</button>
				<h3 class="modal-title" align="center">UPDATE CALLER NUMBER</h3>
			</div>
			<div class="modal-body">
				<div class="row">
					<div class="col-sm-12 col-lg-12">
						<div class="form-group">
							<label for="inputEmail" class="col-md-2">Mobile :</label>
							<div class="col-md-2">
								<input type="text" class="form-control" value="+91" readonly>
							</div>
							<div class="col-md-8">
								<input type="text" id="mobile_update" class="form-control" maxlength="10" onkeypress="return isNumberKey(event)">
							</div>
						</div>
					</div>
				</div>
				<input type="hidden" id="hid">
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-primary" onclick="update(),hideModal();">Update</button>
				<button type="button" class="btn btn-default" data-dismiss="modal" onclick="remove_all();">Close</button>
			</div>
		</div>
    </div>
</div>

<script>

var url ="../webapi/api/index.php/";


$(document).ready(function() {
fetch_data();
});

function isNumberKey(evt){
    var charCode = (evt.which) ? evt.which : event.keyCode
    if (charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
    return true;
}


function get_emp()
{
	var name=$("#emp_name").val();
	
		$.ajax({
			type : "POST",
			dataType : "json",
			url: url+'search_emp1',
			data:JSON.stringify({"name":name}),
			
			success: function (data) 
			{
		
				var table='<table id="data-table-buttons" class="table table-striped table-bordered table-hover" style="font-size: 12px;overflow-y:scroll;height:300px;"><thead><tr><th width="1%">S.no</th><th class="text-nowrap">Emp Name</th><th class="text-nowrap">Emp No.</th><th class="text-nowrap">Action</th></tr></thead><tbody>';
				var tr="";
				var countlength=data.data.length;
				if(countlength>0)
				{
					var j=1;
					for(var i=0;i<countlength;i++)
					{
					
					var even_tr='<tr><td width="1%" class="f-s-600 text-inverse">'+j+'</td><td >'+data.data[i].name+'</td><td >'+data.data[i].employee_number+'</td><td><span class="btn btn-xs btn-success" onclick="add_employee('+data.data[i].id+',`'+data.data[i].name+'`)">Add</span></td></tr>';
						tr=tr+even_tr;
						j++;
					}
				}
				else
				{
					tr='<tr><td colspan="3" style="text-align:center;">No Record Found</td></tr>';
				}
					table=table+tr+"</tbody></table>";
					$("#no-more-tab").show();
					$("#no-more-tab").html(table);
					if(name =='' || name == null)
					{
						$("#no-more-tab").html('');
						$("#no-more-tab").hide();
					}
					
			}
		});
}

function add_employee(id,name)
{
	$("#emp_name").val(name);
	$("#emp_id").val(id);
	$("#no-more-tab").html('');
	$("#no-more-tab").hide();
}



function insert_data()
{
	var emp_id = $("#emp_id").val();
	var mobile = $("#mobile").val();
	var emp_name=$("#emp_name").val();
	
	
	if($("#emp_name").val()==null || $("#emp_name").val()=='' || $("#emp_name").val()==false)
	{
		swal("Please Choose An Employee","","danger");
		$("#emp_name").focus();
		return false;
	}
	else if($("#mobile").val()==null || $("#mobile").val()=='' || $("#mobile").val()==false)
	{
		swal("Please Enter A Mobile Number","","danger");
		$("#mobile").focus();
		return false;
	}
	else
	{

		$.ajax({
			type : "POST",
			dataType : "json",
			url: url+'insert_caller',
			data:JSON.stringify({"emp_id":emp_id,"mobile":mobile,"session":'<?php echo $_SESSION["ADMIN_ID"];?>'}),
			success: function(data) 
			{ 
				if(data.status==1)
				{
					swal("Caller Added Successsfully","","success");
				}
				else
				{
					swal("Data Already Exist","","danger");
				}
				$("#emp_name").val(''); 
				$("#mobile").val(''); 
				
				fetch_data();
			}
				
		});
	}
	
}

function fetch_data()
{
		
	$.ajax({
		type : "POST",
		dataType : "json",
		url: url+'caller_details',
		success: function (data) { 
	
			var table ='<table class="col-md-12 table-bordered table-striped table-condensed cf" id="example1" style="table-layout:fixed;"><thead class="alert-info"><tr><th width="5%">Sr. No.</th><th class="text-nowrap">Employee Code</th><th class="text-nowrap">Sales Rep</th><th class="text-nowrap">Sales Rep Number</th><th class="text-nowrap">Status</th><th class="text-nowrap">Action</th></tr></thead><tbody class="alert-primary">';
			var tr="";
			var status="";
			
			var countlength=data.data.length;
			
			if(countlength>0)
			{
				
				var j=1;
				for(var i=0;i<countlength;i++)
				{
			
					if(data.data[i].status=='1')
					{
						status="Active";
						class_btn="btn btn-xs btn-success";
						name="Active";
						function_name="active("+data.data[i].caller_id+",'0')";
					}
					else
					{
					
						status="Inactive";
						class_btn="btn btn-xs btn-danger";
						name="Inactive";
						function_name="active("+data.data[i].caller_id+",'1')";
					}
		
		
					var even_tr='<tr><td class="f-s-600 text-inverse">'+j+'</td><td>'+data.data[i].employee_number+'</td><td>'+data.data[i].employee_name+'</td><td>'+data.data[i].mobile_no+'</td><td><span class="'+class_btn+'" onclick="'+function_name+'">'+name+'</span></td><td><button class="btn btn-primary" onclick="edit_data('+data.data[i].caller_id+');">Edit</button>'+"&nbsp;"+''+"&nbsp;"+'<button class="btn btn-danger" onclick="delete_data('+data.data[i].caller_id+');">Delete</button></td></tr>';
			
					tr=tr+even_tr;
					j++;
						
				}
			}
			else
			{
				tr='<tr><td colspan="6" style="text-align:center;">No Record Found</td></tr>';
			}
			table=table+tr+"</tbody></table>";
			$("#no_more_tables").html(table);
			$("#example1").DataTable();
		}
	});
}

function active(caller_id,status){
	
	$.ajax({
		type : "POST",
		dataType : "json",
		url: url+'active_inactive_caller',
		data:JSON.stringify({"caller_id":caller_id,"status":status}),
            
		success: function (data) {
			
			if(data.status==1)
			{	
				swal("Status Changed Successfully","","success");
				fetch_data();
			}
			
			else
			{
				swal("Another Setting is alredy Active","","danger");
					
			}
			

		}
	});
}


function edit_data(id)
{
	$("#myModal").modal('show');
	
	$("#hid").val(id);
		
		$.ajax({
			type : "POST",
			dataType : "json",
			url: url+'edit_caller_details',
			data:JSON.stringify({"caller_id":id}),
			success: function (data) 
			{ 
			
				$("#mobile_update").val(data.data[0].mobile);
				//$("#update_ip_address").val(data.data[0].device_ip);
				
				
			}
			
		});
}


function update()
{
	var  mobile= $("#mobile_update").val();
	var caller_id=$("#hid").val();
	
	
	if($("#mobile_update").val()=="" || $("#mobile_update").val()==null || $("#mobile_update").val()==false)
	{
		swal("Please Enter A Number","","danger");
		$("#mobile_update").focus();
		return false;
	}
	else
	{
	
		$.ajax({
			type : "POST",
			dataType : "json",
			url: url+'update_caller_details',
		
			data:JSON.stringify({"caller_id":caller_id,"mobile":mobile}),
			success: function(data) 
			{ 
			
				if(data.status==1)
				{
					swal("Caller Number Updated Successsfully","","success");
				}
				else
				{
					swal("This Number Already Exist","","danger");
				}
				$("#myModal").modal('hide');
				fetch_data();
				
			}
				
		});
	}
	
}

function delete_data(caller_id)
{
		
	$.ajax({
		type : "POST",
		dataType : "json",
		url: url+'delete_caller_details',
		data:JSON.stringify({"caller_id":caller_id}),
		success: function (data) 
		{ 
			if(data.status==1)
			{
				
				swal("Data Deleted Successfully","","success");
			}
			else
			{
				swal("Data Does Not Exists!!","","danger");
			}
			fetch_data();
		}
	});
}

</script>

  
  