<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script src="https://code.jquery.com/jquery-3.3.1.js"></script>
<script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.19/js/dataTables.jqueryui.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.19/css/dataTables.jqueryui.min.css">


<script>

var url ="../webapi/api/index.php/";


$(document).ready(function() {
fetch_data();
employee_list_show();
});

$(function() {
  $('input[name="daterange"]').daterangepicker({
    opens: 'left'
  }, function(start, end, label) {
    console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
  });
});

function employee_list_show()
{
	$.ajax({
		type : "POST",
		dataType : "json",
		url: url+'lists_employees',
		
		success: function(data) 
		{ 
			var countlength=data.data.length;
			
			for(var i=0;i<countlength;i++)
			{
				var opt="<option value='"+data.data[i].id+"'>"+data.data[i].employee_name+"</option>";
				$("#emp_name").append(opt);
				$("#agent_name").append(opt);
			}
		}
	});
}
function fetch_data()
{
	var daterange=$('#daterange').val();
	var emp_id= $("#emp_name").val();	
	$.ajax({
		type : "POST",
		dataType : "json",
		url: url+'admin_caller_report',
		data:JSON.stringify({"emp_id":emp_id,"daterange":daterange}),
		success: function (data) { 
	
			var table ='<table class="table table-bordered table-hover" id="example1"><thead class="alert-info"><tr><th width="4%">Sr. No.</th><th class="text-nowrap" width="8%">Employee Code</th><th class="text-nowrap" width="10%">Sales Rep</th><th class="text-nowrap" width="10%">Caller Number</th><th class="text-nowrap" width="7%">Call Duration</th><th class="text-nowrap" width="7%">Status</th><th class="text-nowrap" width="7%">Call Type</th><th class="text-nowrap" width="8%">Start Time</th><th class="text-nowrap" width="7%">Client Current Status</th><th class="text-nowrap" width="7%">Remark</th><th class="text-nowrap" width="15%">Resource</th><th class="text-nowrap" width="10%">View-Remark</th></tr></thead><tbody class="alert-primary">';
			var tr="";
			var status="";
			var stats ="";
			var rmk ="";
			var btns_name="";
			var countlength=data.data.length;
			
			if(countlength>0)
			{
				
				var j=1;
				for(var i=0;i<countlength;i++)
				{
					 if(data.data[i].status==null)
					{
						stats="";
						
					}
					else
					{
						stats =data.data[i].status;
						
					} 
					if(data.data[i].remark==null)
					{
						rmk="";
						
					}
					else
					{
						rmk =data.data[i].remark;
						
					} 
		
					var even_tr='<tr><td class="f-s-600 text-inverse">'+j+'</td><td>'+data.data[i].employee_number+'</td><td>'+data.data[i].employee_name+'</td><td>'+data.data[i].caller_id+'</td><td>'+data.data[i].call_duration+'</td><td>'+data.data[i].business_call_type+'</td><td>'+data.data[i].Call_Type+'</td><td>'+data.data[i].start_time+'</td><td>'+stats+'</td><td>'+rmk+'</td><td><audio style="background-color:black;width:100%;"controls id="linkAudio"><source src="'+data.data[i].resource_uri+'" type="audio/mpeg"></audio></td><td><a onclick="fetch_caller_data('+data.data[i].emp_idd+','+data.data[i].log_id+')" class="btn btn-success btn-sm">View</a><span class="btn btn-primary" data-target="#myModal" data-toggle="modal" onclick="assign_agent('+data.data[i].log_id+')">Assign Agent</span></td></tr>';
			
					tr=tr+even_tr;
					j++;
						
				}
				table=table+tr+"</tbody></table>";
			$("#no_more_tables").html(table);
			$("#example1").DataTable();
			}
			else
			{
				tr='<tr><td colspan="14" style="text-align:center;">No Record Found</td></tr>';
				table=table+tr+"</tbody></table>";
			$("#no_more_tables").html(table);
			}
			
		}
	});
}


function assign_agent(log_id)
{
	$("#myModal").show();
	$("#tb_id").val(log_id);
}

function fetch_mobile()
{
	var agent_id= $("#agent_name").val();	
	$.ajax({
		type : "POST",
		dataType : "json",
		url: url+'fetch_mobile',
		data:JSON.stringify({"emp_id":agent_id}),
		success: function (data) 
		{ 
			if(data.status==1)
			{
				$("#mobile_div").show();
				$("#mob").val(data.data[0].mobile_no);
			}
		}
	});
	
}


function update_agent()
{
	var agent= $("#agent_name").val();
	var mobile= $("#mob").val();
	var tbl_id=$("#tb_id").val();
	
	if(agent=='' || agent==null || agent==false)
	{
		swal("Please Select An Agent");
		$("#agent_name").focus();
		return false;
	}
	else
	{
		$.ajax({
			type : "POST",
			dataType : "json",
			url: url+'update_agent_mobile',
			data:JSON.stringify({"mobile":mobile,"tbl_id":tbl_id}),
			success: function (data) 
			{ 
				if(data.status==1)
				{
					swal("Agent Assigned Successfully");
					fetch_data();
				}
			}
		});
	}
}



function close_all()
{
	$("#mobile_div").hide();
	$("#agent_name").val('');
}


function transfer()
{  
	document.location.href = "caller_admin_export.php";
}


</script>
<aside class="right-side">
	<!-- Content Header (Page header) -->
	<section class="content-header">
		<h1>Caller Report» Admin</h1>
		
	</section>
	<!-- Main content -->
	<section class="content">
		<div class="row">
			<div class="col-xs-12">
				<div class="box box-primary">
					<div class="box-body">
						<div class="row">
							<div class="col-sm-12 col-lg-12">
								<div class="form-group">
									<label for="inputEmail" class="col-md-2">Select Employee :</label>
									<div class="col-md-5">
										<select id="emp_name" class="validate[required] form-control" onchange="fetch_data()">
											<option value="0">Select Employee</option>
										</select>
									</div>
								</div>
							</div>
						</div></br>
						<div class="form-group">
									<label for="inputEmail" class="col-md-2">Search By Date:</label>
									<div class="col-md-3">
										<input type="text" placeholder="Search By Date Range" name="daterange" id="daterange" class="form-control"/><br>
										<button type="button" onclick="fetch_data()" class="btn btn-md btn-success">Search Date</button>
									</div>
						</div> </br></br><br><br>
						<div id="no_more_tables" class="table-responsive"></div>
					</div>
				</div>
			</div>	
		</div>
	</section>
</aside>


	<div class="modal fade" id="myModal" role="dialog">
		<div class="modal-dialog"  style="width:500px">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal">&times;</button>
					<h3 class="modal-title" align="center">Assign Agent</h3>
				</div>
				<div class="modal-body">
				<input type="hidden" id="tb_id" value="" />
					<div class="row">
						<div class="col-sm-12 col-lg-12">
							<div class="form-group">
								<label for="inputEmail" class="col-md-4">Agent Name :</label>
								<div class="col-md-8">
									<select id="agent_name" class="validate[required] form-control" onchange="fetch_mobile()">
										<option value="0">Select Agent</option>
									</select>
								</div>
							</div>
						</div>
					</div><br>
					<div class="row" id="mobile_div" style="display:none;">
						<div class="col-sm-12 col-lg-12">
							<div class="form-group">
								<label for="inputEmail" class="col-md-4">Agent Mobile :</label>
								<div class="col-md-8">
									<input type="text" class="validate[required] form-control" id="mob" readonly />
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-primary" data-dismiss="modal" onclick="update_agent();">Assign</button>
					<button type="button" class="btn btn-default" data-dismiss="modal" onclick="close_all();">Close</button>
				</div>
				
			</div>
		</div>
	</div>

<script type="text/javascript">

	
	

</script>

