<?php 
function convert_number_to_words($number) 
{

    $hyphen      = '-';
    $conjunction = ' and ';
    $separator   = ', ';
    $negative    = 'negative ';
    $decimal     = ' point ';
    $dictionary  = array(
        0                   => 'zero',
        1                   => 'one',
        2                   => 'two',
        3                   => 'three',
        4                   => 'four',
        5                   => 'five',
        6                   => 'six',
        7                   => 'seven',
        8                   => 'eight',
        9                   => 'nine',
        10                  => 'ten',
        11                  => 'eleven',
        12                  => 'twelve',
        13                  => 'thirteen',
        14                  => 'fourteen',
        15                  => 'fifteen',
        16                  => 'sixteen',
        17                  => 'seventeen',
        18                  => 'eighteen',
        19                  => 'nineteen',
        20                  => 'twenty',
        30                  => 'thirty',
        40                  => 'fourty',
        50                  => 'fifty',
        60                  => 'sixty',
        70                  => 'seventy',
        80                  => 'eighty',
        90                  => 'ninety',
        100                 => 'hundred',
        1000                => 'thousand',
        1000000             => 'million',
        1000000000          => 'billion',
        1000000000000       => 'trillion',
        1000000000000000    => 'quadrillion',
        1000000000000000000 => 'quintillion'
    );

    if (!is_numeric($number)) {
        return false;
    }

    if (($number >= 0 && (int) $number < 0) || (int) $number < 0 - PHP_INT_MAX) {
        // overflow
        trigger_error(
            'convert_number_to_words only accepts numbers between -' . PHP_INT_MAX . ' and ' . PHP_INT_MAX,
            E_USER_WARNING
        );
        return false;
    }

    if ($number < 0) {
        return $negative . convert_number_to_words(abs($number));
    }

    $string = $fraction = null;

    if (strpos($number, '.') !== false) {
        list($number, $fraction) = explode('.', $number);
    }

    switch (true) {
        case $number < 21:
            $string = $dictionary[$number];
            break;
        case $number < 100:
            $tens   = ((int) ($number / 10)) * 10;
            $units  = $number % 10;
            $string = $dictionary[$tens];
            if ($units) {
                $string .= $hyphen . $dictionary[$units];
            }
            break;
        case $number < 1000:
            $hundreds  = $number / 100;
            $remainder = $number % 100;
            $string = $dictionary[$hundreds] . ' ' . $dictionary[100];
            if ($remainder) {
                $string .= $conjunction . convert_number_to_words($remainder);
            }
            break;
        default:
            $baseUnit = pow(1000, floor(log($number, 1000)));
            $numBaseUnits = (int) ($number / $baseUnit);
            $remainder = $number % $baseUnit;
            $string = convert_number_to_words($numBaseUnits) . ' ' . $dictionary[$baseUnit];
            if ($remainder) {
                $string .= $remainder < 100 ? $conjunction : $separator;
                $string .= convert_number_to_words($remainder);
            }
            break;
    }

    if (null !== $fraction && is_numeric($fraction)) {
        $string .= $decimal;
        $words = array();
        foreach (str_split((string) $fraction) as $number) {
            $words[] = $dictionary[$number];
        }
        $string .= implode(' ', $words);
    }

    return $string;
}
?>
<script>
function formatMoney($number, $fractional = false) {
    if ($fractional) {
$number = sprintf('%.2f', $number);
}
while (true) {
$replaced = preg_replace('/(-?\d+)(\d\d\d)/', '$1,$2', $number);
if ($replaced != $number) {
$number = $replaced;
} else {
break;
}
}
return $number;
}

</script>

<script>
function send_mail()
{	

  //alert($("#print").html());
	var mail_data=$("#print").html();
	//var depid='<?php echo $_GET['depid']; ?>';
	//var appoint_id='<?php echo $_GET['appoint_id'];?>';
	
	console.log(mail_data);
	
	  $.ajax({
		type:'POST',
		url:'ajax/my_ajax.php',
 		data:{emil_id:$("#emil_id").val(),      
			  funtion:'send_Increment_Letter'},
		    
  		   success:function(return_data)
		   {
		        //alert(return_data);
				  alert('Send mail successfully');
 		   }
		   });    
}
</script>
<aside class="right-side">
<!-- Content Header (Page header) -->
<section class="content-header">
<h1>Manage Recruitment <small>»Increment Letter</small></h1>

<ol class="breadcrumb">
  <li><a href="#"><i class="fa fa-dashboard"></i> Help</a></li>
</ol>
</section>

<form action ="mail.php" method="post">
<section class="content-header">
<p>
  <ol class="breadcrumb"> 
  <li><a class="btn btn-success" style="color:white" onclick="PrintDiv()" id="btnPrint">Print</a></li>
  <li><a class="btn btn-success" style="color:white" onclick="send_mail()" >Increment Letter Send </a></li>   
  </ol>
</p>
</section>


<input type="hidden" id="emil_id" name="emil_id" value="<?php echo $fatch_data_salary['email'];?>">
</form>


<section class="content">

  	<div class="box box-primary">
       <div id="no-more-tables">
        
        <div class="container" id="print">
			<div class="row">
				<img class="img-responsive" src="header_offer_later.jpg" />
			</div>
			
			<div class="col-lg-12">
				<table>
				<center><h3><u>Increment Letter</u></h3></center>
				<p>&nbsp;</p>
					<tr>
						<td style="width:500px;"><b>Kind Attn. :<?php echo $fatch_data_salary['first_name']." ".$fatch_data_salary['middle_name']." ".$fatch_data_salary['last_name'];?></b></td>
						<td style="width:500px;"><p style="text-align:right;"><b>Date: <?php echo date('d-m-Y',strtotime($employee_salary_structures['createed']))?></b></p></td>
					</tr>
                    
                    <tr>
						<td style="width:500px;"><b>Designation: <?php  echo $desig['name'] ;?></b></td>
					</tr>
                    
                    <tr>
						<td style="width:500px;"><b>Emp. ID : <?php  echo $fatch_data_salary['employee_number'] ;?></b></td>
					</tr>
				</table>
				
			
    <p>&nbsp;</p>
				
				<p><b>Dear <?php echo $fatch_data_salary['first_name']." ".$fatch_data_salary['middle_name']." ".$fatch_data_salary['last_name'];?>,</b></p>
				
				<div>
				<p><b>We are pleased to inform you that your salary has been incremented to INR <?php echo $employee_salary_structures['net_salary']*12 ;?> (<?php echo ucwords(convert_number_to_words($employee_salary_structures['net_salary']*12)) ;?> Only) per annum w. e. f <?php echo $employee_salary_structures['start_date']?>.</b></p>
				
				<p><b>The detailed breakup of the salary is attached as "Annexure A"</b></p>
                
                <p><b>We reiterate that your compensation is a confidential matter between you and the company and we reaffirm that the company shall view ant breach of confidentiality with utmost seriousness.</b></p>
                
                <p><b>We appreciate your good work and look forward to same kind of performance and attitude in coming years.</b></p>
                
                <p>&nbsp;</p><p>&nbsp;</p>
                <p><b>For Integrated Wireless solutions Pvt. Ltd.</b></p>


<p>&nbsp;</p><p>&nbsp;</p>

<p><b>Gitika Raheja</b></p>
<p><b>HR Manager</b></p>

    </div> 
				<p>&nbsp;</p>
				
				<img class="img-responsive" src="f_offer_later.jpg" />
				<div>
				
				
				
		</div>
	</div>
    
    
    
    <div class="row">
				<img class="img-responsive" src="header_offer_later.jpg" />
			</div>
			
    <div class="col-lg-12">
    <div >
				<table class="table-bordered table-striped table-hover table-condensed table-responsive">
				<center><b><u>Annexure-A</u></b></center><br />
                <center><b><u>CTC BREAKUP – REVISED</u></b></center>
				<p>&nbsp;</p>
					<tr>
						<td style="width:500px;"><p><b>&nbsp; Name</b></p></td>
						<td style="width:500px;" colspan="2"><p><b>&nbsp; <?php echo $fatch_data_salary['first_name']." ".$fatch_data_salary['middle_name']." ".$fatch_data_salary['last_name'];?></b></p></td>
					</tr>
                    
                    <tr>
						<td style="width:500px;"><p><b>&nbsp; Designation</b></p></td>
                        <td style="width:500px;" colspan="2"><p><b>&nbsp; <?php  echo $desig['name'] ;?></b></p></td>
					</tr>
                    
                    <tr>
						<td style="width:500px;"><p><b>&nbsp; Date Of Salary Revision</b></p></td>
                        <td style="width:500px;" colspan="2"><p><b>&nbsp; <?php echo $employee_salary_structures['start_date']?></b></p></td>
					</tr>
                    
                    <tr>
						<td style="width:500px;"><p><b>&nbsp; Revised CTC</b></p></td>
                        <td style="text-align:center"><p><b>&nbsp; <?php echo $employee_salary_structures['ctc_amount']?></b></p></td>
                        <td style="text-align:center"><p><b>&nbsp; <?php echo $employee_salary_structures['ctc_amount']*12?></b></p></td>
					</tr>
                    
                    
                      <tr style="border:1px solid #000000 !importatnt;">
										
                                            
                                            <th > &nbsp;&nbsp;Component</th>
                                           
                                            <th style="text-align:center">Per Month</th>
                                            <th style="text-align:center">Per Annum</th>
                                            
                                        </tr>
                                        <?php while($data_res=mysql_fetch_array($data))
										{
											$dataxax[]=$data_res['amount'];
											$dataxaxasdsa[]=$data_res['amount']*12;
											?>
                                        <tr>
                                        <th>&nbsp;&nbsp;<?php //$categari=mysql_fetch_array(mysql_query("select * from payroll_categories where id='".$data_res['payroll_category_id']."'"));
										//echo $categari['name'];
										if($data_res['payroll_category_id']=="basic_pay"){
											echo "Basic";}
										if($data_res['payroll_category_id']==2){
											echo "HRA";}
										if($data_res['payroll_category_id']==3){
											echo "TPT";}
										if($data_res['payroll_category_id']==5){
											echo "Bonus";}
											
										if($data_res['payroll_category_id']=="spl_allowance"){
											echo "Special Allowance";}
										if($data_res['payroll_category_id']==8){
											echo "PF Employer Contribution";}
											if($data_res['payroll_category_id']==7){
											echo "Medical Allowances";}
										if($data_res['payroll_category_id']=="epf_employee"){
											echo "ESI Employer Contribution";}
										?></th>
                                         <td style="text-align:center"><?php echo $data_res['amount'];?></td>
                                          <td style="text-align:center"><?php echo $data_res['amount']*12;?></td>
                                        </tr>
                                       <?php }?>
                                       <tr>
                                     
                    
				</table>
                <small>The salary payments are subject to income tax and the deductions for the same would be made every month.</small>
                <p>&nbsp;</p>
                
                
                <table>
					<tr>
						<td style="width:500px;"><p><b>&nbsp; For Integrated Wireless Solutions Pvt. Ltd.</b></p></td>
						<td style="width:500px; text-align:right;"><p><b>&nbsp; Accepted By</b></p></td>
					</tr>
                    
                    </table>
                     
                     
                     <p>&nbsp;</p>
                     <p>&nbsp;</p>
                     
                     
                     <table>
                     
                    <tr>
						<td style="width:500px;"><p><b>&nbsp; Gitika Raheja</b></p></td>
						<td style="width:500px; text-align:right;"><p><b>&nbsp; <?php echo $fatch_data_salary['first_name']." ".$fatch_data_salary['middle_name']." ".$fatch_data_salary['last_name'];?></b></p></td>
					</tr>
                    
                    <tr>
						<td style="width:500px;"><p><b>&nbsp; HR Manager</b></p></td>
					</tr>
                    
                    
                    </table>
                
    </div>
    </div>
    
    <p>&nbsp;</p>
				
				<img class="img-responsive" src="f_offer_later.jpg" />
    
    
</div>                 
             
   
                           
	   </div>
     </div><!-- /.box-body -->
  

</section><!-- /.content -->
</aside>
	
	<script>
	function PrintDiv() {    
           var divToPrint = document.getElementById('print');
           var popupWin = window.open('');
           popupWin.document.open();
           popupWin.document.write('<html><body onload="window.print()">' + divToPrint.innerHTML + '</html>');
           popupWin.document.close();
                }
	</script>
	