<?php

function convert_number_to_words($number) {

    $hyphen = '-';
    $conjunction = ' and ';
    $separator = ', ';
    $negative = 'negative ';
    $decimal = ' point ';
    $dictionary = array(
        0 => 'zero',
        1 => 'one',
        2 => 'two',
        3 => 'three',
        4 => 'four',
        5 => 'five',
        6 => 'six',
        7 => 'seven',
        8 => 'eight',
        9 => 'nine',
        10 => 'ten',
        11 => 'eleven',
        12 => 'twelve',
        13 => 'thirteen',
        14 => 'fourteen',
        15 => 'fifteen',
        16 => 'sixteen',
        17 => 'seventeen',
        18 => 'eighteen',
        19 => 'nineteen',
        20 => 'twenty',
        30 => 'thirty',
        40 => 'fourty',
        50 => 'fifty',
        60 => 'sixty',
        70 => 'seventy',
        80 => 'eighty',
        90 => 'ninety',
        100 => 'hundred',
        1000 => 'thousand',
        1000000 => 'million',
        1000000000 => 'billion',
        1000000000000 => 'trillion',
        1000000000000000 => 'quadrillion',
        1000000000000000000 => 'quintillion'
    );

    if (!is_numeric($number)) {
        return false;
    }

    if (($number >= 0 && (int) $number < 0) || (int) $number < 0 - PHP_INT_MAX) {
        // overflow
        trigger_error(
                'convert_number_to_words only accepts numbers between -' . PHP_INT_MAX . ' and ' . PHP_INT_MAX, E_USER_WARNING
        );
        return false;
    }

    if ($number < 0) {
        return $negative . convert_number_to_words(abs($number));
    }

    $string = $fraction = null;

    if (strpos($number, '.') !== false) {
        list($number, $fraction) = explode('.', $number);
    }

    switch (true) {
        case $number < 21:
            $string = $dictionary[$number];
            break;
        case $number < 100:
            $tens = ((int) ($number / 10)) * 10;
            $units = $number % 10;
            $string = $dictionary[$tens];
            if ($units) {
                $string .= $hyphen . $dictionary[$units];
            }
            break;
        case $number < 1000:
            $hundreds = $number / 100;
            $remainder = $number % 100;
            $string = $dictionary[$hundreds] . ' ' . $dictionary[100];
            if ($remainder) {
                $string .= $conjunction . convert_number_to_words($remainder);
            }
            break;
        default:
            $baseUnit = pow(1000, floor(log($number, 1000)));
            $numBaseUnits = (int) ($number / $baseUnit);
            $remainder = $number % $baseUnit;
            $string = convert_number_to_words($numBaseUnits) . ' ' . $dictionary[$baseUnit];
            if ($remainder) {
                $string .= $remainder < 100 ? $conjunction : $separator;
                $string .= convert_number_to_words($remainder);
            }
            break;
    }

    if (null !== $fraction && is_numeric($fraction)) {
        $string .= $decimal;
        $words = array();
        foreach (str_split((string) $fraction) as $number) {
            $words[] = $dictionary[$number];
        }
        $string .= implode(' ', $words);
    }

    return $string;
}

function formatMoney($number, $fractional = false) {
    if ($fractional) {
        $number = sprintf('%.2f', $number);
    }
    while (true) {
        $replaced = preg_replace('/(-?\d+)(\d\d\d)/', '$1,$2', $number);
        if ($replaced != $number) {
            $number = $replaced;
        } else {
            break;
        }
    }
    return $number;
}
?>
<aside class="right-side">
    <!-- Content Header (Page header) -->

    <section class="content-header">
        <h1>Hr Management-Employee Profile</h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i>Help</a></li>
            <!--<li><a href="#">Tables</a></li>
              <li class="active">Data tables</li>-->
        </ol>
    </section>
    <!-- Content Header (Page header) -->
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <!-- /.box -->
                <div class="box">
                    <div class="box-header">
                        <h3 class="box-title">
                            <?php if ($_GET[edit_id] == '') { ?>
                                Personal Detail
                            <?php } else { ?>
                                Employee Profile
                            <?php } ?>
                        </h3>
                    </div>
                    <!-- /.box-header -->
                    <!-- /.box-body -->
                </div>
                <!-- /.box -->
            </div>
        </div>
        <!-- /.row -->
        <div class="box box-primary">
            <div class="row">
                <div class="box-body table-responsive">
                    <div class="col-sm-12">
                        <!--left col-->
                        <div class="row">
                            <div class="col-sm-5">
                                <h3>
                                    <div id="profile_picture_display1">
                                        <?php
                                        $path = "user_image/";
                                        $file = $sel_last['photo_file_name'];

                                        $path_new = "../assets/user_image/employee_image/";
                                        $file_new = $sel_last['photo_file_name'];
                                        ?>
                                        <?php
                                        if (file_exists($path_new . $file_new) && $sel_last['photo_file_name'] != '') {
                                            ?>
                                            <img src="../assets/user_image/employee_image/<?php echo $sel_last['photo_file_name']; ?>" width="100" height="108" />
                                            <?php
                                        } elseif (file_exists($path . $file) && $sel_last['photo_file_name'] != '') {
                                            ?>
                                            <img src="user_image/<?php echo $sel_last['photo_file_name']; ?>" width="100" height="108" />
                                            <?php
                                        } elseif ($sel_last['photo_file_name'] != '') {
                                            ?>
                                            <?php
                                            $path = "user_image/photos/" . $sel_last['sibling_id'] . "/original/";
                                            $file = $sel_last['photo_file_name'];
                                            ?>
                                            <img src="user_image/photos/<?php echo $sel_last['sibling_id']; ?>/original/<?php echo $sel_last['photo_file_name']; ?>" width="100" height="108" />
                                        <?php } else { ?>
                                            <img src="../assets/user_image/dummy.jpg" width="156" height="143" />
                                        <?php } ?>
                                        <h4> </h4>
                                    </div>
                                </h3>
                            </div>
                            <div class="col-sm-5" style="margin-top: 13px;">
                                <ul class="list-group">


                                    <li class="list-group-item text-right"><span class="pull-left"><strong>Employee no:</strong></span> <?php echo $sel_last['employee_number']; ?> </li>
                                    <li class="list-group-item text-right"> <span class="pull-left"><strong> Name :</strong></span> <?php echo ucwords($sel_last['prefix']) . ". " . ucwords($sel_last['first_name']) . " " . ucfirst($sel_last['middle_name']) . " " . ucfirst($sel_last['last_name']); ?> </li>
                                    <li class="list-group-item text-right"> <span class="pull-left"><strong> Department :</strong></span> <?php
                                        $desgnation = mysql_fetch_array(mysql_query("select * from employee_departments where id='" . $sel_last['employee_department_id'] . "'"));
                                        echo $desgnation['name'];
                                        ?> </li>
                                    
                                    <li class="list-group-item text-right"> <span class="pull-left"><strong> Designation :</strong></span> <?php
                                        $desgnation = mysql_fetch_array(mysql_query("select * from employee_positions where id='" . $sel_last['employee_position_id'] . "'"));
                                        echo $desgnation['name'];
                                        ?> </li>
                                    
                                    
                                    <li class="list-group-item text-right"><span class="pull-left"><strong>Joining Date:</strong></span> <?php echo $fetch_join ?> </li>
                                    <li class="list-group-item text-right"><span class="pull-left"><strong>Employee Status:</strong></span> <?php $query_stauts=mysql_fetch_array(mysql_query("select * from employee_status where id='".$sel_last['leave_status']."'")); if(isset($query_stauts['name']) && $sel_last['is_deleted']=='1'){ echo $query_stauts['name']; } else { echo "Active"; } ?> </li>

                                </ul>
                            </div>
                        </div>
                    </div>
                    <!--/col-3-->
                </div>
                <!-- /responsive box -->
                <div class="col-sm-12">
                    <ul class="nav nav-pills" id="myTab" >
                        <li <?php if (isset($_GET['active']) && !empty($_GET['active']) && $_GET['active'] == 'home') { ?> class="active" <?php } ?>><a href="#employee" data-toggle="tab">Home</a></li>
                        <li <?php if (isset($_GET['active']) && !empty($_GET['active']) && $_GET['active'] == 'sal') { ?> class="active" <?php } ?>><a href="#salary" data-toggle="tab">Salary Details</a></li>
                        <li <?php if (isset($_GET['active']) && !empty($_GET['active']) && $_GET['active'] == 'documents') { ?> class="active" <?php } ?>><a href="#emp_documents" data-toggle="tab">Employee Documents</a></li>
                        <li <?php if (isset($_GET['active']) && !empty($_GET['active']) && $_GET['active'] == 'qualification') { ?> class="active" <?php } ?>><a href="#qualifcation" data-toggle="tab">Qualification Details</a></li>
                        <li <?php if (isset($_GET['active']) && !empty($_GET['active']) && $_GET['active'] == 'exp') { ?> class="active" <?php } ?>><a href="#experience" data-toggle="tab">Experience Details</a></li>
                        <li <?php if (isset($_GET['active']) && !empty($_GET['active']) && $_GET['active'] == 'banking') { ?> class="active" <?php } ?>><a href="#bank" data-toggle="tab">Bank Details</a></li>
                        <?php  ?><li <?php if(isset($_GET['active']) && !empty($_GET['active']) && $_GET['active'] == 'additional') { ?> class="active" <?php } ?>><a href="#additional" data-toggle="tab">Additional Details</a></li><?php  ?>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane <?php if (isset($_GET['active']) && !empty($_GET['active']) && $_GET['active'] == 'home') { ?> active <?php } ?>" id="employee">
                            <h3 align="center">Employee Basic Details</h3>
                            <hr>
                            <div class="box-body table-responsive">
                                <table  class="table table-bordered">
                                    <tbody>
                                        <tr class="alert-danger">
                                            <td align="center"><h4>Employee Profile</h4></td>
                                            <td style="margin-top:10px; float:left;">

                                                <?php
                                                if (isset($_GET['increase']) && !empty($_GET['increase'])) {
                                                    ?>
                                                    <a href="admission.php?empl_id=<?php echo $_GET['empl_id'] ?>&&edit_id=<?php
                                                    if (isset($sel_last['id']) && !empty($sel_last['id'])) {
                                                        echo $sel_last['id'];
                                                    }
                                                    ?>&&active=home&&increase=<?php echo $_GET['increase']; ?>">
                                                        <input type="button" name="" value="Edit" class="btn btn-primary">
                                                    </a> 
                                                <?php } else { ?>

                                                    <a href="admission.php?empl_id=<?php echo $_GET['empl_id'] ?>&&edit_id=<?php
                                                    if (isset($sel_last['id']) && !empty($sel_last['id'])) {
                                                        echo $sel_last['id'];
                                                    }
                                                    ?>&&active=home">
                                                        <input type="button" name="" value="Edit" class="btn btn-primary">
                                                    </a>
                                                <?php } ?>

                                            </td>
                                        </tr>
                                        <tr>
                                            <td>Job title</td>
                                            <td class="right"><?php
                                                $title = mysql_query("select * from employee_jobs where id='" . $sel_last['job_title'] . "'");
                                                $fetch_title = mysql_fetch_array($title);
                                                echo $fetch_title['job_title']
                                                ?></td>
                                        </tr>
                                        <tr class="success">
                                            <td>Date of Birth</td>
                                            <td class="right"><?php echo $fetch_dob; ?></td>
                                        </tr>
                                        <tr class="">
                                            <td>Gender</td>
                                            <td class="right"><?php
                                                if ($sel_last['gender'] == 'f') {
                                                    echo "Female";
                                                } else if ($sel_last['gender'] == 'm') {
                                                    echo "Male";
                                                } else if ($sel_last['gender'] == 'Female') {
                                                    echo "Female";
                                                } else if ($sel_last['gender'] == 'Male') {
                                                    echo "Male";
                                                }
                                                ?></td>
                                        </tr>
                                        <tr class="success">
                                            <td>Reporting Manager</td>
                                            <td class="right"><?php
                                                $query = mysql_fetch_array(mysql_query("select * from employees where id='" . $sel_last['reporting_mng'] . "'"));
                                                echo $query['first_name'] . " " . $query['middle_name'] . " " . $query['last_name']
                                                ?></td>
                                        </tr>
                                        <tr>
                                            <td>Guardian's Name</td>
                                            <td class="right"><?php echo $sel_last['f_prefix'] . ". " . $sel_last['father_name']; ?></td>
                                        </tr>
                                        <tr class="success">
                                            <td>Blood Group</td>
                                            <td class="right"><?php echo $sel_last['blood_group']; ?></td>
                                        </tr>
                                        <tr>
                                            <td>Job Posting</td>
                                            <td class="right"><?php echo $sel_last['posting_place']; ?></td>
                                        </tr>
                                        <tr class="success">
                                            <td>Nationality</td>
                                            <td class="right"><?php
                                                $count = mysql_query("select * from countries where id='" . $sel_last['nationality_id'] . "'");
                                                $fetch_contry = mysql_fetch_array($count);
                                                if ($fetch_contry['name'] == 'India') {
                                                    echo "Indian";
                                                }
                                                ?>
                                            </td>
                                        </tr>

                                        <tr>
                                            <td>Religion</td>
                                            <td class="right"><?php echo $sel_last['religion']; ?></td>
                                        </tr>
                                        <tr class="success">
                                            <td>Address</td>
                                            <td class="right"><?php echo $sel_last['local_address_line1']; ?> <?php echo $sel_last['local_address_line2']; ?></td>
                                        </tr>
                                        <tr>
                                            <td>City</td>
                                            <td class="right"><?php echo $sel_last['local_city']; ?></td>
                                        </tr>
                                        <tr class="success">
                                            <td>State</td>
                                            <td class="right"><?php
                                                $state_name = mysql_fetch_array(mysql_query("select * from states where id='" . $sel_last['local_state'] . "'"));
                                                echo $state_name['state_name']
                                                ?></td>
                                        </tr>
                                        <tr>
                                            <td>PIN code</td>
                                            <td class="right"><?php echo $sel_last['local_pin_code']; ?></td>
                                        </tr>
                                        <tr class="success">
                                            <td>Country</td>
                                            <td class="right"><?php
                                                $count = mysql_query("select * from countries where id='" . $sel_last['nationality_id'] . "'");
                                                $fetch_contry = mysql_fetch_array($count);
                                                echo $fetch_contry['name'];
                                                ?></td>
                                        </tr>
                                        <tr>
                                            <td>Phone</td>
                                            <td class="right"><?php echo $sel_last['home_phone']; ?></td>
                                        </tr>
                                        <tr class="success">
                                            <td>Mobile</td>
                                            <td class="right"><?php echo $sel_last['mobile_phone']; ?></td>
                                        </tr>
                                        <tr>
                                            <td>Email</td>
                                            <td class="right"><?php echo $sel_last['email']; ?></td>
                                        </tr>
                                        <tr class="success">
                                            <td>Biometric ID</td>
                                            <td class="right"><?php echo $sel_last['biometric_id']; ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr>
                            </div>
                            <!--/table-responsive-->
                        </div>
                        <!--/tab-pane-->
                        <div class="tab-pane <?php if (isset($_GET['active']) && !empty($_GET['active']) && $_GET['active'] == 'sal') { ?> active <?php } ?>" id="salary">
                            <h3 align="center"> Employee Salary Structure Details</h3>
                            <hr>
                            <div class="box-body table-responsive">
                                <table  class="table table-bordered">
                                    <tbody>
									
									<?php
									  $sal_sql_query="select * from employee_salary_structures where employee_id='" . $_GET['empl_id'] . "' ORDER BY id DESC ";
									$num_rows_salaer=mysql_num_rows(mysql_query($sal_sql_query));
										$salary_head_structure=mysql_fetch_array(mysql_query($sal_sql_query));
											$res_salary_grp_id=$salary_head_structure['salary_grp_id'];
											
											?>
                                        <tr class="alert-danger">
                                            <td align="center" colspan="3"><h4>Salary Details</td>
											 <td style="margin-top:10px; float:left;">
                                                <?php
                                             
											 if($num_rows_salaer>0 &&  $res_salary_grp_id!='' ){
                                                    ?>
                                                     <a href="admission1_new.php?empl_id=<?php echo $_GET['empl_id']; ?>&&edit_id=<?php echo $employees_sal['id']; ?>&&salary=sal">
                                                        <input type="button" name="" value="Edit" class="btn btn-primary">
                                                    </a> 
                                                <?php } 
                                                 
												
												
												else if($num_rows_salaer >0 &&  $res_salary_grp_id =='' ){
                                                    ?>
                                                     <a href="admission1.php?empl_id=<?php echo $_GET['empl_id']; ?>&&edit_id=<?php echo $employees_sal['id']; ?>&&salary=sal">
                                                        <input type="button" name="" value="Edit" class="btn btn-primary">
                                                    </a> 
                                                <?php } else { ?>

                                                    <a href="admission1_new.php?empl_id=<?php echo $_GET['empl_id']; ?>&&edit_id=<?php echo $employees_sal['id']; ?>&&salary=sal">
                                                        <input type="button" name="" value="Edit" class="btn btn-primary">
                                                    </a>
                                                <?php } ?>

                                            </td>
											
											<?php 
											
											
										
											if($num_rows_salaer>0 && $res_salary_grp_id!='')
											{
											?>
                                           
                                        </tr>
										<tr>
										<th style="width:40%" colspan="2">CTC </th>
										<th colspan="2"  ><?php echo "<i class='fa fa-fw fa-rupee'></i>" . formatMoney($salary_head_structure['ctc_amount']); ?> </th>
										
										
										</tr>
										<tr>
										<th style="width:60%" colspan="2">Salary Group</th>
										<th colspan="2"><?php 
										$grade=mysql_fetch_array(mysql_query("select * from payroll_salarygroup where id='".$salary_head_structure['salary_grp_id']."'"));
										echo ucfirst($grade['name']);
										?> </th>
										
										
										</tr>
                                        <tr style="border:1px solid #000000 !importatnt;">
										
                                            <th style="width:8%">S.No.</th>
                                            <th>Earnings</th>
                                            <th>Percenatge/Fix</th>
                                            <th>Amount</th>
                                            
                                        </tr>
                                        <tr>
                                            <?php
											
											
                                            $salary_sturc = mysql_query("select * from employee_salary_structures where employee_id='" . $_GET['empl_id'] . "' and salary_grp_id='".$salary_head_structure['salary_grp_id']."' and employee_salary_structures.is_deduction=0");
                                            $earning_percentage_sum=mysql_fetch_array(mysql_query("select sum(payroll_categories_salarygroup.percentage) as total_percentage from payroll_categories_salarygroup where payroll_categories_salarygroup.salarygroup_id='".$_POST['grade']."' and payroll_categories_salarygroup.payroll_head_type=0  and payroll_categories_salarygroup.is_percentage=1"));
											$counter=0;
											$i="A";
                                            while ($fetch_sruct = mysql_fetch_array($salary_sturc)) {
												
												$earning_amount[$fetch_sruct['payroll_category_id']]=$fetch_sruct['amount'];
												$total_earning=$fetch_sruct['total_earning'];
												
											//print_r($earning_amount[$fetch_sruct['payroll_category_id']]);
												
												if($fetch_sruct['payroll_category_id']=='basic_pay') 
												{
													$earning_name=mysql_fetch_array(mysql_query("select * from payroll_basic_pay where payrool_id='basic_pay' "));
												}
												else{
                                                $earning_name=mysql_fetch_array(mysql_query("select * from payroll_categories where id='".$fetch_sruct['payroll_category_id']."' "));
												
												}
												
												$basic_salary=round(($_POST['ctc']/$earning_percentage_sum['total_percentage'])*100);
		                                        $collection_salary[basic_pay]=$basic_salary;
												
												$earning_percentage_type=mysql_fetch_array(mysql_query("select percentage ,is_percentage from payroll_categories_salarygroup where payroll_categories_salarygroup.salarygroup_id='".$salary_head_structure['salary_grp_id']."' and payroll_head_id='".$fetch_sruct['payroll_category_id']."'"));
                                                ?>
												<input type="hidden" name="ctc" value="<?php echo $_POST['ctc'];?> "/>
												<input type="hidden" name="salary_group" value="<?php echo $_POST['grade'];?> "/>
												<input type="hidden" name="payroll_category_id[]" value="<?php echo $fetch_sruct['payroll_category_id'];?>"/>
                                                <td><?php echo $i; ?></td>
												<td><?php if(isset($earning_name['name']) && $earning_name['name']!='') {echo ucfirst($earning_name['name']); }
												elseif($fetch_sruct['payroll_category_id']=='spl_allowance'){echo "Special Allowance ";}
												
         												?></td>
                                                <td><?php 
											
												 $sql_pf_check=mysql_fetch_array(mysql_query("select  employee_epf_contribution.employeer_epf,employee_epf_contribution.employee_epf  from employee_epf_contribution where employee_epf_contribution.employee_id='".$_GET['empl_id']."' and employee_epf_contribution.salary_grp_id='".$salary_head_structure['salary_grp_id']."'"));
												if(isset($sql_pf_check['id']))
												{
												   $emploeer_epf=    $sql_pf_check['employeer_epf'];
												   $emploee_epf= $sql_pf_check['employee_epf'];
												   
												  
												
												} 
												
												
												if($earning_percentage_type['is_percentage']=='1')
												{
												echo $earning_percentage_type['percentage']." %"; 
												}
												else if($earning_percentage_type['is_percentage']=='0')
												{
													echo $earning_percentage_type['percentage']." Fix"; 
												}
								
												
												?></td>
                                                
												
												<?php if($fetch_sruct['payroll_head_id']=='basic_pay'){ ?>
                                                <td><?php echo "<i class='fa fa-fw fa-rupee'></i>" . formatMoney($basic_salary); ?> </td>
												<?php }else{ ?>
												<input type="hidden" name="amount[basic_pay]" value="<?php echo $basic_salary;?> "/>
												   <td><?php 
												   
												   $salary_head_amount=round($basic_salary*$fetch_sruct['percentage']/100);
												   $collection_salary[$fetch_sruct['payroll_head_id']]=$salary_head_amount;
												   echo "<i class='fa fa-fw fa-rupee'></i>".formatMoney($earning_amount[$fetch_sruct['payroll_category_id']]);  ?> </td>
												   <input type="hidden" name="amount[<?php echo $fetch_sruct['payroll_head_id'];?>]" value="<?php echo $earning_amount[$fetch_sruct['payroll_category_id']];?> "/>
											<?php }  ?>
												</tr>
<?php $i++; } ?>
 <td colspan="3"><b>Total Earning</b></td>
                                            <td><?php 
											
										
											 $spl_allowance=mysql_fetch_array(mysql_query("select amount from employee_salary_structures where employee_salary_structures.employee_id='".$_GET['empl_id']."' and 
employee_salary_structures.payroll_category_id='spl_allowance' order by id desc"));
 //$spl_allowance['amount']; 
                                      
											$total_earnings=$total_earning;
											echo "<i class='fa fa-fw fa-rupee'></i><b>" . formatMoney($total_earnings) . "</b>"; ?></td>
											
											<input type="hidden" name="total_earning" value="<?php echo $total_earnings;?> "/>
											
												<?php
												
                                                    $sql1 = mysql_query("SELECT employee_salary_structures.*,payroll_categories.name
																		FROM employee_salary_structures
																		inner  join payroll_categories on employee_salary_structures.payroll_category_id=payroll_categories.id
																		WHERE employee_salary_structures.employee_id='".$_GET['empl_id']."' and employee_salary_structures.salary_grp_id='".$salary_head_structure['salary_grp_id']."' AND employee_salary_structures.is_deduction=1");
																	
																		$ded_num=mysql_num_rows($sql1);	
                                                            if(isset($ded_num) && $ded_num >0)															
															{

                                                   ?>
												   <tr>
												 <th style="width:8%">S.No.</th>
												 <th>Deduction</th>
												 <th> Percentage / Fix</th>
                                            <th>Amount</th>
												</tr>
												<tr>
												   <?php
                                                   $j=1;
                                                            while ($data1 = mysql_fetch_array($sql1)) 
															{ 
														
																$deductfrom[$data1['payroll_head_id']]=$data1['payroll_category_id'];
																$deductpercentage[$data1['payroll_category_id']]=$data1['amount'];
																$total_deduction1=$data1['total_deduction'];
																$net_salary1=$data1['net_salary'];
																$esi_status=$data1['esi'];
																$pf_status=$data1['pf'];
																$tds_status=$data1['tds'];
																
																
																?>
																<td> <?php echo $j; ?></td>
																<td> <?php 
																
																$dedcution_percentage_type=mysql_fetch_array(mysql_query("select *,percentage  from payroll_categories_salarygroup where payroll_categories_salarygroup.salarygroup_id='".$salary_head_structure['salary_grp_id']."' and payroll_head_id='".$data1['payroll_category_id']."'"));
																 if($counter !=$data1['payroll_category_id'])
																{
																	$counter=$data1['payroll_category_id'];							 
																	echo $data1['name'] . "<br>";				
																}
																$dedction_id=$data1['deduction_from'];
																$dedction_percentage=$data1['percentage']; ?> </td>
																<td> <?php echo $dedcution_percentage_type['percentage'];
																         if($dedcution_percentage_type['is_percentage']==1){ echo " %";}
																		 else{ echo " Fix";}

 																?></td>
																<input type="hidden" name="payroll_deduction_id[]" value="<?php echo $data1['payroll_head_id'];?> "/>
																
																
																
																
																
																
																 <td><?php 
												
												
												echo "<i class='fa fa-fw fa-rupee'></i>" . formatMoney($deductpercentage[$data1['payroll_category_id']])."<br>";
														
												
															  ?>
                                                </td>
												<input type="hidden" name="payroll_deduction_amount[<?php echo $data1['payroll_head_id'];?> ]" value="<?php echo $deduction_arr[$data1['payroll_head_id']];?> "/>
														</tr>		
														
                                                           <?php $j++; }
                                                    ?>
                                                </td>

												<td colspan="3" ><b>Total Deduction</b></td>
                                            <td><?php 
											
											
											
											$total_deduction=array_sum($deduction_arr);
											//$total_earning=$total_salary_heads;
											echo "<i class='fa fa-fw fa-rupee'></i><b>" . formatMoney($total_deduction1) . "</b>"; ?></td>
											<input type="hidden" name="total_deduction" value="<?php echo $total_deduction;?> "/>
											</tr>
											<?php } else{?>
											<input type="hidden" id="total_deduction" name="total_deduction" value="<?php 
												$total_deduction1=0;
												
											echo	$total_deduction1;?> "/>				
															<?php 	}
																?>
											<?php 
											
											
											$tax_deduction=@mysql_fetch_array(mysql_query("select *,in_hand_salary ,gross,pf,esi,tds,ctc_amount from employee_salary_structures where employee_id='".$_GET['empl_id']."' group by start_date order by id desc" ));
											
											
											
									 IF($tax_deduction['pf']==0  && $tax_deduction['esi']==0 )
											
											{ 
											?>
											
											<tr>
											<td colspan="3" ><b>Gross  </b></td>
                                            <td><?php 
										
										
										//$gross_main=$tax_deduction['gross'];
										$gross_main=$tax_deduction['gross']-$total_deduction1;
											
										//	echo "<i class='fa fa-fw fa-rupee'></i><b>" . formatMoney($tax_deduction['gross']) . "</b>";
											echo "<i class='fa fa-fw fa-rupee'></i><b>" . formatMoney($gross_main) . "</b>";
											
											
 ?></td>
					

					<input type="hidden" name="gross_salary" value="<?php echo $tax_deduction['gross'];?> "/> 
											
											</tr>
											<?php  	}  ?>
											
											<?php //////////////////////////////////////
											$sql_pf_check=@mysql_query("select * from employee_epf_contribution   where employee_epf_contribution.employee_id='".$_GET['empl_id']."'");
			$check_pf=@mysql_fetch_array($sql_pf_check);
	
	
											
												if($tax_deduction['pf']==1){
												
										
												?>
<tr  id="epf_employer_tr" style="width:100%;">
  <td  colspan="2" ><b>EPF Employer Contributions</b></td>                                              

<?php 
	
	$epf_esi=@mysql_fetch_array(mysql_query("select * from epf_esi_details"));
	if(	$epf_esi['epf_both_onlyemp']=='Y'){
	
			
				  
					  
					//  echo $esi_amount=round((($gross_salary)*$epf_esi['employeer_esi'])/100);
					  }
if(	$epf_esi['epf_both_onlyemp']=='Y'){	
	?>
<td ><?php 
	
	
	echo  $epf_esi['employeer_epf']; ?>  % of <?php if($check_pf['employeer_epf']==15000)
	{ echo "15000";}else {
	
	echo $check_pf['employeer_epf'];
	
} 
?></td>
<input type="hidden" name="payroll_category_id_epf[]" value="epf_employeer"/>
<?php 
	
	
	if($check_pf['employeer_epf']==15000){ $epf_employer= round(((15000)*$epf_esi['employeer_epf'])/100);}else if($check_pf['employeer_epf']==$basic_salary){ 
$epf_employer=round(($check_pf['employeer_epf']*$epf_esi['employeer_epf'])/100);}else{

$epf_employer=round(($check_pf['employeer_epf']*$epf_esi['employeer_epf'])/100);

} ?>
<td  value=""><?php 


 
echo "<i class='fa fa-fw fa-rupee'></i><b>" . formatMoney($epf_employer) . "</b>";

	
?>
<input type="hidden" id="epf_amount_employer" value="<?php echo $epf_employer;?>"/>
<input type="hidden" name="amount[epf_employeer]" value="<?php echo $epf_employer;?> "/> </td></tr>
<tr  id="epf_employee_tr">
	<td colspan="2"  ><b>EPF Employee Contribution</b></td>
<td><?php echo  $epf_esi['employee_epf']; ?> % of <?php if($check_pf['employee_epf']==15000){ echo "15000";}else {
	
	echo $check_pf['employee_epf'];
	
} ?></td>
<input type="hidden" name="payroll_category_id_emp[]" value="epf_employee"/>

<?php if($check_pf['employee_epf']==15000){ $epf_employee= round(((15000)*$epf_esi['employee_epf'])/100);}elseif($check_pf['employee_epf']==$basic_salary){ $epf_employee=round(($check_pf['employee_epf']*$epf_esi['employee_epf'])/100);}elseif($basic_salary<=15000){ echo $epf_employee=round(($check_pf['employee_epf']*$epf_esi['employee_epf'])/100);} ?>

<td  value="">
	
	<?php 


 
echo "<i class='fa fa-fw fa-rupee'></i><b>" . formatMoney($epf_employee) . "</b>";


?><input type="hidden" id="epf_employee" name="amount[epf_employee]"  value="<?php echo $epf_employee;?> "/> </td>
<input type="hidden" id="epf_amount_employee" value="<?php echo $epf_employee;?>"/>
</tr>

	<?php  }else if($epf_esi['epf_both_onlyemp']=='N'){ 
	
	?><td>
	<?php 
		ECHO 'No Employeer EPF Contribution';
		
		?></td>
		<input type="hidden" name="payroll_category_id_epf[]" value="epf_employeer"/>
<?php 
	
	
	if($check_pf['employeer_epf']==15000){ $epf_employer= round(((15000)*$epf_esi['employeer_epf'])/100);}elseif($check_pf['employeer_epf']==$basic_salary){ 

$epf_employer=0;} ?>
<td  value=""><?php 


 
echo "<i class='fa fa-fw fa-rupee'></i><b>" . formatMoney(0) . "</b>";

	
?>
<input type="hidden" id="epf_amount_employer" value="<?php echo 0;?>"/>
<input type="hidden" name="amount[epf_employeer]" value="<?php echo 0;?> "/> </td></tr>
<tr  id="epf_employee_tr">
	<td colspan="2"  ><b>EPF Employee Contribution</b></td>
<td><?php echo  $epf_esi['employee_epf']; ?> % of <?php if($check_pf['employee_epf']==15000){ echo "15000";}else {
	
	echo $check_pf['employee_epf'];
	
}  ?></td>
<input type="hidden" name="payroll_category_id_emp[]" value="epf_employee"/>

<?php if($check_pf['employee_epf']==15000){ $epf_employee= round(((15000)*$epf_esi['employee_epf'])/100);}elseif($check_pf['employee_epf']==$basic_salary){ $epf_employee=round(($check_pf['employee_epf']*$epf_esi['employee_epf'])/100);}elseif($basic_salary<=15000){ echo $epf_employee=round(($check_pf['employee_epf']*$epf_esi['employee_epf'])/100);} ?>

<td  value="">
	
	<?php 


 
echo "<i class='fa fa-fw fa-rupee'></i><b>" . formatMoney($epf_employee) . "</b>";


?><input type="hidden" id="epf_employee" name="amount[epf_employee]"  value="<?php echo $epf_employee;?> "/> </td>
<input type="hidden" id="epf_amount_employee" value="<?php echo $epf_employee;?>"/>
</tr>
	<?php }
												}
												//////////////////////////////////////////?>
											<tr>
											<?php 
												
											if($tax_deduction['esi']==1){	
					$epf_esi=mysql_fetch_array(mysql_query("select * from epf_esi_details"));				
										
											if($epf_esi['esi_both_onlyemp']=='Y'){
										
												$esi_gross=$total_earning+$total_deduction;
$gross_bfr=$tax_deduction['gross'];

  $esi_employer = round(($gross_bfr*$epf_esi['employeer_esi'])/100);
 
											
											?>
												
											
												

<input type="hidden" id="esi_amount" value="<?php echo $esi_employer;?>"/>
	<tr  id="esi_employer_tr">
                                                
 <td colspan="2" ><b>ESI Employer Contribution </b></td>
<td><?php echo  $epf_esi['employeer_esi']; ?> of Gross</td>
<input type="hidden" name="payroll_category_id_esi[]" value="esi_employeer"/>
<td><?php 

echo "<i class='fa fa-fw fa-rupee'></i><b>" . formatMoney($esi_employer) . "</b>";


?><input type="hidden" name="amount[esi_employeer]" value="<?php echo $esi_employer;?> "/> </td></tr>



<tr style="" id="esi_employee_tr">
<?php  ?>
<?php $esi_employee = round(($gross_bfr*$epf_esi['employee_esi'])/100); ?>
                                                
<td colspan="2" ><b>ESI Employee Contribution </b></td>
<td><?php echo  $epf_esi['employee_esi']; ?>  % of Gross</td>
<input type="hidden" name="payroll_category_id_esi[]" value="esi_employee"/>
<td><?php 

echo "<i class='fa fa-fw fa-rupee'></i><b>" . formatMoney($esi_employee) . "</b>";


?><input type="hidden"  id="esi_employee"  name="amount[esi_employee]"  value="<?php echo $esi_employee;?> "/> </td>


</tr>
<?PHP  }else if($epf_esi['esi_both_onlyemp']=='N'){
$esi_gross=$total_earning+$total_deduction;
$gross_bfr=$tax_deduction['gross'];

 $esi_employer = round(0); ?>
 <input type="hidden" id="esi_amount" value="<?php echo 0;?>"/>
	<tr style="" id="esi_employer_tr">
                                                
<td colspan="2" ><b>ESI Employer Contribution </b></td>
<td><?php echo  'No Employeer ESI Contribution';  ?> </td>
<input type="hidden" name="payroll_category_id_esi[]" value="esi_employeer"/>
<td><?php 

echo "<i class='fa fa-fw fa-rupee'></i><b>" . formatMoney(0) . "</b>";


?><input type="hidden" name="amount[esi_employeer]" value="<?php echo 0;?> "/> </td></tr>



<tr style="" id="esi_employee_tr">
<?php //$esi_employee = round(($esi_gross*1.75)/100); ?>
<?php $esi_employee = round(($gross_bfr*$epf_esi['employee_esi'])/100); ?>
                                                
<td colspan="2" ><b>ESI Employee Contribution </b></td>
<td><?php echo  $epf_esi['employee_esi']; ?>  % of Gross</td>
<input type="hidden" name="payroll_category_id_esi[]" value="esi_employee"/>
<td><?php 

echo "<i class='fa fa-fw fa-rupee'></i><b>" . formatMoney($esi_employee) . "</b>";


?><input type="hidden"  id="esi_employee"  name="amount[esi_employee]"  value="<?php echo $esi_employee;?> "/> </td>


</tr>
 
<?PHP  }  ?>	
												
											<?php } ?>
											
											
											<td colspan="3" ><b>In Hand Salary  </b></td>
                                            <td><?php 
												$tax_deduction1=@mysql_fetch_array(mysql_query("select *,in_hand_salary ,gross,pf,esi,tds,ctc_amount from employee_salary_structures where employee_id='".$_GET['empl_id']."' group by start_date order by id desc" ));
												
											 if($tax_deduction1['pf']=='0' && $tax_deduction1['esi']=='0'){
												
													echo "<i class='fa fa-fw fa-rupee'></i><b>" . formatMoney($tax_deduction1['in_hand_salary']-$total_deduction1) . "</b>";
												}
												else if($tax_deduction1['esi']=='1'  && $tax_deduction1['pf']=='0'){
											
													$inhand=$tax_deduction1['in_hand_salary']-$esi_employee-$esi_employer-$total_deduction1;
												echo "<i class='fa fa-fw fa-rupee'></i><b>" . formatMoney($inhand) . "</b>";
												}else if($tax_deduction1['pf']=='1' &&  $tax_deduction1['esi']=='0'){
												
											$inhand=$tax_deduction1['in_hand_salary']-$epf_employer-$epf_employee-$total_deduction1;
												echo "<i class='fa fa-fw fa-rupee'></i><b>" . formatMoney($inhand) . "</b>";
												}else if($tax_deduction1['pf']=='1' && $tax_deduction1['esi']=='1'){

											$inhand=$tax_deduction1['in_hand_salary']-$esi_employee-$esi_employer-$epf_employer-$epf_employee-$total_deduction1;
												echo "<i class='fa fa-fw fa-rupee'></i><b>" . formatMoney($inhand) . "</b>";
												
												}else{
												
													echo "<i class='fa fa-fw fa-rupee'></i><b>" . formatMoney($tax_deduction1['in_hand_salary']-$total_deduction1) . "</b>";
												}
												
											 ?></td>
											<input type="hidden" name="in_hand_salary" value="<?php echo $tax_deduction1['in_hand_salary'];?> "/>
											
											</tr>
											<?php
												
															
									 IF($tax_deduction['pf']==1  || $tax_deduction['esi']==1 )
											
											{ 
												
												?>
											<tr>
											<td colspan="3" ><b>Gross (After EPF and ESI deduction) </b></td>
                                            <td><?php 
										 
										if($tax_deduction['esi']==1 && $tax_deduction['pf']=='0' ){
													$inhandgross=$tax_deduction['gross']-$esi_employee-$esi_employer-$total_deduction1;
												echo "<i class='fa fa-fw fa-rupee'></i><b>" . formatMoney($inhandgross) . "</b>";
												}else if($tax_deduction['pf']==1 && $tax_deduction['esi']=='0'){	
											$inhandgross=$tax_deduction['gross']-$epf_employer-$epf_employee-$total_deduction1;
												echo "<i class='fa fa-fw fa-rupee'></i><b>" . formatMoney($inhandgross) . "</b>";
												}else if($tax_deduction['pf']==1 && $tax_deduction['esi']==1){
												
											$inhandgross=$tax_deduction['gross']-$esi_employee-$esi_employer-$epf_employer-$epf_employee-$total_deduction1;
												echo "<i class='fa fa-fw fa-rupee'></i><b>" . formatMoney($inhandgross) . "</b>";
												
												}else{
												
												echo "<i class='fa fa-fw fa-rupee'></i><b>" . formatMoney($tax_deduction['gross']-$total_deduction1) . "</b>";
												}
										
										
	//								
 ?></td>
					

					<input type="hidden" name="gross_salary" value="<?php echo $tax_deduction['gross'];?> "/> 
											
											</tr>
											<?php   } ?>
											<tr>
											<td colspan="3" ><b>CTC  </b></td>
                                            <td><?php 
											
											
											echo "<i class='fa fa-fw fa-rupee'></i><b>" . formatMoney($tax_deduction['ctc_amount']) . "</b>"; ?></td>
											<input type="hidden" name="net_salary" value="<?php echo $tax_deduction['ctc_amount'];?> "/>
											
											</tr>
											<tr>
											<td colspan="4" ><center><b>Tax  Deduction</b></center></td>
											</tr>
											<tr>
											
											<td colspan="3" ><b>PF</b></td>
											<td><?php  if($tax_deduction['pf']==1){ echo "<b>YES<b>"; }else {echo "NO";} ?>
											 </td>
											</tr>
											<tr>
											<td colspan="3" ><b>ESI</b></td>
											<td><?php if($tax_deduction['esi']==1){ echo "<b>YES<b>"; }else {echo "NO";} ?></td>
											</tr>
											<tr>
											<td colspan="3" ><b>TDS</b></td>
											<td><?php if($tax_deduction['tds']==1){ echo "<b>YES<b>"; }else {echo "NO";} ?></td>
											</tr>
											
											<?php }else if($num_rows_salaer>0 && $res_salary_grp_id ==''){ ?>
											 <tr style="border:1px solid #000000 !importatnt;">
                                            <th>Earnings</th>
                                            <th>Amount</th>
                                            <th>Deductions</th>
                                            <th>Amount</th>
                                        </tr>
                                        <tr>
                                            <?php
											
											$basic_pay=mysql_fetch_array(mysql_query("select * from payroll_basic_pay"));
											$basic_amount=mysql_fetch_array(mysql_query("select * from employee_salary_structures where employee_id='".$_GET['empl_id']."' and employee_salary_structures.payroll_category_id='basic_pay' ORDER BY id DESC "));
                                            ?>
											<tr>
											<td><?php echo $basic_pay['name']; ?></td>
											 <td><?php echo "<i class='fa fa-fw fa-rupee'></i>" . formatMoney($basic_amount['amount']);  ?> </td>
                                                
											</tr>	
											
											<?php 
											$counterp = 0;
                                            $salary_sturc = mysql_query("select * from payroll_categories where is_deduction='0'");
                                            while ($fetch_sruct = mysql_fetch_array($salary_sturc)) {
											  
                                                $salary_info = mysql_query("select * from employee_salary_structures where employee_id='" . $_GET['empl_id'] . "' AND 	payroll_category_id='" . $fetch_sruct['id'] . "' ORDER BY id DESC");

                                                $sal_name = mysql_fetch_array($salary_info);
                                                ?>
                                                <td><?php echo $fetch_sruct['name']; ?></td>
                                                <td><?php echo "<i class='fa fa-fw fa-rupee'></i>" . formatMoney($sal_name['amount']); ?> </td>
                                                <td><?php
												
                                                   // $sql1 = mysql_query("select * from payroll_categories where is_deduction='1' and deduction_from=$fetch_sruct[id] order by id asc");
                                                    $sql1 = mysql_query("select * from payroll_categories where is_deduction='1'");
                                                    if($counterp<1){
														while ($data1 = mysql_fetch_array($sql1)) {

                                                        echo $data1[name] . "<br>";
                                                       }
													}
                                                    ?>
                                                </td>
                                                <td><?php
                                                   // $sql2 = mysql_query("select * from payroll_categories where is_deduction='1' and deduction_from=$fetch_sruct[id] order by id desc");
                                                    $sql2 = mysql_query("select * from payroll_categories where is_deduction='1' ");
                                                    if($counterp<1){
														while ($data2 = mysql_fetch_array($sql2)) {

                                                        $emp = mysql_fetch_array(mysql_query("select * from employee_salary_structures where employee_id='" . $_GET['empl_id'] . "' AND payroll_category_id='" . $data2[id] . "' ORDER BY id DESC"));
                                                        echo "<i class='fa fa-fw fa-rupee'></i>" . formatMoney($emp['amount']) . "<br>";
                                                    }
													}
                                                    ?>
                                                </td>
                                            </tr>
                                        <?php 
											  $counterp++;
											 
											}
											?>
                                        <tr>
                                            <?php
                                            $salary_deduct = mysql_query("select * from employee_salary_structures where employee_id='" . $_GET['empl_id'] . "' ORDER BY id DESC");
                                            $fetch_deducto = mysql_fetch_array($salary_deduct);
                                            ?>
                                            <td><b>Total Earning</b></td>
                                            <td><?php echo "<i class='fa fa-fw fa-rupee'></i><b>" . formatMoney($fetch_deducto['total_earning']) . "</b>"; ?></td>
                                            <td><b>Total Deduction</b></td>
                                            <td><?php echo "<i class='fa fa-fw fa-rupee'></i><b>" . formatMoney($fetch_deducto['total_deduction']) . "</b>"; ?></td>
                                        </tr>
                                       
										
										<?php 
										
										$tax_deduction=mysql_fetch_array(mysql_query("select in_hand_salary ,gross,pf,esi,tds,ctc_amount from employee_salary_structures where employee_id='".$_GET['empl_id']."' group by start_date order by id desc" ));
										
										?>
										
											<tr>
											<td colspan="4" ><center><b>Tax  Deduction</b></center></td>
											</tr>
											<tr>
											
											<td colspan="3" ><b>PF</b></td>
											<td><?php  if($tax_deduction['pf']==1){ echo "<b>YES<b>"; }else {echo "NO";} ?>
											 </td>
											</tr>
											<tr>
											<td colspan="3" ><b>ESI</b></td>
											<td><?php if($tax_deduction['esi']==1){ echo "<b>YES<b>"; }else {echo "NO";} ?></td>
											</tr>
											<tr>
											<td colspan="3" ><b>TDS</b></td>
											<td><?php if($tax_deduction['tds']==1){ echo "<b>YES<b>"; }else {echo "NO";} ?></td>
											</tr>
											
											 <tr align="center">
                                            <td colspan="4"><b>Net Salary :-</b>&nbsp&nbsp;
                                                <?php echo "<b><i class='fa fa-fw fa-rupee'></i>" . formatMoney($fetch_deducto['net_salary']) . "&nbsp;<br> <i class='fa fa-fw fa-rupee'></i>" . ucwords(convert_number_to_words($fetch_deducto['net_salary'])) . "</b>"; ?></td>
                                        </tr>
											<?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="tab-pane <?php if (isset($_GET['active']) && !empty($_GET['active']) && $_GET['active'] == 'documents') { ?> active <?php } ?>" id="emp_documents">
                            <h3 align="center"> Employee Documents</h3>
                            <hr>
                            <div class="box-body table-responsive">
                                <table  class="table table-bordered">
                                    <tbody>
                                        <tr class="alert-danger">
                                            <td align="center" colspan="2"><h4>Employee Documents</h4></td>
                                            <td style="margin-top:10px; float:left;">
                                                <?php
                                                if (isset($_GET['increase']) && !empty($_GET['increase'])) {
                                                    ?>
                                                    <a href="employee_documentation.php?empl_id=<?php echo $_GET['empl_id']; ?>&&edit_id=<?php echo $_GET['empl_id']; ?>&&active=documents&&increase=<?php echo $_GET['increase']; ?>">
                                                        <input type="button" name="" value="Edit" class="btn btn-primary">
                                                    </a> 
                                                <?php } else { ?>

                                                    <a href="employee_documentation.php?empl_id=<?php echo $_GET['empl_id']; ?>&&edit_id=<?php echo $_GET['empl_id']; ?>&&active=documents">
                                                        <input type="button" name="" value="Edit" class="btn btn-primary">
                                                    </a>
                                                <?php } ?>

                                            </td>
                                        </tr>

                                        <?php
                                        $i = 1;
                                        while ($emp_doc = mysql_fetch_array($employees_document)) {
										
										$NAME=$emp_doc['doc_image_name'];
											$img2 = explode('.', $NAME);
											
											//echo $img2[0];
											//echo $img2[1];
                                            ?>
                                            <tr>
                                                <th><?php
                                                    $doc_name = mysql_fetch_array(mysql_query("select * from employee_document where id='" . $emp_doc['employee_document_id'] . "'"));
                                                    echo $doc_name['name'];
                                                    ?></th>
                                                <td class="right"><?php echo $emp_doc['document_no'] ?></td>
                                                <td>



                                                    <a href="#myModal_<?php echo $i; ?>" data-toggle="modal">
													<?php 
														
														 if($img2[1]=='pdf' || $img2[1]=='PDF'){ ?>
													<img src="../assets/icons/pdf.png" width="100" height="70" /></a>
 	                                <a href="../assets/user_image/employee_image/emp_document/<?php echo $emp_doc['doc_image_name']; ?>" target="_blank" download>view document file </a></td>
  
															 
														<?php 
															
															}ELSE{ ?>
												  <img src="../assets/user_image/employee_image/emp_document/<?php echo $emp_doc['doc_image_name']; ?>" width="100" height="70" /></a>
	<a href="../assets/user_image/employee_image/emp_document/<?php echo $emp_doc['doc_image_name']; ?>" target="_blank" download>view document file </a></td>

                                                    <div id="myModal_<?php echo $i; ?>" class="modal toggle">
                                                        <div class="modal-dialog">
                                                            <div class="modal-content">
                                                                <div class="modal-body">
                                                                    <div class="row">
                                                                        <img src="../assets/user_image/employee_image/emp_document/<?php echo $emp_doc['doc_image_name']; ?>" width="580" height="680"/>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

	
	
	<?PHP 
														}
														 ?>
												
        <!--                                        <a href="../assets/user_image/employee_image/emp_document/<?php echo $emp_doc['doc_image_name']; ?>">

                    <img src="../assets/user_image/employee_image/emp_document/<?php echo $emp_doc['doc_image_name']; ?>" width="100" height="70" /></a> </td>-->
                                            </tr>
                                            <?php $i++;
                                        }
                                        ?>
                                    </tbody>
                                </table>
                                <hr>
                            </div>
                        </div>

                        <div class="tab-pane <?php if (isset($_GET['active']) && !empty($_GET['active']) && $_GET['active'] == 'qualification') { ?> active <?php } ?>" id="qualifcation">
                            <h3 align="center"> Qualification Details</h3>
                            <hr>
                            <div class="box-body table-responsive">
                                <table  class="table table-bordered">
                                    <tbody>
                                        <tr class="alert-danger">
                                            <td align="center"><h4>Qualification Details</h4></td>
                                            <td style="margin-top:10px; float:left;">

                                                <?php
                                                if (isset($_GET['increase']) && !empty($_GET['increase'])) {
                                                    ?>
                                                    <a href="admission2_update.php?empl_id=<?php echo $_GET['empl_id'] ?>&&edit_id=<?php echo $sel_last['id']; ?>&&active=qualification&&increase=<?php echo $_GET['increase']; ?>">
                                                        <input type="button" name="" value="Edit" class="btn btn-primary">
                                                    </a> 
<?php } else { ?>

                                                    <a href="admission2_update.php?empl_id=<?php echo $_GET['empl_id'] ?>&&edit_id=<?php echo $sel_last['id']; ?>&&active=qualification">
                                                        <input type="button" name="" value="Edit" class="btn btn-primary">
                                                    </a>
<?php } ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td> Basic Graduation</td>
                                            <td class="right"><?php
                                                if ($sel_last['basic_graduation'] != '') {
                                                    $bgraud = $sel_last['basic_graduation'];
                                                } else {
                                                    $bgraud .="--------- ";
                                                }

                                                if ($sel_last['basic_specializ'] != '') {
                                                    $bspeli = $sel_last['basic_specializ'];
                                                } else {
                                                    $bspeli .="---- ";
                                                }

                                                if ($sel_last['basic_university'] != '') {
                                                    $buniver = $sel_last['basic_university'];
                                                } else {
                                                    $buniver .=" -------";
                                                }

                                                if ($sel_last['basic_year'] != '') {
                                                    $byear = $sel_last['basic_year'];
                                                } else {
                                                    $byear .="------- ";
                                                }
                                                if ($bgraud != '0') {

                                                    echo $bgraud . " ( " . $bspeli . " ) From " . $buniver . " " . $byear;
                                                }
                                                ?></td>
                                        </tr>
                                        <tr class="success">
                                            <td> Post Graduation</td>
                                            <td class="right"><?php
                                                if ($sel_last['post_graduation'] != '') {
                                                    $pgraud = $sel_last['post_graduation'];
                                                } else {
                                                    $pgraud .=" --------";
                                                }

                                                if ($sel_last['post_specializ'] != '') {
                                                    $pspeli = $sel_last['post_specializ'];
                                                } else {
                                                    $pspeli .="------- ";
                                                }

                                                if ($sel_last['post_university'] != '') {
                                                    $puniver = $sel_last['post_university'];
                                                } else {
                                                    $puniver .=" ------";
                                                }

                                                if ($sel_last['post_year'] != '') {
                                                    $pyear = $sel_last['post_year'];
                                                } else {
                                                    $pyear .="--------- ";
                                                }

                                                if ($pgraud != '0') {
                                                    echo $pgraud . " ( " . $pspeli . " ) From " . $puniver . " " . $pyear;
                                                }
                                                ?></td>
                                        </tr>
                                        <tr>
                                            <td> PHD/Doctorate</td>
                                            <td class="right"><?php
                                                if ($sel_last['phd_doctorate'] != '') {
                                                    $phgraud = $sel_last['phd_doctorate'];
                                                } else {
                                                    $phgraud .=" ------";
                                                }

                                                if ($sel_last['phd_specializ'] != '') {
                                                    $phspeli = $sel_last['phd_specializ'];
                                                } else {
                                                    $phspeli .=" ---------";
                                                }

                                                if ($sel_last['phd_university'] != '') {
                                                    $phuniver = $sel_last['phd_university'];
                                                } else {
                                                    $phuniver .=" ------";
                                                }

                                                if ($sel_last['phd_year'] != '') {
                                                    $phyear = $sel_last['phd_year'];
                                                } else {
                                                    $phyear .="------ ";
                                                }

                                                if ($phgraud != '0') {
                                                    echo $phgraud . " ( " . $phspeli . " ) From " . $phuniver . " " . $phyear;
                                                }
                                                ?></td>
                                        </tr>
                                        <tr class="success">
                                            <td> Diploma Certificate</td>
                                            <td class="right"><?php
                                                if ($sel_last['diploma_certif1'] != '') {
                                                    echo $sel_last['diploma_certif1'];
                                                } else {
                                                    echo " ";
                                                }
                                                ?></td>
                                        </tr>
                                        <tr>
                                            <td> Diploma Certificate</td>
                                            <td class="right"><?php
                                                if ($sel_last['diploma_certif2'] != '') {
                                                    echo $sel_last['diploma_certif2'];
                                                } else {
                                                    echo " ";
                                                }
                                                ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr>
                            </div>
                        </div>
                        <!--/tab-pane-->
                        <div class="tab-pane <?php if (isset($_GET['active']) && !empty($_GET['active']) && $_GET['active'] == 'exp') { ?> active <?php } ?>" id="experience">
                            <h3 align="center"> Experience Details</h3>
                            <hr>
                            <div class="box-body table-responsive">
                                <table  class="table table-bordered">
                                    <tbody>
                                        <tr class="alert-danger">
                                            <td align="center"><h4>Experience Details</h4></td>
                                            <td style="margin-top:10px; float:left;">

                                                <?php
                                                if (isset($_GET['increase']) && !empty($_GET['increase'])) {
                                                    ?>
                                                    <a href="admission3.php?empl_id=<?php echo $_GET['empl_id']; ?>&&edit_id=<?php echo $_GET['edit_id']; ?>&&active=exp&&salary=sal&&increase=<?php echo $_GET['increase']; ?>">
                                                        <input type="button" name="" value="Edit" class="btn btn-primary">
                                                    </a> 
<?php } else { ?>

                                                    <a href="admission3.php?empl_id=<?php echo $_GET['empl_id']; ?>&&edit_id=<?php echo $_GET['edit_id']; ?>&&active=exp">
                                                        <input type="button" name="" value="Edit" class="btn btn-primary">
                                                    </a>
<?php } ?>
                                            </td>
                                        </tr>
                                        <?php
                                        $num_row = mysql_num_rows($emp_exprence);

                                        if ($num_row > 0) {

                                            $number = 1;
                                            while ($rows = mysql_fetch_array($emp_exprence)) {
                                                ?>
                                                <tr>
                                                    <th colspan="2" align="center"><h3>
                                                <?php
                                                $ends = array('th', 'st', 'nd', 'rd', 'th', 'th', 'th', 'th', 'th', 'th');
                                                if (($number % 100) >= 11 && ($number % 100) <= 13)
                                                    $abbreviation = $number . 'th';
                                                else
                                                    $abbreviation = $number . $ends[$number % 10];

                                                echo $abbreviation . " Company Record";
                                                ?>
                                            </h3></th>
                                            </tr>
                                            <tr>
                                                <th>Last Company Name</th>
                                                <td class="right"><?php echo $rows['organisation']; ?></td>
                                            </tr>
                                            <tr class="success">
                                                <th>Reason For Leaving last company</th>
                                                <td class="right"><?php echo $rows['reason']; ?></td>
                                            </tr>
                                            <tr>
                                                <th>Job Profile</th>
                                                <td class="right"><?php echo $rows['job_profile']; ?></td>
                                            </tr>
                                            <tr class="success">
                                                <th>Total Experience</th>
                                                <td class="right"><?php echo $rows['totalexp']; ?></td>
                                            </tr>
                                            <?php
                                            $number++;
                                        }
                                    } else {
                                        ?>
                                        <tr>
                                            <th colspan="2" align="center"><h3>No Record Found</h3></th>
                                        </tr>
<?php } ?>
                                    </tbody>
                                </table>
                                <hr>
                            </div>
                        </div>
                        <div class="tab-pane <?php if (isset($_GET['active']) && !empty($_GET['active']) && $_GET['active'] == 'banking') { ?> active <?php } ?>" id="bank">
                            <h3 align="center">Bank Details</h3>
                            <hr>
                            <div class="box-body table-responsive">
                                <table  class="table table-bordered">
                                    <tbody>
                                        <tr class="alert-danger">
                                            <td align="center"><h4>Bank Details</h4></td>
                                            <td style="margin-top:10px; float:left;">
                                                <?php
                                                if (isset($_GET['increase']) && !empty($_GET['increase'])) {
                                                    ?>
                                                    <a href="bank_details.php?empl_id=<?php echo $_GET['empl_id']; ?>&&edit_id=<?php echo $_GET['edit_id']; ?>&&active=banking&&increase=<?php echo $_GET['increase']; ?>">
                                                        <input type="button" name="" value="Edit" class="btn btn-primary">
                                                    </a> 
<?php } else { ?>

                                                    <a href="bank_details.php?empl_id=<?php echo $_GET['empl_id']; ?>&&edit_id=<?php echo $_GET['edit_id']; ?>&&active=banking">
                                                        <input type="button" name="" value="Edit" class="btn btn-primary">
                                                    </a>
<?php } ?>     
                                            </td>
                                        </tr>

                                        <tr>
                                            <th> Account Holder Name </th>
                                            <td class="right"><?php
                                                if (isset($emp_bank['holder_name']) && !empty($emp_bank['holder_name'])) {
                                                    echo $emp_bank['holder_name'];
                                                }
                                                ?></td>
                                        </tr>
                                        <tr class="success">
                                            <th>A/c No. </th>
                                            <td class="right"><?php
                                                if (isset($emp_bank['account_no']) && !empty($emp_bank['account_no'])) {
                                                    echo $emp_bank['account_no'];
                                                }
                                                ?></td>
                                        </tr>
                                        <tr>
                                            <th> IFSC Code </th>
                                            <td class="right"><?php
                                                if (isset($emp_bank['ifsc_code']) && !empty($emp_bank['ifsc_code'])) {
                                                    echo $emp_bank['ifsc_code'];
                                                }
                                                ?></td>
                                        </tr>
                                        <tr class="success">
                                            <th> Bank Name </th>
                                            <td class="right"><?php
                                                $bank_name = mysql_fetch_array(mysql_query("select * from bank_list where id='" . $emp_bank['bank_field_id'] . "'"));

                                                if (isset($bank_name['bank_name']) && !empty($bank_name['bank_name'])) {
                                                    echo $bank_name['bank_name'];
                                                }
                                                ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Bank Location </th>
                                            <td class="right"><?php
                                                if (isset($emp_bank['bank_location']) && !empty($emp_bank['bank_location'])) {
                                                    echo $emp_bank['bank_location'];
                                                }
                                                ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr>
                            </div>
                        </div>
                        <!-- tab pane --->
                        <div class="tab-pane <?php if (isset($_GET['active']) && !empty($_GET['active'])) { ?> active <?php } ?>" id="additional">
                            <h3 align="center"> Additional Details</h3>
                            <hr>
                            <div class="box-body table-responsive">
                                <table  class="table table-bordered">
                                    <tbody>
                                        <tr class="alert-danger">
                                            <td align="center"><h4>Additional Details</h4></td>
                                           
											<td style="margin-top:10px; float:left;"><a href="additional_details.php?page_index=<?php echo base64_encode("2.4") ?>&&employee_id=<?php echo $_GET['empl_id']; ?>&&edit_id=<?php echo $_GET['empl_id']; ?>">
                                                    <input class="btn btn-primary" type="submit" value="Edit">
													</a>
                                            </td>	
												
												
                                        </tr>
                                    <?php $i = 0; ?>
                                    <input class="cattext"  name="name[]" type="hidden" />
                                    <?php
                                    while (($add_field = mysql_fetch_array($addititional_field))) {
                                        ?>
                                        <tr>
                                            <td></td>
                                            <td><?php
                                                $query = "select * from employee_additional_details where employee_id='" . $_GET['empl_id'] . "' and
		    														additional_field_id='" . $add_field[id] . "'";
                                                $sql = mysql_fetch_array(mysql_query($query));
                                                $num = mysql_num_rows(mysql_query($query));
                                                ?>
                                        <tr class="success">
                                            <td><?php echo $add_field[name]; ?></td>
                                            <td class="right"><?php
                                                if (isset($sql[additional_info])) {
                                                    if ($num > 1) {

                                                        for ($i = 0; $i < $num; $i++) {
                                                            $id = $sql['id'] + $i;
                                                            $query1 = "select * from employee_additional_details where  id='" . $id . "'";
                                                            $sql1 = mysql_fetch_array(mysql_query($query1));
                                                            echo $sql1['additional_info'] . ",";
                                                        }
                                                    } else {
                                                        echo $sql['additional_info'];
                                                    }
                                                } else {
                                                    ?>
                                                    Not Available
                                            <?php } ?></td>
                                        <?php $i++; ?>
                                        </tr>
                                        <?php
                                    }
                                    ?>
                                    </tbody>

                                </table>
                            </div>
                        </div>
                        <!--/tab-pane-->
                    </div>
                    <!--/tab-content-->
                </div>
                <!--/col-9-->
            </div>
            <!--/row-->
        </div>
        <!--/primary box-->
    </section>
    <!-- /.content -->
</aside>
<!-- /.right-side ------>
