-- --------------------------------------------------------
-- Host:                         localhost
-- Server version:               10.1.21-MariaDB - mariadb.org binary distribution
-- Server OS:                    Win32
-- HeidiSQL Version:             9.3.0.4984
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

-- Dumping structure for table chiru.activity_allow
CREATE TABLE IF NOT EXISTS `activity_allow` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `activity_id` int(11) DEFAULT NULL,
  `dep_id` int(11) DEFAULT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` int(11) NOT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.activity_allow: ~0 rows (approximately)
/*!40000 ALTER TABLE `activity_allow` DISABLE KEYS */;
/*!40000 ALTER TABLE `activity_allow` ENABLE KEYS */;


-- Dumping structure for table chiru.activity_noticeboard
CREATE TABLE IF NOT EXISTS `activity_noticeboard` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` enum('0','1') DEFAULT '0' COMMENT '0=inactive 1=active',
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` int(11) NOT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.activity_noticeboard: ~0 rows (approximately)
/*!40000 ALTER TABLE `activity_noticeboard` DISABLE KEYS */;
/*!40000 ALTER TABLE `activity_noticeboard` ENABLE KEYS */;


-- Dumping structure for table chiru.admin_approve_od_claim
CREATE TABLE IF NOT EXISTS `admin_approve_od_claim` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) DEFAULT NULL COMMENT 'session id user table id',
  `apply_od_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT '0' COMMENT '0 =for claim,1= claim approve,2=claim disapprove,3=paid',
  `remark` varchar(250) DEFAULT '0',
  `approving_manager` int(11) DEFAULT NULL COMMENT 'user table id',
  `amount` int(11) DEFAULT NULL,
  `actual_amount` int(11) DEFAULT NULL,
  `od_date` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.admin_approve_od_claim: ~0 rows (approximately)
/*!40000 ALTER TABLE `admin_approve_od_claim` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_approve_od_claim` ENABLE KEYS */;


-- Dumping structure for table chiru.all_director
CREATE TABLE IF NOT EXISTS `all_director` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dirctor_id` int(11) DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=5461;

-- Dumping data for table chiru.all_director: ~0 rows (approximately)
/*!40000 ALTER TABLE `all_director` DISABLE KEYS */;
/*!40000 ALTER TABLE `all_director` ENABLE KEYS */;


-- Dumping structure for table chiru.apply_leaves
CREATE TABLE IF NOT EXISTS `apply_leaves` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) DEFAULT NULL COMMENT 'session id user table id',
  `leave_type` enum('0','1') DEFAULT '0' COMMENT '0=paid,1=Unpaid',
  `employee_leave_types_id` int(11) DEFAULT NULL COMMENT '9999=shortleave, 8888=lwp',
  `is_half_day` tinyint(1) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `leave_sum` float DEFAULT '0',
  `reason` varchar(255) DEFAULT NULL,
  `approved` tinyint(1) DEFAULT '0' COMMENT '0 apply leave 1approve leave 2 disapprove',
  `viewed_by_manager` tinyint(1) DEFAULT '0',
  `manager_remark` varchar(255) DEFAULT NULL,
  `approving_manager` int(11) DEFAULT NULL COMMENT 'user table id',
  `apply_by_hr` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `leave_surrender_is` int(11) DEFAULT '0',
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=303;

-- Dumping data for table chiru.apply_leaves: ~0 rows (approximately)
/*!40000 ALTER TABLE `apply_leaves` DISABLE KEYS */;
/*!40000 ALTER TABLE `apply_leaves` ENABLE KEYS */;


-- Dumping structure for table chiru.apply_leaves_sur_log
CREATE TABLE IF NOT EXISTS `apply_leaves_sur_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) DEFAULT NULL COMMENT 'session id user table id',
  `apply_leave_id` int(11) DEFAULT NULL,
  `employee_leave_types_id` int(11) DEFAULT NULL,
  `is_half_day` tinyint(1) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `leave_sum` float DEFAULT '0',
  `reason` varchar(255) DEFAULT NULL,
  `approved` tinyint(1) DEFAULT '0',
  `viewed_by_manager` tinyint(1) DEFAULT '0',
  `manager_remark` varchar(255) DEFAULT NULL,
  `approving_manager` int(11) DEFAULT NULL,
  `apply_by_hr` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='when leave surrender then old date is store here and apply_leave table update end_date';

-- Dumping data for table chiru.apply_leaves_sur_log: ~0 rows (approximately)
/*!40000 ALTER TABLE `apply_leaves_sur_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `apply_leaves_sur_log` ENABLE KEYS */;


-- Dumping structure for table chiru.apply_od_present
CREATE TABLE IF NOT EXISTS `apply_od_present` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) DEFAULT NULL COMMENT 'session id user table id',
  `od_id` int(11) DEFAULT NULL,
  `mode` int(11) DEFAULT NULL,
  `assigned_project_id` int(11) DEFAULT NULL,
  `assigned_task_id` int(11) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `start_location` varchar(255) DEFAULT NULL,
  `end_location` varchar(255) DEFAULT NULL,
  `distance` varchar(255) DEFAULT NULL,
  `approved` tinyint(1) DEFAULT '0' COMMENT '0 apply leave 1approve leave 2 disapprove',
  `viewed_by_manager` tinyint(1) DEFAULT '0',
  `manager_remark` varchar(255) DEFAULT NULL,
  `approving_manager` int(11) DEFAULT NULL COMMENT 'user table id',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.apply_od_present: ~0 rows (approximately)
/*!40000 ALTER TABLE `apply_od_present` DISABLE KEYS */;
/*!40000 ALTER TABLE `apply_od_present` ENABLE KEYS */;


-- Dumping structure for table chiru.apply_short_leave
CREATE TABLE IF NOT EXISTS `apply_short_leave` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) DEFAULT NULL COMMENT 'session id user table id',
  `apply_leave_id` int(11) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `approving_manager` int(11) DEFAULT NULL COMMENT 'user table id',
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.apply_short_leave: ~0 rows (approximately)
/*!40000 ALTER TABLE `apply_short_leave` DISABLE KEYS */;
/*!40000 ALTER TABLE `apply_short_leave` ENABLE KEYS */;


-- Dumping structure for table chiru.attendance_modify_closing
CREATE TABLE IF NOT EXISTS `attendance_modify_closing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) DEFAULT NULL,
  `status` enum('Y','N') DEFAULT 'Y' COMMENT '''Y''=Active, ''N''=Inactive',
  `type` int(11) DEFAULT '1' COMMENT '1=''weekly'' , 2=''monthly'' , 3=''day wise''',
  `day` int(11) DEFAULT NULL,
  `created_by` varchar(45) DEFAULT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.attendance_modify_closing: ~0 rows (approximately)
/*!40000 ALTER TABLE `attendance_modify_closing` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendance_modify_closing` ENABLE KEYS */;


-- Dumping structure for table chiru.attendence_waving
CREATE TABLE IF NOT EXISTS `attendence_waving` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_id` int(11) DEFAULT NULL,
  `status` enum('Y','N') DEFAULT 'Y',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.attendence_waving: ~0 rows (approximately)
/*!40000 ALTER TABLE `attendence_waving` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendence_waving` ENABLE KEYS */;


-- Dumping structure for table chiru.bank_list
CREATE TABLE IF NOT EXISTS `bank_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_name` varchar(255) NOT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=166 DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=97;

-- Dumping data for table chiru.bank_list: ~165 rows (approximately)
/*!40000 ALTER TABLE `bank_list` DISABLE KEYS */;
INSERT INTO `bank_list` (`id`, `bank_name`, `company_id`) VALUES
	(1, 'ABHYUDAYA CO-OP BANK LTD', 0),
	(2, 'ABU DHABI COMMERCIAL BANK', 0),
	(3, 'AKOLA DISTRICT CENTRAL CO-OPERATIVE BANK', 0),
	(4, 'AKOLA JANATA COMMERCIAL COOPERATIVE BANK', 0),
	(5, 'ALLAHABAD BANK', 0),
	(6, 'ALMORA URBAN CO-OPERATIVE BANK LTD.', 0),
	(7, 'ANDHRA BANK', 0),
	(8, 'ANDHRA PRAGATHI GRAMEENA BANK', 0),
	(9, 'APNA SAHAKARI BANK LTD', 0),
	(10, 'AUSTRALIA AND NEW ZEALAND BANKING GROUP LIMITED.', 0),
	(11, 'AXIS BANK', 0),
	(12, 'BANK INTERNASIONAL INDONESIA', 0),
	(13, 'BANK OF AMERICA', 0),
	(14, 'BANK OF BAHRAIN AND KUWAIT', 0),
	(15, 'BANK OF BARODA', 0),
	(16, 'BANK OF CEYLON', 0),
	(17, 'BANK OF INDIA', 0),
	(18, 'BANK OF MAHARASHTRA', 0),
	(19, 'BANK OF TOKYO-MITSUBISHI UFJ LTD.', 0),
	(20, 'BARCLAYS BANK PLC', 0),
	(21, 'BASSEIN CATHOLIC CO-OP BANK LTD', 0),
	(22, 'BHARATIYA MAHILA BANK LIMITED', 0),
	(23, 'BNP PARIBAS', 0),
	(24, 'CALYON BANK', 0),
	(25, 'CANARA BANK', 0),
	(26, 'CAPITAL LOCAL AREA BANK LTD.', 0),
	(27, 'CATHOLIC SYRIAN BANK LTD.', 0),
	(28, 'CENTRAL BANK OF INDIA', 0),
	(29, 'CHINATRUST COMMERCIAL BANK', 0),
	(30, 'CITIBANK NA', 0),
	(31, 'CITIZENCREDIT CO-OPERATIVE BANK LTD', 0),
	(32, 'CITY UNION BANK LTD', 0),
	(33, 'COMMONWEALTH BANK OF AUSTRALIA', 0),
	(34, 'CORPORATION BANK', 0),
	(35, 'CREDIT SUISSE AG', 0),
	(36, 'DBS BANK LTD', 0),
	(37, 'DENA BANK', 0),
	(38, 'DEUTSCHE BANK', 0),
	(39, 'DEUTSCHE SECURITIES INDIA PRIVATE LIMITED', 0),
	(40, 'DEVELOPMENT CREDIT BANK LIMITED', 0),
	(41, 'DHANLAXMI BANK LTD', 0),
	(42, 'DICGC', 0),
	(43, 'DOMBIVLI NAGARI SAHAKARI BANK LIMITED', 0),
	(44, 'FIRSTRAND BANK LIMITED', 0),
	(45, 'GOPINATH PATIL PARSIK JANATA SAHAKARI BANK LTD', 0),
	(46, 'GURGAON GRAMIN BANK', 0),
	(47, 'HDFC BANK LTD', 0),
	(48, 'HSBC', 0),
	(49, 'ICICI BANK LTD', 0),
	(50, 'IDBI BANK LTD', 0),
	(51, 'IDRBT', 0),
	(52, 'INDIAN BANK', 0),
	(53, 'INDIAN OVERSEAS BANK', 0),
	(54, 'INDUSIND BANK LTD', 0),
	(55, 'INDUSTRIAL AND COMMERCIAL BANK OF CHINA LIMITED', 0),
	(56, 'ING VYSYA BANK LTD', 0),
	(57, 'JALGAON JANATA SAHKARI BANK LTD', 0),
	(58, 'JANAKALYAN SAHAKARI BANK LTD', 0),
	(59, 'JANASEVA SAHAKARI BANK (BORIVLI) LTD', 0),
	(60, 'JANASEVA SAHAKARI BANK LTD. PUNE', 0),
	(61, 'JANATA SAHAKARI BANK LTD (PUNE)', 0),
	(62, 'JPMORGAN CHASE BANK N.A', 0),
	(63, 'KALLAPPANNA AWADE ICH JANATA S BANK', 0),
	(64, 'KAPOL CO OP BANK', 0),
	(65, 'KARNATAKA BANK LTD', 0),
	(66, 'KARNATAKA VIKAS GRAMEENA BANK', 0),
	(67, 'KARUR VYSYA BANK', 0),
	(68, 'KOTAK MAHINDRA BANK', 0),
	(69, 'KURMANCHAL NAGAR SAHKARI BANK LTD', 0),
	(70, 'MAHANAGAR CO-OP BANK LTD', 0),
	(71, 'MAHARASHTRA STATE CO OPERATIVE BANK', 0),
	(72, 'MASHREQBANK PSC', 0),
	(73, 'MIZUHO CORPORATE BANK LTD', 0),
	(74, 'MUMBAI DISTRICT CENTRAL CO-OP. BANK LTD.', 0),
	(75, 'NAGPUR NAGRIK SAHAKARI BANK LTD', 0),
	(76, 'NATIONAL AUSTRALIA BANK', 0),
	(77, 'NEW INDIA CO-OPERATIVE BANK LTD.', 0),
	(78, 'NKGSB CO-OP BANK LTD', 0),
	(79, 'NORTH MALABAR GRAMIN BANK', 0),
	(80, 'NUTAN NAGARIK SAHAKARI BANK LTD', 0),
	(81, 'OMAN INTERNATIONAL BANK SAOG', 0),
	(82, 'ORIENTAL BANK OF COMMERCE', 0),
	(83, 'PARSIK JANATA SAHAKARI BANK LTD', 0),
	(84, 'PRATHAMA BANK', 0),
	(85, 'PRIME CO OPERATIVE BANK LTD', 0),
	(86, 'PUNJAB AND MAHARASHTRA CO-OP BANK LTD.', 0),
	(87, 'PUNJAB AND SIND BANK', 0),
	(88, 'PUNJAB NATIONAL BANK', 0),
	(89, 'RABOBANK INTERNATIONAL (CCRB)', 0),
	(90, 'RAJGURUNAGAR SAHAKARI BANK LTD.', 0),
	(91, 'RAJKOT NAGARIK SAHAKARI BANK LTD', 0),
	(92, 'RESERVE BANK OF INDIA', 0),
	(93, 'SBERBANK', 0),
	(94, 'SHINHAN BANK', 0),
	(95, 'SHRI CHHATRAPATI RAJARSHI SHAHU URBAN CO-OP BANK LTD', 0),
	(96, 'SOCIETE GENERALE', 0),
	(97, 'SOLAPUR JANATA SAHKARI BANK LTD.SOLAPUR', 0),
	(98, 'SOUTH INDIAN BANK', 0),
	(99, 'STANDARD CHARTERED BANK', 0),
	(100, 'STATE BANK OF BIKANER AND JAIPUR', 0),
	(101, 'STATE BANK OF HYDERABAD', 0),
	(102, 'STATE BANK OF INDIA', 0),
	(103, 'STATE BANK OF MAURITIUS LTD', 0),
	(104, 'STATE BANK OF MYSORE', 0),
	(105, 'STATE BANK OF PATIALA', 0),
	(106, 'STATE BANK OF TRAVANCORE', 0),
	(107, 'SUMITOMO MITSUI BANKING CORPORATION', 0),
	(108, 'SYNDICATE BANK', 0),
	(109, 'TAMILNAD MERCANTILE BANK LTD', 0),
	(110, 'THANE BHARAT SAHAKARI BANK LTD', 0),
	(111, 'THE A.P. MAHESH CO-OP URBAN BANK LTD.', 0),
	(112, 'THE AHMEDABAD MERCANTILE CO-OPERATIVE BANK LTD.', 0),
	(113, 'THE ANDHRA PRADESH STATE COOP BANK LTD', 0),
	(114, 'THE BANK OF NOVA SCOTIA', 0),
	(115, 'THE BANK OF RAJASTHAN LTD', 0),
	(116, 'THE BHARAT CO-OPERATIVE BANK (MUMBAI) LTD', 0),
	(117, 'THE COSMOS CO-OPERATIVE BANK LTD.', 0),
	(118, 'THE DELHI STATE COOPERATIVE BANK LTD.', 0),
	(119, 'THE FEDERAL BANK LTD', 0),
	(120, 'THE GADCHIROLI DISTRICT CENTRAL COOPERATIVE BANK LTD', 0),
	(121, 'THE GREATER BOMBAY CO-OP. BANK LTD', 0),
	(122, 'THE GUJARAT STATE CO-OPERATIVE BANK LTD', 0),
	(123, 'THE JALGAON PEOPLES CO-OP BANK', 0),
	(124, 'THE JAMMU AND KASHMIR BANK LTD', 0),
	(125, 'THE KALUPUR COMMERCIAL CO. OP. BANK LTD.', 0),
	(126, 'THE KALYAN JANATA SAHAKARI BANK LTD.', 0),
	(127, 'THE KANGRA CENTRAL CO-OPERATIVE BANK LTD', 0),
	(128, 'THE KANGRA COOPERATIVE BANK LTD', 0),
	(129, 'THE KARAD URBAN CO-OP BANK LTD', 0),
	(130, 'THE KARNATAKA STATE APEX COOP. BANK LTD.', 0),
	(131, 'THE LAKSHMI VILAS BANK LTD', 0),
	(132, 'THE MEHSANA URBAN COOPERATIVE BANK LTD', 0),
	(133, 'THE MUNICIPAL CO OPERATIVE BANK LTD MUMBAI', 0),
	(134, 'THE NAINITAL BANK LIMITED', 0),
	(135, 'THE NASIK MERCHANTS CO-OP BANK LTD., NASHIK', 0),
	(136, 'THE RAJASTHAN STATE COOPERATIVE BANK LTD.', 0),
	(137, 'THE RATNAKAR BANK LTD', 0),
	(138, 'THE ROYAL BANK OF SCOTLAND N.V', 0),
	(139, 'THE SAHEBRAO DESHMUKH CO-OP. BANK LTD.', 0),
	(140, 'THE SARASWAT CO-OPERATIVE BANK LTD', 0),
	(141, 'THE SEVA VIKAS CO-OPERATIVE BANK LTD (SVB)', 0),
	(142, 'THE SHAMRAO VITHAL CO-OPERATIVE BANK LTD', 0),
	(143, 'THE SURAT DISTRICT CO OPERATIVE BANK LTD.', 0),
	(144, 'THE SURAT PEOPLES CO-OP BANK LTD', 0),
	(145, 'THE SUTEX CO.OP. BANK LTD.', 0),
	(146, 'THE TAMILNADU STATE APEX COOPERATIVE BANK LIMITED', 0),
	(147, 'THE THANE DISTRICT CENTRAL CO-OP BANK LTD', 0),
	(148, 'THE THANE JANATA SAHAKARI BANK LTD', 0),
	(149, 'THE VARACHHA CO-OP. BANK LTD.', 0),
	(150, 'THE VISHWESHWAR SAHAKARI BANK LTD.,PUNE', 0),
	(151, 'THE WEST BENGAL STATE COOPERATIVE BANK LTD', 0),
	(152, 'TJSB SAHAKARI BANK LTD.', 0),
	(153, 'TUMKUR GRAIN MERCHANTS COOPERATIVE BANK LTD.', 0),
	(154, 'UBS AG', 0),
	(155, 'UCO BANK', 0),
	(156, 'UNION BANK OF INDIA', 0),
	(157, 'UNITED BANK OF INDIA', 0),
	(158, 'UNITED OVERSEAS BANK', 0),
	(159, 'VASAI VIKAS SAHAKARI BANK LTD.', 0),
	(160, 'VIJAYA BANK', 0),
	(161, 'WEST BENGAL STATE COOPERATIVE BANK', 0),
	(162, 'WESTPAC BANKING CORPORATION', 0),
	(163, 'WOORI BANK', 0),
	(164, 'YES BANK LTD', 0),
	(165, 'ZILA SAHKARI BANK LTD GHAZIABAD', 0);
/*!40000 ALTER TABLE `bank_list` ENABLE KEYS */;


-- Dumping structure for table chiru.birthday_wishes
CREATE TABLE IF NOT EXISTS `birthday_wishes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wishes` varchar(250) DEFAULT NULL,
  `wisher_id` int(11) DEFAULT NULL,
  `emp_id` int(11) DEFAULT NULL,
  `create_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.birthday_wishes: ~0 rows (approximately)
/*!40000 ALTER TABLE `birthday_wishes` DISABLE KEYS */;
/*!40000 ALTER TABLE `birthday_wishes` ENABLE KEYS */;


-- Dumping structure for table chiru.ceo
CREATE TABLE IF NOT EXISTS `ceo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_id` int(11) DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.ceo: ~0 rows (approximately)
/*!40000 ALTER TABLE `ceo` DISABLE KEYS */;
/*!40000 ALTER TABLE `ceo` ENABLE KEYS */;


-- Dumping structure for table chiru.claim_paid_attachment
CREATE TABLE IF NOT EXISTS `claim_paid_attachment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `claim_id` int(11) DEFAULT NULL,
  `img_path` text,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` int(11) NOT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.claim_paid_attachment: ~0 rows (approximately)
/*!40000 ALTER TABLE `claim_paid_attachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `claim_paid_attachment` ENABLE KEYS */;


-- Dumping structure for table chiru.clock_licence
CREATE TABLE IF NOT EXISTS `clock_licence` (
  `lin_id` int(11) NOT NULL AUTO_INCREMENT,
  `licence_key` longtext,
  PRIMARY KEY (`lin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.clock_licence: ~0 rows (approximately)
/*!40000 ALTER TABLE `clock_licence` DISABLE KEYS */;
/*!40000 ALTER TABLE `clock_licence` ENABLE KEYS */;


-- Dumping structure for table chiru.clock_local_licence
CREATE TABLE IF NOT EXISTS `clock_local_licence` (
  `lin_id` int(11) NOT NULL AUTO_INCREMENT,
  `licence_key` longtext,
  PRIMARY KEY (`lin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.clock_local_licence: ~0 rows (approximately)
/*!40000 ALTER TABLE `clock_local_licence` DISABLE KEYS */;
/*!40000 ALTER TABLE `clock_local_licence` ENABLE KEYS */;


-- Dumping structure for table chiru.coff_allow
CREATE TABLE IF NOT EXISTS `coff_allow` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dep_id` int(11) DEFAULT '0',
  `category_id` int(11) DEFAULT '0',
  `created_by` int(11) DEFAULT '0',
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.coff_allow: ~0 rows (approximately)
/*!40000 ALTER TABLE `coff_allow` DISABLE KEYS */;
/*!40000 ALTER TABLE `coff_allow` ENABLE KEYS */;


-- Dumping structure for table chiru.coff_apply
CREATE TABLE IF NOT EXISTS `coff_apply` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `c_off_id` int(11) DEFAULT NULL,
  `leave_id` int(11) DEFAULT NULL COMMENT 'apply_leaves (id)',
  `emp_id` int(11) DEFAULT NULL,
  `date` varchar(255) DEFAULT NULL,
  `half_day` enum('1','0') DEFAULT NULL COMMENT '1=half day, 0=full day',
  `reason` varchar(250) DEFAULT NULL,
  `reporting_mng_id` int(11) DEFAULT NULL,
  `created_on` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.coff_apply: ~0 rows (approximately)
/*!40000 ALTER TABLE `coff_apply` DISABLE KEYS */;
/*!40000 ALTER TABLE `coff_apply` ENABLE KEYS */;


-- Dumping structure for table chiru.coff_apply_rule
CREATE TABLE IF NOT EXISTS `coff_apply_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `all_weekoff` enum('1','0') DEFAULT '0',
  `holiday_check` enum('1','0') DEFAULT '0',
  `holidays_id` int(11) DEFAULT '0',
  `created_by` int(11) DEFAULT NULL,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.coff_apply_rule: ~0 rows (approximately)
/*!40000 ALTER TABLE `coff_apply_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `coff_apply_rule` ENABLE KEYS */;


-- Dumping structure for table chiru.coff_approval
CREATE TABLE IF NOT EXISTS `coff_approval` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_id` varchar(255) DEFAULT NULL,
  `working_hours` varchar(50) DEFAULT NULL,
  `c_off` float DEFAULT NULL,
  `approve_date` date DEFAULT '0000-00-00',
  `apply_date` date DEFAULT '0000-00-00',
  `approved_date` date DEFAULT '0000-00-00',
  `created_on` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `approve_by` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT '1' COMMENT '1=approve for apply, 2=applyed by employee, 3=approved',
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.coff_approval: ~0 rows (approximately)
/*!40000 ALTER TABLE `coff_approval` DISABLE KEYS */;
/*!40000 ALTER TABLE `coff_approval` ENABLE KEYS */;


-- Dumping structure for table chiru.coff_assign
CREATE TABLE IF NOT EXISTS `coff_assign` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_id` varchar(255) DEFAULT NULL,
  `year` varchar(255) DEFAULT NULL,
  `created_on` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.coff_assign: ~0 rows (approximately)
/*!40000 ALTER TABLE `coff_assign` DISABLE KEYS */;
/*!40000 ALTER TABLE `coff_assign` ENABLE KEYS */;


-- Dumping structure for table chiru.coff_general_rule_year
CREATE TABLE IF NOT EXISTS `coff_general_rule_year` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `start_coff` int(11) DEFAULT NULL,
  `expire_coff` int(11) DEFAULT NULL,
  `half_day` enum('1','0') NOT NULL DEFAULT '0' COMMENT '1=half day ,0=no halfday',
  `allow_before_holiday_weekoff` enum('1','0') NOT NULL DEFAULT '0' COMMENT '1="No",0=''Yes''',
  `allow_after_doj` int(11) DEFAULT NULL,
  `coff_half_day_min_hours` int(11) DEFAULT NULL,
  `coff_half_day_max_hours` int(11) DEFAULT NULL,
  `coff_full_day_min_hours` int(11) DEFAULT NULL,
  `coff_full_day_max_hours` int(11) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.coff_general_rule_year: ~0 rows (approximately)
/*!40000 ALTER TABLE `coff_general_rule_year` DISABLE KEYS */;
/*!40000 ALTER TABLE `coff_general_rule_year` ENABLE KEYS */;


-- Dumping structure for table chiru.company_master
CREATE TABLE IF NOT EXISTS `company_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_name` varchar(50) NOT NULL DEFAULT '0',
  `status` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0=>inactive,1=>active',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.company_master: ~0 rows (approximately)
/*!40000 ALTER TABLE `company_master` DISABLE KEYS */;
/*!40000 ALTER TABLE `company_master` ENABLE KEYS */;


-- Dumping structure for table chiru.countries
CREATE TABLE IF NOT EXISTS `countries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL DEFAULT '0',
  `sortname` varchar(3) NOT NULL,
  `name` varchar(150) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=213 DEFAULT CHARSET=utf8;

-- Dumping data for table chiru.countries: ~212 rows (approximately)
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
INSERT INTO `countries` (`id`, `company_id`, `sortname`, `name`) VALUES
	(1, 0, '', 'Afghanistan'),
	(2, 0, '', 'Albania'),
	(3, 0, '', 'Algeria'),
	(4, 0, '', 'Andorra'),
	(5, 0, '', 'Angola'),
	(6, 0, '', 'Antigua & Deps'),
	(7, 0, '', 'Argentina'),
	(8, 0, '', 'Armenia'),
	(9, 0, '', 'Australia'),
	(10, 0, '', 'Austria'),
	(11, 0, '', 'Azerbaijan'),
	(12, 0, '', 'Bahamas'),
	(13, 0, '', 'Bahrain'),
	(14, 0, '', 'Bangladesh'),
	(15, 0, '', 'Barbados'),
	(16, 0, '', 'Belarus'),
	(17, 0, '', 'Belgium'),
	(18, 0, '', 'Belize'),
	(19, 0, '', 'Benin'),
	(20, 0, '', 'Bhutan'),
	(21, 0, '', 'Bolivia'),
	(22, 0, '', 'Bosnia Herzegovina'),
	(23, 0, '', 'Botswana'),
	(24, 0, '', 'Brazil'),
	(25, 0, '', 'Brunei'),
	(26, 0, '', 'Bulgaria'),
	(27, 0, '', 'Burkina'),
	(28, 0, '', 'Burundi'),
	(29, 0, '', 'Cambodia'),
	(30, 0, '', 'Cameroon'),
	(31, 0, '', 'Canada'),
	(32, 0, '', 'Cape Verde'),
	(33, 0, '', 'Central African Rep'),
	(34, 0, '', 'Chad'),
	(35, 0, '', 'Chile'),
	(36, 0, '', 'China'),
	(37, 0, '', 'Colombia'),
	(38, 0, '', 'Comoros'),
	(39, 0, '', 'Congo'),
	(40, 0, '', 'Congo {Democratic Rep}'),
	(41, 0, '', 'Costa Rica'),
	(42, 0, '', 'Croatia'),
	(43, 0, '', 'Cuba'),
	(44, 0, '', 'Cyprus'),
	(45, 0, '', 'Czech Republic'),
	(46, 0, '', 'Denmark'),
	(47, 0, '', 'Djibouti'),
	(48, 0, '', 'Dominica'),
	(49, 0, '', 'Dominican Republic'),
	(50, 0, '', 'East Timor'),
	(51, 0, '', 'Ecuador'),
	(52, 0, '', 'Egypt'),
	(53, 0, '', 'El Salvador'),
	(54, 0, '', 'Equatorial Guinea'),
	(55, 0, '', 'Eritrea'),
	(56, 0, '', 'Estonia'),
	(57, 0, '', 'Ethiopia'),
	(58, 0, '', 'Fiji'),
	(59, 0, '', 'Finland'),
	(60, 0, '', 'France'),
	(61, 0, '', 'Gabon'),
	(62, 0, '', 'Gambia'),
	(63, 0, '', 'Georgia'),
	(64, 0, '', 'Germany'),
	(65, 0, '', 'Ghana'),
	(66, 0, '', 'Greece'),
	(67, 0, '', 'Grenada'),
	(68, 0, '', 'Guatemala'),
	(69, 0, '', 'Guinea'),
	(70, 0, '', 'Guinea-Bissau'),
	(71, 0, '', 'Guyana'),
	(72, 0, '', 'Haiti'),
	(73, 0, '', 'Honduras'),
	(74, 0, '', 'Hungary'),
	(75, 0, '', 'Iceland'),
	(76, 0, '', 'India'),
	(77, 0, '', 'Indonesia'),
	(78, 0, '', 'Iran'),
	(79, 0, '', 'Iraq'),
	(80, 0, '', 'Ireland {Republic}'),
	(81, 0, '', 'Israel'),
	(82, 0, '', 'Italy'),
	(83, 0, '', 'Ivory Coast'),
	(84, 0, '', 'Jamaica'),
	(85, 0, '', 'Japan'),
	(86, 0, '', 'Jordan'),
	(87, 0, '', 'Kazakhstan'),
	(88, 0, '', 'Kenya'),
	(89, 0, '', 'Kiribati'),
	(90, 0, '', 'Korea North'),
	(91, 0, '', 'Korea South'),
	(92, 0, '', 'Kosovo'),
	(93, 0, '', 'Kuwait'),
	(94, 0, '', 'Kyrgyzstan'),
	(95, 0, '', 'Laos'),
	(96, 0, '', 'Latvia'),
	(97, 0, '', 'Lebanon'),
	(98, 0, '', 'Lesotho'),
	(99, 0, '', 'Liberia'),
	(100, 0, '', 'Libya'),
	(101, 0, '', 'Liechtenstein'),
	(102, 0, '', 'Lithuania'),
	(103, 0, '', 'Luxembourg'),
	(104, 0, '', 'Macedonia'),
	(105, 0, '', 'Madagascar'),
	(106, 0, '', 'Malawi'),
	(107, 0, '', 'Malaysia'),
	(108, 0, '', 'Maldives'),
	(109, 0, '', 'Mali'),
	(110, 0, '', 'Malta'),
	(111, 0, '', 'Montenegro'),
	(112, 0, '', 'Marshall Islands'),
	(113, 0, '', 'Mauritania'),
	(114, 0, '', 'Mauritius'),
	(115, 0, '', 'Mexico'),
	(116, 0, '', 'Micronesia'),
	(117, 0, '', 'Moldova'),
	(118, 0, '', 'Monaco'),
	(119, 0, '', 'Mongolia'),
	(120, 0, '', 'Morocco'),
	(121, 0, '', 'Mozambique'),
	(122, 0, '', 'Myanmar, {Burma}'),
	(123, 0, '', 'Namibia'),
	(124, 0, '', 'Nauru'),
	(125, 0, '', 'Nepal'),
	(126, 0, '', 'Netherlands'),
	(127, 0, '', 'New Zealand'),
	(128, 0, '', 'Nicaragua'),
	(129, 0, '', 'Niger'),
	(130, 0, '', 'Nigeria'),
	(131, 0, '', 'Norway'),
	(132, 0, '', 'Oman'),
	(133, 0, '', 'Pakistan'),
	(134, 0, '', 'Palau'),
	(135, 0, '', 'Panama'),
	(136, 0, '', 'Papua New Guinea'),
	(137, 0, '', 'Paraguay'),
	(138, 0, '', 'Peru'),
	(139, 0, '', 'Philippines'),
	(140, 0, '', 'Poland'),
	(141, 0, '', 'Portugal'),
	(142, 0, '', 'Qatar'),
	(143, 0, '', 'Romania'),
	(144, 0, '', 'Russian Federation'),
	(145, 0, '', 'Rwanda'),
	(146, 0, '', 'St Kitts & Nevis'),
	(147, 0, '', 'St Lucia'),
	(148, 0, '', 'Saint Vincent & the Grenadines'),
	(149, 0, '', 'Samoa'),
	(150, 0, '', 'San Marino'),
	(151, 0, '', 'Sao Tome & Principe'),
	(152, 0, '', 'Saudi Arabia'),
	(153, 0, '', 'Senegal'),
	(154, 0, '', 'Serbia'),
	(155, 0, '', 'Seychelles'),
	(156, 0, '', 'Sierra Leone'),
	(157, 0, '', 'Singapore'),
	(158, 0, '', 'Slovakia'),
	(159, 0, '', 'Slovenia'),
	(160, 0, '', 'Solomon Islands'),
	(161, 0, '', 'Somalia'),
	(162, 0, '', 'South Africa'),
	(163, 0, '', 'Spain'),
	(164, 0, '', 'Sri Lanka'),
	(165, 0, '', 'Sudan'),
	(166, 0, '', 'Suriname'),
	(167, 0, '', 'Swaziland'),
	(168, 0, '', 'Sweden'),
	(169, 0, '', 'Switzerland'),
	(170, 0, '', 'Syria'),
	(171, 0, '', 'Taiwan'),
	(172, 0, '', 'Tajikistan'),
	(173, 0, '', 'Tanzania'),
	(174, 0, '', 'Thailand'),
	(175, 0, '', 'Togo'),
	(176, 0, '', 'Tonga'),
	(177, 0, '', 'Trinidad & Tobago'),
	(178, 0, '', 'Tunisia'),
	(179, 0, '', 'Turkey'),
	(180, 0, '', 'Turkmenistan'),
	(181, 0, '', 'Tuvalu'),
	(182, 0, '', 'Uganda'),
	(183, 0, '', 'Ukraine'),
	(184, 0, '', 'United Arab Emirates'),
	(185, 0, '', 'United Kingdom'),
	(186, 0, '', 'United States'),
	(187, 0, '', 'Uruguay'),
	(188, 0, '', 'Uzbekistan'),
	(189, 0, '', 'Vanuatu'),
	(190, 0, '', 'Vatican City'),
	(191, 0, '', 'Venezuela'),
	(192, 0, '', 'Vietnam'),
	(193, 0, '', 'Yemen'),
	(194, 0, '', 'Zambia'),
	(195, 0, '', 'Zimbabwe'),
	(196, 0, '', 'Palestine'),
	(197, 0, '', 'Burma'),
	(198, 0, '', 'Caicos'),
	(199, 0, '', 'Cook Islands'),
	(200, 0, '', 'CÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã‚Â ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬ÃƒÂ¢Ã¢â‚¬Å¾Ã‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢'),
	(201, 0, '', 'Democratic Peoples Republic of Korea'),
	(202, 0, '', 'Democratic Republic of the Congo'),
	(203, 0, '', 'Federation of Saint Kitts and Nevis'),
	(204, 0, '', 'Nagorno-Karabakh'),
	(205, 0, '', 'Republic of Korea'),
	(206, 0, '', 'Republic of the Congo'),
	(207, 0, '', 'Sahrawi Arab Democratic Republic'),
	(208, 0, '', 'Saint Lucia'),
	(209, 0, '', 'Sudan, South'),
	(210, 0, '', 'Timor-Leste'),
	(211, 0, '', 'Transnistria'),
	(212, 0, '', 'Turks');
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;


-- Dumping structure for table chiru.crm_assign_camp
CREATE TABLE IF NOT EXISTS `crm_assign_camp` (
  `ass_id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_id` int(11) NOT NULL,
  `camp_id` int(11) NOT NULL,
  `status` enum('Y','N') NOT NULL DEFAULT 'Y',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ass_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.crm_assign_camp: ~0 rows (approximately)
/*!40000 ALTER TABLE `crm_assign_camp` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_assign_camp` ENABLE KEYS */;


-- Dumping structure for table chiru.crm_basic_crm_reg
CREATE TABLE IF NOT EXISTS `crm_basic_crm_reg` (
  `crm_id` int(11) NOT NULL AUTO_INCREMENT,
  `camp_code` varchar(255) NOT NULL,
  `view` enum('Y','N') NOT NULL DEFAULT 'N',
  `stu_name` varchar(255) NOT NULL,
  `stu_father_name` varchar(255) NOT NULL,
  `stu_mom_name` varchar(255) NOT NULL,
  `stu_pro_name` varchar(255) NOT NULL,
  `stu_mob` varchar(255) NOT NULL,
  `stu_fat_mob` varchar(255) NOT NULL,
  `stu_mom_mob` varchar(255) NOT NULL,
  `stu_emial` varchar(255) NOT NULL,
  `stu_fat_email` varchar(255) NOT NULL,
  `stu_mom_email` varchar(255) NOT NULL,
  `stu_country` varchar(255) NOT NULL,
  `stu_state` varchar(255) NOT NULL,
  `stu_city` varchar(255) NOT NULL,
  `stu_school` varchar(255) NOT NULL,
  `stu_address` varchar(255) NOT NULL,
  `stu_cat` varchar(255) NOT NULL,
  PRIMARY KEY (`crm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.crm_basic_crm_reg: ~0 rows (approximately)
/*!40000 ALTER TABLE `crm_basic_crm_reg` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_basic_crm_reg` ENABLE KEYS */;


-- Dumping structure for table chiru.crm_campenig_details
CREATE TABLE IF NOT EXISTS `crm_campenig_details` (
  `camp_id` int(11) NOT NULL AUTO_INCREMENT,
  `camp_name` varchar(255) NOT NULL,
  `camp_code` varchar(255) NOT NULL,
  `camp_type` enum('I','O') NOT NULL DEFAULT 'I',
  `status` enum('Y','N') NOT NULL DEFAULT 'Y',
  PRIMARY KEY (`camp_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.crm_campenig_details: ~0 rows (approximately)
/*!40000 ALTER TABLE `crm_campenig_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_campenig_details` ENABLE KEYS */;


-- Dumping structure for table chiru.custom_report_emp
CREATE TABLE IF NOT EXISTS `custom_report_emp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `report_name` varchar(50) DEFAULT NULL,
  `report_details` longtext NOT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=8192 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.custom_report_emp: ~0 rows (approximately)
/*!40000 ALTER TABLE `custom_report_emp` DISABLE KEYS */;
/*!40000 ALTER TABLE `custom_report_emp` ENABLE KEYS */;


-- Dumping structure for table chiru.daily_report
CREATE TABLE IF NOT EXISTS `daily_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL DEFAULT '0',
  `report` text NOT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` enum('0','1') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.daily_report: ~0 rows (approximately)
/*!40000 ALTER TABLE `daily_report` DISABLE KEYS */;
/*!40000 ALTER TABLE `daily_report` ENABLE KEYS */;


-- Dumping structure for table chiru.dept_head
CREATE TABLE IF NOT EXISTS `dept_head` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dept_id` int(11) DEFAULT '0',
  `hod_id` int(11) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=1820;

-- Dumping data for table chiru.dept_head: ~0 rows (approximately)
/*!40000 ALTER TABLE `dept_head` DISABLE KEYS */;
/*!40000 ALTER TABLE `dept_head` ENABLE KEYS */;


-- Dumping structure for table chiru.employees
CREATE TABLE IF NOT EXISTS `employees` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_category_id` int(11) DEFAULT NULL,
  `employee_number` varchar(255) DEFAULT NULL,
  `joining_date` date DEFAULT NULL,
  `pf_number` varchar(255) DEFAULT NULL,
  `uan_number` varchar(255) DEFAULT NULL,
  `pancard_details` varchar(255) DEFAULT NULL,
  `esi` varchar(255) DEFAULT NULL,
  `tds` varchar(255) DEFAULT NULL,
  `prefix` varchar(255) DEFAULT NULL,
  `first_name` varchar(255) DEFAULT NULL,
  `middle_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `gender` varchar(255) DEFAULT NULL,
  `job_title` varchar(255) DEFAULT NULL,
  `posting_place` varchar(255) DEFAULT NULL,
  `reporting_place` varchar(255) DEFAULT NULL,
  `employee_position_id` int(11) DEFAULT NULL,
  `employee_department_id` int(11) DEFAULT NULL,
  `reporting_manager_id` int(11) DEFAULT NULL,
  `employee_grade_id` int(11) DEFAULT NULL,
  `qualification` varchar(255) DEFAULT NULL,
  `pan_card_no` varchar(255) DEFAULT NULL,
  `basic_graduation` varchar(255) DEFAULT NULL,
  `basic_specializ` varchar(255) DEFAULT NULL,
  `basic_university` varchar(255) DEFAULT NULL,
  `basic_year` varchar(255) DEFAULT NULL,
  `post_graduation` varchar(255) DEFAULT NULL,
  `post_specializ` varchar(255) DEFAULT NULL,
  `post_university` varchar(255) DEFAULT NULL,
  `post_year` varchar(255) DEFAULT NULL,
  `phd_doctorate` varchar(255) DEFAULT NULL,
  `phd_specializ` varchar(255) DEFAULT NULL,
  `phd_university` varchar(255) DEFAULT NULL,
  `phd_year` varchar(255) DEFAULT NULL,
  `diploma_certif1` varchar(255) DEFAULT NULL,
  `diploma_certif2` varchar(255) DEFAULT NULL,
  `experience_detail` text,
  `experience_year` int(11) DEFAULT NULL,
  `experience_month` int(11) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `status_description` varchar(255) DEFAULT NULL,
  `date_of_birth` date DEFAULT NULL,
  `marital_status` varchar(255) DEFAULT NULL,
  `children_count` int(11) DEFAULT NULL,
  `f_prefix` varchar(255) DEFAULT NULL,
  `father_name` varchar(255) DEFAULT NULL,
  `m_prefix` varchar(255) DEFAULT NULL,
  `mother_name` varchar(255) DEFAULT NULL,
  `h_prifix` varchar(255) DEFAULT NULL,
  `husband_name` varchar(255) DEFAULT NULL,
  `blood_group` varchar(255) DEFAULT NULL,
  `local_address_line1` varchar(255) DEFAULT NULL,
  `local_address_line2` varchar(255) DEFAULT NULL,
  `local_city` varchar(255) DEFAULT NULL,
  `local_state` varchar(255) DEFAULT NULL,
  `local_pin_code` varchar(255) DEFAULT NULL,
  `nationality_id` int(11) DEFAULT NULL,
  `nationality_type` varchar(255) DEFAULT NULL,
  `religion` varchar(255) DEFAULT NULL,
  `caste_id` int(11) DEFAULT '0',
  `birth_place` varchar(255) DEFAULT NULL,
  `domstate` varchar(255) DEFAULT NULL,
  `home_address_line1` varchar(255) DEFAULT NULL,
  `home_address_line2` varchar(255) DEFAULT NULL,
  `home_city` varchar(255) DEFAULT NULL,
  `home_state` varchar(255) DEFAULT NULL,
  `home_country_id` int(11) DEFAULT NULL,
  `embassy_name` varchar(255) DEFAULT NULL,
  `visa_issdate` date DEFAULT NULL,
  `visa_validity` date DEFAULT NULL,
  `visa_no` varchar(255) DEFAULT NULL,
  `home_pin_code` varchar(255) DEFAULT NULL,
  `passport_no` varchar(255) DEFAULT NULL,
  `passport_exp_date` date DEFAULT NULL,
  `office_address_line1` varchar(255) DEFAULT NULL,
  `office_address_line2` varchar(255) DEFAULT NULL,
  `office_city` varchar(255) DEFAULT NULL,
  `office_state` varchar(255) DEFAULT NULL,
  `office_country_id` int(11) DEFAULT NULL,
  `office_pin_code` varchar(255) DEFAULT NULL,
  `office_phone1` varchar(255) DEFAULT NULL,
  `office_phone2` varchar(255) DEFAULT NULL,
  `mobile_phone` varchar(255) DEFAULT NULL,
  `home_phone` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `offcial_email` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `photo_file_name` varchar(255) DEFAULT NULL,
  `photo_content_type` varchar(255) DEFAULT NULL,
  `photo_data` mediumblob,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `photo_file_size` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `library_card` varchar(255) DEFAULT NULL,
  `biometric_id` int(11) DEFAULT NULL,
  `bio_card_number` int(11) DEFAULT NULL,
  `reporting_mng` int(11) DEFAULT NULL,
  `leave_status` int(2) DEFAULT '1',
  `remark` text,
  `wishes` varchar(50) DEFAULT NULL,
  `is_deleted` int(11) NOT NULL DEFAULT '0' COMMENT '0= active , 1= inactive',
  `leave_date` date NOT NULL DEFAULT '0000-00-00',
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UK_employees_employee_number` (`employee_number`),
  KEY `index_employees_on_employee_number` (`employee_number`(10))
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=442 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.employees: ~0 rows (approximately)
/*!40000 ALTER TABLE `employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `employees` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_approve_od
CREATE TABLE IF NOT EXISTS `employee_approve_od` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) DEFAULT NULL COMMENT 'session id user table id',
  `apply_od_id` int(11) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `approved` tinyint(1) DEFAULT '0' COMMENT '0 apply leave 1approve leave 2 disapprove',
  `manager_remark` varchar(255) DEFAULT NULL,
  `approving_manager` int(11) DEFAULT NULL COMMENT 'user table id',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.employee_approve_od: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_approve_od` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_approve_od` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_attendances
CREATE TABLE IF NOT EXISTS `employee_attendances` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) DEFAULT NULL COMMENT 'this is session id so this users id table id',
  `punch_in_date` datetime DEFAULT NULL,
  `punch_out` datetime DEFAULT '0000-00-00 00:00:00',
  `attendance_date` datetime DEFAULT NULL,
  `employee_leave_type_id` int(11) DEFAULT NULL,
  `leave_reason` varchar(255) DEFAULT NULL,
  `is_half_day` tinyint(1) DEFAULT NULL,
  `by_hr` tinyint(11) DEFAULT NULL COMMENT 'this is hr admin id (user table id ) if attendence taken by hr',
  `status` enum('N','Y') NOT NULL DEFAULT 'N',
  `attendence_type` varchar(255) DEFAULT NULL,
  `from_device` enum('0','1') DEFAULT '0' COMMENT '0= Punch In,1= Bio Matrix',
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=240;

-- Dumping data for table chiru.employee_attendances: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_attendances` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_attendances` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_attendances_log
CREATE TABLE IF NOT EXISTS `employee_attendances_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) DEFAULT NULL,
  `employee_attendances_id` int(11) NOT NULL,
  `punch_in_date` datetime DEFAULT NULL,
  `punch_out` datetime DEFAULT NULL,
  `attendance_date` datetime DEFAULT NULL,
  `attendence_type` varchar(255) DEFAULT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=131;

-- Dumping data for table chiru.employee_attendances_log: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_attendances_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_attendances_log` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_bank_details
CREATE TABLE IF NOT EXISTS `employee_bank_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) DEFAULT NULL,
  `bank_field_id` int(11) DEFAULT NULL,
  `bank_info` varchar(255) DEFAULT NULL,
  `account_no` varchar(255) DEFAULT NULL,
  `ifsc_code` varchar(255) DEFAULT NULL,
  `holder_name` varchar(255) DEFAULT NULL,
  `bank_location` varchar(255) DEFAULT NULL,
  `date_modifield` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=58;

-- Dumping data for table chiru.employee_bank_details: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_bank_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_bank_details` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_categories
CREATE TABLE IF NOT EXISTS `employee_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `prefix` varchar(255) DEFAULT NULL,
  `status` enum('Y','N') DEFAULT 'Y',
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.employee_categories: ~4 rows (approximately)
/*!40000 ALTER TABLE `employee_categories` DISABLE KEYS */;
INSERT INTO `employee_categories` (`id`, `name`, `prefix`, `status`, `created_date`, `company_id`) VALUES
	(1, 'Permanent', NULL, 'Y', '2015-03-13 15:27:21', 0),
	(2, 'Trainee', NULL, 'Y', '2015-03-13 15:27:38', 0),
	(3, 'contracty', NULL, 'N', '2015-03-13 15:28:18', 0),
	(4, 'on probatin', NULL, 'Y', '2015-03-23 16:16:49', 0);
/*!40000 ALTER TABLE `employee_categories` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_departments
CREATE TABLE IF NOT EXISTS `employee_departments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `emp_cat_id` varchar(255) NOT NULL DEFAULT '0',
  `status` enum('Y','N') DEFAULT 'Y',
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=1489 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.employee_departments: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_departments` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_document
CREATE TABLE IF NOT EXISTS `employee_document` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `mandatory` varchar(255) DEFAULT NULL,
  `status` enum('Y','N') DEFAULT 'Y',
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.employee_document: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_document` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_document` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_epf_contribution
CREATE TABLE IF NOT EXISTS `employee_epf_contribution` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) DEFAULT NULL COMMENT 'employee table id',
  `salary_grp_id` int(11) DEFAULT NULL,
  `employeer_epf` varchar(255) NOT NULL,
  `employee_epf` varchar(255) DEFAULT NULL,
  `ctc_amount` int(11) DEFAULT NULL,
  `createed` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `start_date` date DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.employee_epf_contribution: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_epf_contribution` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_epf_contribution` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_experience
CREATE TABLE IF NOT EXISTS `employee_experience` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `from_year` varchar(255) DEFAULT NULL,
  `start_month` varchar(255) DEFAULT NULL,
  `to_year` varchar(255) DEFAULT NULL,
  `end_month` varchar(255) NOT NULL,
  `totalexp` varchar(255) DEFAULT NULL,
  `organisation` varchar(255) DEFAULT NULL,
  `job_profile` varchar(255) DEFAULT NULL,
  `reason` varchar(255) DEFAULT NULL,
  `employee_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=512;

-- Dumping data for table chiru.employee_experience: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_experience` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_experience` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_group
CREATE TABLE IF NOT EXISTS `employee_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `loc_id` int(11) DEFAULT NULL,
  `status` enum('Y','N') DEFAULT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.employee_group: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_group` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_jobs
CREATE TABLE IF NOT EXISTS `employee_jobs` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `dept_name_id` varchar(255) DEFAULT NULL,
  `desig_name_id` varchar(255) DEFAULT NULL,
  `job_title` varchar(255) DEFAULT NULL,
  `job_desc` longtext,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.employee_jobs: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_jobs` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_leaves
CREATE TABLE IF NOT EXISTS `employee_leaves` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) DEFAULT NULL,
  `apply_leave_id` int(11) DEFAULT NULL,
  `leave_type` enum('0','1') DEFAULT '0' COMMENT '0=paid,1=Unpaid',
  `employee_leave_type_id` int(11) DEFAULT NULL,
  `leave_date` date DEFAULT NULL,
  `leave_end_date` date DEFAULT NULL,
  `leave_surrender_date` date DEFAULT NULL,
  `leave_count` float DEFAULT '0',
  `apply_by_hr` int(11) DEFAULT '0' COMMENT 'this is session id',
  `approving_manager` int(11) DEFAULT '0',
  `surrender_by` int(11) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=862 COMMENT='when leave is approve then data is save here';

-- Dumping data for table chiru.employee_leaves: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_leaves` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_leaves` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_leave_sur_log
CREATE TABLE IF NOT EXISTS `employee_leave_sur_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) DEFAULT NULL,
  `apply_leave_id` int(11) DEFAULT NULL,
  `empl_leave_id` int(11) DEFAULT NULL,
  `employee_leave_type_id` int(11) DEFAULT NULL,
  `leave_date` date DEFAULT NULL,
  `leave_end_date` date DEFAULT NULL,
  `leave_surrender_date` date DEFAULT NULL,
  `leave_count` float DEFAULT '0',
  `apply_by_hr` int(11) DEFAULT '0' COMMENT 'this is session id',
  `surrender_by` int(11) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='all leave surrender record save here after approve leave ,surrender leave';

-- Dumping data for table chiru.employee_leave_sur_log: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_leave_sur_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_leave_sur_log` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_leave_types
CREATE TABLE IF NOT EXISTS `employee_leave_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `one_timeleave` int(11) DEFAULT '0',
  `leave_absent` varchar(255) DEFAULT NULL COMMENT 'leave abbribiation',
  `halfday` tinyint(1) DEFAULT '0',
  `status` enum('Y','N') DEFAULT 'Y',
  `max_leave_count` varchar(255) DEFAULT NULL,
  `paid_unpaid` enum('0','1') DEFAULT '0' COMMENT '0=paid 1=unpaid',
  `carryout_leave` int(11) DEFAULT '0' COMMENT '0=no_carryleave,1=>carry_leave',
  `year` year(4) DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=1638;

-- Dumping data for table chiru.employee_leave_types: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_leave_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_leave_types` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_mon_arrer_details
CREATE TABLE IF NOT EXISTS `employee_mon_arrer_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) DEFAULT NULL COMMENT 'employee table id',
  `total_present` double unsigned DEFAULT NULL,
  `totalworking_day` double DEFAULT NULL COMMENT 'this day is already define or dynamic define',
  `net_salary` double DEFAULT NULL,
  `present_month_salary` double DEFAULT NULL,
  `arrear_days` double DEFAULT NULL,
  `arrer_date` varchar(50) DEFAULT NULL,
  `arrear_amount` double DEFAULT NULL,
  `date` date NOT NULL,
  `is_paid` enum('0','1','2','3') NOT NULL DEFAULT '0' COMMENT '0=pending,1=approve,2=disapprove,3=paid',
  `createed` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.employee_mon_arrer_details: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_mon_arrer_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_mon_arrer_details` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_mon_attendance_approve
CREATE TABLE IF NOT EXISTS `employee_mon_attendance_approve` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) DEFAULT NULL COMMENT 'employee table id',
  `present` double DEFAULT NULL,
  `holidays` double DEFAULT NULL,
  `week_off` double DEFAULT NULL,
  `leaves` double DEFAULT NULL,
  `leave_unpaid` double DEFAULT NULL,
  `absent` double DEFAULT NULL,
  `total_present` double DEFAULT NULL,
  `totalworking_day` double DEFAULT NULL COMMENT 'this day is already define or dynamic define',
  `date` date NOT NULL,
  `pmo_remark` varchar(100) NOT NULL,
  `hr_remark` varchar(100) NOT NULL,
  `coo_remark` varchar(100) NOT NULL,
  `is_approved` enum('0','1','2') NOT NULL DEFAULT '0' COMMENT '0=pending,1=approve,2=disapprove',
  `createed` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.employee_mon_attendance_approve: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_mon_attendance_approve` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_mon_attendance_approve` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_mon_attendance_approve_upload
CREATE TABLE IF NOT EXISTS `employee_mon_attendance_approve_upload` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) DEFAULT NULL COMMENT 'employee table id',
  `present` double DEFAULT NULL,
  `holidays` double DEFAULT NULL,
  `week_off` double DEFAULT NULL,
  `leaves` double DEFAULT NULL,
  `leave_unpaid` double DEFAULT NULL,
  `absent` double DEFAULT NULL,
  `total_present` double DEFAULT NULL,
  `totalworking_day` double DEFAULT NULL COMMENT 'this day is already define or dynamic define',
  `date` date NOT NULL,
  `pmo_remark` varchar(100) NOT NULL,
  `hr_remark` varchar(100) NOT NULL,
  `coo_remark` varchar(100) NOT NULL,
  `is_approved` enum('0','1','2') NOT NULL DEFAULT '0' COMMENT '0=pending,1=approve,2=disapprove',
  `createed` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=393426 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.employee_mon_attendance_approve_upload: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_mon_attendance_approve_upload` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_mon_attendance_approve_upload` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_mon_deduction_details
CREATE TABLE IF NOT EXISTS `employee_mon_deduction_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) DEFAULT NULL COMMENT 'employee table id',
  `current_salary` double unsigned DEFAULT NULL,
  `arrear` double DEFAULT NULL,
  `net_salary` double DEFAULT NULL,
  `gross_salary` double DEFAULT NULL,
  `epf_amount` float DEFAULT NULL,
  `esi_amount` float DEFAULT NULL,
  `tds_amount` float DEFAULT NULL,
  `deduction_amount` float DEFAULT NULL,
  `net_pay` double DEFAULT NULL,
  `date` date NOT NULL,
  `is_paid` enum('0','1','2','3') NOT NULL DEFAULT '0' COMMENT '0=pending,1=approve,2=disapprove,3=paid',
  `createed` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.employee_mon_deduction_details: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_mon_deduction_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_mon_deduction_details` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_mon_otherdeduction_details
CREATE TABLE IF NOT EXISTS `employee_mon_otherdeduction_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) DEFAULT NULL COMMENT 'employee table id',
  `deduction_amount` float DEFAULT NULL,
  `deduction_id` float DEFAULT NULL,
  `date` varchar(50) NOT NULL DEFAULT '0000-00-00',
  `is_paid` enum('0','1','2','3') NOT NULL DEFAULT '0' COMMENT '0=pending,1=approve,2=disapprove,3=paid',
  `createed` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.employee_mon_otherdeduction_details: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_mon_otherdeduction_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_mon_otherdeduction_details` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_mon_salary_generate
CREATE TABLE IF NOT EXISTS `employee_mon_salary_generate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) DEFAULT NULL COMMENT 'employee table id',
  `present` double DEFAULT NULL,
  `holidays` double DEFAULT NULL,
  `week_off` double DEFAULT NULL,
  `leaves` double DEFAULT NULL,
  `leave_unpaid` double DEFAULT NULL,
  `absent` double DEFAULT NULL,
  `total_present` double DEFAULT NULL,
  `totalworking_day` double DEFAULT NULL COMMENT 'this day is already define or dynamic define',
  `net_salary` double DEFAULT NULL,
  `present_month_salary` double DEFAULT NULL,
  `date` date NOT NULL,
  `is_generate` enum('0','1','2','3') NOT NULL DEFAULT '0' COMMENT '0=pending,1=approve,2=disapprove,3=paid',
  `createed` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.employee_mon_salary_generate: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_mon_salary_generate` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_mon_salary_generate` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_od_claim
CREATE TABLE IF NOT EXISTS `employee_od_claim` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) DEFAULT NULL COMMENT 'session id user table id',
  `apply_od_id` int(11) DEFAULT NULL,
  `amount` int(11) DEFAULT NULL,
  `approve_amount` int(11) DEFAULT NULL,
  `actual_amount` int(11) DEFAULT NULL,
  `remark` varchar(250) DEFAULT NULL,
  `manager_remark` varchar(250) DEFAULT NULL,
  `admin_remark` varchar(250) DEFAULT NULL,
  `accountant_remark` varchar(250) DEFAULT NULL,
  `status` int(11) DEFAULT '0' COMMENT '0 =for claim,1= claim approve,2=claim disapprove,3=paid',
  `approving_manager` int(11) unsigned DEFAULT NULL COMMENT 'user table id',
  `approving_accountant` int(11) unsigned DEFAULT NULL,
  `reporting_manager` int(11) unsigned DEFAULT NULL,
  `admin_manager` int(11) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.employee_od_claim: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_od_claim` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_od_claim` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_positions
CREATE TABLE IF NOT EXISTS `employee_positions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `employee_category_id` varchar(255) DEFAULT NULL,
  `status` enum('Y','N') DEFAULT 'Y',
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=1638;

-- Dumping data for table chiru.employee_positions: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_positions` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_positions` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_salary_mon_payslip
CREATE TABLE IF NOT EXISTS `employee_salary_mon_payslip` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) DEFAULT NULL COMMENT 'employee table id',
  `payroll_category_id` varchar(50) DEFAULT NULL,
  `is_deduction` int(11) DEFAULT NULL,
  `is_arrear` int(11) DEFAULT NULL,
  `salary_grp_id` int(11) DEFAULT NULL,
  `amount` varchar(255) NOT NULL,
  `total_earning` varchar(255) DEFAULT NULL,
  `total_deduction` varchar(255) DEFAULT NULL,
  `net_salary` varchar(255) DEFAULT NULL,
  `current_net_salary` int(11) NOT NULL COMMENT 'calculated salary',
  `persent_month_salary` int(11) NOT NULL COMMENT 'with out pf esi and tds diduction',
  `arrear_amount` int(11) NOT NULL,
  `pf` varchar(255) NOT NULL,
  `esi` varchar(255) NOT NULL,
  `tds` varchar(255) NOT NULL,
  `date` date NOT NULL,
  `is_paid` enum('0','1','2','3','4') NOT NULL DEFAULT '0' COMMENT '0=pending,1=approve,2=disapprove,3= paid,4= Salary on hold',
  `createed` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=1260;

-- Dumping data for table chiru.employee_salary_mon_payslip: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_salary_mon_payslip` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_salary_mon_payslip` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_salary_structures
CREATE TABLE IF NOT EXISTS `employee_salary_structures` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) DEFAULT NULL COMMENT 'employee table id',
  `payroll_category_id` varchar(50) DEFAULT NULL,
  `is_deduction` int(11) DEFAULT NULL,
  `salary_grp_id` int(11) DEFAULT NULL,
  `amount` varchar(255) NOT NULL,
  `total_earning` varchar(255) DEFAULT NULL,
  `gross` varchar(255) DEFAULT NULL,
  `in_hand_salary` varchar(255) DEFAULT NULL,
  `ctc_amount` varchar(255) DEFAULT NULL,
  `total_deduction` varchar(255) DEFAULT NULL,
  `net_salary` varchar(255) DEFAULT NULL,
  `tax_amount` float DEFAULT NULL,
  `deduction_from` int(11) DEFAULT NULL,
  `pf` enum('0','1') DEFAULT '0',
  `esi` enum('0','1') DEFAULT '0',
  `tds` enum('0','1') DEFAULT '0',
  `createed` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=327;

-- Dumping data for table chiru.employee_salary_structures: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_salary_structures` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_salary_structures` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_shift
CREATE TABLE IF NOT EXISTS `employee_shift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `loc_id` int(11) NOT NULL,
  `start_time` time NOT NULL,
  `punching_time` time NOT NULL,
  `end_time` time NOT NULL,
  `punchout_time` time NOT NULL,
  `working_hours` varchar(11) NOT NULL,
  `gross_time` time NOT NULL COMMENT 'this is minute',
  `half_day_time` time NOT NULL,
  `next_day` enum('1','0') NOT NULL DEFAULT '0' COMMENT '''1''=''next day'',''0''=''same day''',
  `created_date/updated_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.employee_shift: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_shift` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_shift` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_status
CREATE TABLE IF NOT EXISTS `employee_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.employee_status: ~4 rows (approximately)
/*!40000 ALTER TABLE `employee_status` DISABLE KEYS */;
INSERT INTO `employee_status` (`id`, `name`, `company_id`) VALUES
	(1, 'Active', 0),
	(2, 'Inactive', 0),
	(3, 'Terminat', 0),
	(4, 'Resign', 0);
/*!40000 ALTER TABLE `employee_status` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_week_day_set
CREATE TABLE IF NOT EXISTS `employee_week_day_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `years` int(11) NOT NULL,
  `loc_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `days` varchar(255) NOT NULL,
  `week_day/week_end` int(11) NOT NULL COMMENT 'weekday=1 and weekend=0',
  `created_date/updated_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=99;

-- Dumping data for table chiru.employee_week_day_set: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_week_day_set` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_week_day_set` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_week_day_set_log
CREATE TABLE IF NOT EXISTS `employee_week_day_set_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `years` int(11) NOT NULL,
  `loc_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `days` varchar(255) NOT NULL,
  `week_day/week_end` int(11) NOT NULL COMMENT 'weekday=1 and weekend=0',
  `created_date/updated_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=48;

-- Dumping data for table chiru.employee_week_day_set_log: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_week_day_set_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_week_day_set_log` ENABLE KEYS */;


-- Dumping structure for table chiru.employee_working_hours_set
CREATE TABLE IF NOT EXISTS `employee_working_hours_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `loc_id` int(11) NOT NULL DEFAULT '0',
  `years` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `days` varchar(255) NOT NULL,
  `start_time` time NOT NULL,
  `end_time` time NOT NULL,
  `working_hours` varchar(11) NOT NULL,
  `gross_time` time NOT NULL COMMENT 'this is minute',
  `half_day_time` time NOT NULL,
  `created_date/updated_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=123;

-- Dumping data for table chiru.employee_working_hours_set: ~0 rows (approximately)
/*!40000 ALTER TABLE `employee_working_hours_set` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_working_hours_set` ENABLE KEYS */;


-- Dumping structure for table chiru.emp_document_info
CREATE TABLE IF NOT EXISTS `emp_document_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_document_id` int(11) DEFAULT NULL,
  `document_no` varchar(255) DEFAULT NULL,
  `doc_status` enum('Y','N') DEFAULT NULL,
  `doc_image_name` varchar(255) DEFAULT NULL,
  `employee_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.emp_document_info: ~0 rows (approximately)
/*!40000 ALTER TABLE `emp_document_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `emp_document_info` ENABLE KEYS */;


-- Dumping structure for table chiru.emp_hra_deduction
CREATE TABLE IF NOT EXISTS `emp_hra_deduction` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_id` int(11) NOT NULL DEFAULT '0',
  `year_id` int(11) NOT NULL DEFAULT '0',
  `hra_allow` varchar(50) NOT NULL DEFAULT '0',
  `payroll_id` int(11) NOT NULL DEFAULT '0',
  `anual_income` int(11) NOT NULL DEFAULT '0',
  `city` varchar(255) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `rent` int(11) DEFAULT NULL,
  `rule_1` int(11) DEFAULT NULL,
  `rule_2` int(11) DEFAULT NULL,
  `rule_3` int(11) DEFAULT NULL,
  `total_hra` int(11) DEFAULT NULL,
  `add_date` datetime DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.emp_hra_deduction: ~0 rows (approximately)
/*!40000 ALTER TABLE `emp_hra_deduction` DISABLE KEYS */;
/*!40000 ALTER TABLE `emp_hra_deduction` ENABLE KEYS */;


-- Dumping structure for table chiru.emp_income_tax
CREATE TABLE IF NOT EXISTS `emp_income_tax` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year_id` int(11) NOT NULL DEFAULT '0',
  `age_id` int(11) NOT NULL DEFAULT '0',
  `anual_tax` int(11) NOT NULL DEFAULT '0',
  `payble_tax_income` int(11) NOT NULL DEFAULT '0',
  `emp_id` int(11) NOT NULL DEFAULT '0',
  `department_id` int(11) NOT NULL DEFAULT '0',
  `total_tax_nod` int(11) NOT NULL DEFAULT '0',
  `taxable_income` int(11) NOT NULL DEFAULT '0',
  `income_taxfinal` int(11) NOT NULL DEFAULT '0',
  `tax_payable` int(11) NOT NULL DEFAULT '0',
  `total_dedution` int(11) NOT NULL DEFAULT '0',
  `total_grp_deduction` int(11) NOT NULL DEFAULT '0',
  `tax_liability` int(11) NOT NULL DEFAULT '0',
  `tax_credit` int(11) NOT NULL DEFAULT '0',
  `tds_rate` float NOT NULL DEFAULT '0',
  `edt` int(11) NOT NULL DEFAULT '0',
  `ta1` int(11) NOT NULL DEFAULT '0',
  `ta2` int(11) NOT NULL DEFAULT '0',
  `ta3` int(11) NOT NULL DEFAULT '0',
  `ta4` int(11) NOT NULL DEFAULT '0',
  `ta5` int(11) NOT NULL DEFAULT '0',
  `tb1` int(11) NOT NULL DEFAULT '0',
  `tb2` int(11) NOT NULL DEFAULT '0',
  `tb3` int(11) NOT NULL DEFAULT '0',
  `tb4` int(11) NOT NULL DEFAULT '0',
  `tb5` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.emp_income_tax: ~0 rows (approximately)
/*!40000 ALTER TABLE `emp_income_tax` DISABLE KEYS */;
/*!40000 ALTER TABLE `emp_income_tax` ENABLE KEYS */;


-- Dumping structure for table chiru.emp_ledger
CREATE TABLE IF NOT EXISTS `emp_ledger` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_id` int(11) DEFAULT NULL,
  `trans_date` date DEFAULT NULL,
  `for_month` varchar(50) DEFAULT NULL,
  `perticular` enum('1','2') DEFAULT NULL COMMENT '1=salary,2=other expence,3=salary advance',
  `perticular_details` varchar(255) DEFAULT NULL,
  `dr` varchar(255) DEFAULT '0',
  `cr` varchar(255) DEFAULT '0',
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.emp_ledger: ~0 rows (approximately)
/*!40000 ALTER TABLE `emp_ledger` DISABLE KEYS */;
/*!40000 ALTER TABLE `emp_ledger` ENABLE KEYS */;


-- Dumping structure for table chiru.epf_esi_details
CREATE TABLE IF NOT EXISTS `epf_esi_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_epf` float DEFAULT NULL,
  `employeer_epf` float DEFAULT NULL,
  `employee_esi` float DEFAULT NULL,
  `epf_both_onlyemp` enum('Y','N') DEFAULT 'Y' COMMENT 'Y=''BOTH '' N=''ONLY EMP''',
  `esi_both_onlyemp` enum('Y','N') DEFAULT 'Y' COMMENT 'Y=''BOTH '' N=''ONLY EMP''',
  `employeer_esi` float DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.epf_esi_details: ~0 rows (approximately)
/*!40000 ALTER TABLE `epf_esi_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `epf_esi_details` ENABLE KEYS */;


-- Dumping structure for table chiru.hrm_emp_location
CREATE TABLE IF NOT EXISTS `hrm_emp_location` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_number` varchar(50) NOT NULL,
  `loc_id` int(11) NOT NULL,
  `remark` varchar(255) NOT NULL,
  `from_date` datetime NOT NULL,
  `to_date` datetime NOT NULL,
  `current_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.hrm_emp_location: ~0 rows (approximately)
/*!40000 ALTER TABLE `hrm_emp_location` DISABLE KEYS */;
/*!40000 ALTER TABLE `hrm_emp_location` ENABLE KEYS */;


-- Dumping structure for table chiru.hrm_leave_type
CREATE TABLE IF NOT EXISTS `hrm_leave_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `levae_abbreviation` varchar(45) DEFAULT NULL,
  `loc_id` varchar(50) DEFAULT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.hrm_leave_type: ~0 rows (approximately)
/*!40000 ALTER TABLE `hrm_leave_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `hrm_leave_type` ENABLE KEYS */;


-- Dumping structure for table chiru.hrm_location
CREATE TABLE IF NOT EXISTS `hrm_location` (
  `loc_id` int(11) NOT NULL AUTO_INCREMENT,
  `loc_name` varchar(255) NOT NULL DEFAULT '0',
  `address_1` varchar(255) NOT NULL DEFAULT '0',
  `address_2` varchar(255) NOT NULL DEFAULT '0',
  `city` varchar(255) NOT NULL DEFAULT '0',
  `state` varchar(255) NOT NULL DEFAULT '0',
  `zip_code` int(11) NOT NULL DEFAULT '0',
  `phone` varchar(50) NOT NULL DEFAULT '0',
  `mobile` varchar(50) NOT NULL DEFAULT '0',
  `fax` int(11) NOT NULL DEFAULT '0',
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`loc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.hrm_location: ~0 rows (approximately)
/*!40000 ALTER TABLE `hrm_location` DISABLE KEYS */;
/*!40000 ALTER TABLE `hrm_location` ENABLE KEYS */;


-- Dumping structure for table chiru.ip_white_list
CREATE TABLE IF NOT EXISTS `ip_white_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.ip_white_list: 0 rows
/*!40000 ALTER TABLE `ip_white_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `ip_white_list` ENABLE KEYS */;


-- Dumping structure for table chiru.leave_accural_rule
CREATE TABLE IF NOT EXISTS `leave_accural_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `leave_id` int(11) DEFAULT NULL,
  `frequency` int(11) DEFAULT NULL COMMENT '1=anual,2=monthly,3=weekly,4=half yearly,5=quaterly',
  `date_accural` varchar(50) DEFAULT NULL,
  `day_accural` float DEFAULT NULL,
  `max_day_accural` int(11) DEFAULT NULL,
  `max_leave_month` int(11) DEFAULT '0',
  `incashment` enum('0','1') DEFAULT '0' COMMENT '0=>no,1=>yes',
  `incashment_type` enum('0','1','2') DEFAULT '0' COMMENT '1=percentage,2=fixed',
  `icashment_value` int(11) DEFAULT '0',
  `incashfrom` varchar(50) DEFAULT '0',
  `gross` enum('0','1','2') DEFAULT '0' COMMENT '1=>gross,2=>salaryhead',
  `company_id` int(11) DEFAULT '0',
  `created_by` int(11) DEFAULT NULL,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.leave_accural_rule: ~0 rows (approximately)
/*!40000 ALTER TABLE `leave_accural_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `leave_accural_rule` ENABLE KEYS */;


-- Dumping structure for table chiru.leave_accural_rule_year
CREATE TABLE IF NOT EXISTS `leave_accural_rule_year` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `leave_id` int(11) DEFAULT NULL,
  `frequency` int(11) DEFAULT NULL COMMENT '1=anual,2=monthly,3=weekly,4=half yearly,5=quaterly',
  `date_accural` varchar(50) DEFAULT NULL,
  `day_accural` float DEFAULT NULL,
  `max_day_accural` int(11) DEFAULT NULL,
  `max_leave_month` int(11) DEFAULT '0',
  `incashment` enum('0','1') DEFAULT '0' COMMENT '0=>no,1=>yes',
  `incashment_type` enum('0','1','2') DEFAULT '0' COMMENT '1=percentage,2=fixed',
  `icashment_value` int(11) DEFAULT '0',
  `incashfrom` varchar(50) DEFAULT '0',
  `company_id` int(11) DEFAULT '0',
  `gross` enum('0','1','2') DEFAULT '0' COMMENT '1=>gross,2=>salary head',
  `created_by` int(11) DEFAULT NULL,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `leave_period_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.leave_accural_rule_year: ~0 rows (approximately)
/*!40000 ALTER TABLE `leave_accural_rule_year` DISABLE KEYS */;
/*!40000 ALTER TABLE `leave_accural_rule_year` ENABLE KEYS */;


-- Dumping structure for table chiru.leave_allow
CREATE TABLE IF NOT EXISTS `leave_allow` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `leave_id` int(11) DEFAULT NULL,
  `leave_period_id` int(11) DEFAULT NULL,
  `dep_id` int(11) DEFAULT '0',
  `category_id` int(11) DEFAULT '0',
  `yearofservice_from` int(11) DEFAULT '0',
  `yearofservice_to` int(11) DEFAULT '0',
  `created_by` int(11) DEFAULT NULL,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.leave_allow: ~0 rows (approximately)
/*!40000 ALTER TABLE `leave_allow` DISABLE KEYS */;
/*!40000 ALTER TABLE `leave_allow` ENABLE KEYS */;


-- Dumping structure for table chiru.leave_allow_year
CREATE TABLE IF NOT EXISTS `leave_allow_year` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `leave_id` int(11) DEFAULT NULL,
  `leave_period_id` int(11) DEFAULT NULL,
  `dep_id` int(11) DEFAULT '0',
  `category_id` int(11) DEFAULT '0',
  `yearofservice_from` int(11) DEFAULT '0',
  `yearofservice_to` int(11) DEFAULT '0',
  `created_by` int(11) DEFAULT NULL,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.leave_allow_year: ~0 rows (approximately)
/*!40000 ALTER TABLE `leave_allow_year` DISABLE KEYS */;
/*!40000 ALTER TABLE `leave_allow_year` ENABLE KEYS */;


-- Dumping structure for table chiru.leave_carryfor_opening
CREATE TABLE IF NOT EXISTS `leave_carryfor_opening` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `from_periodid` int(11) NOT NULL,
  `to_periodid` int(11) NOT NULL,
  `loc_id` int(11) NOT NULL DEFAULT '0',
  `dep_id` int(11) NOT NULL DEFAULT '0',
  `leave_id` int(11) NOT NULL DEFAULT '0',
  `emp_id` int(11) NOT NULL DEFAULT '0',
  `type` enum('2','3') NOT NULL COMMENT '2=>opening,3=>Carry Farword',
  `remaining_leave` int(11) NOT NULL DEFAULT '0',
  `created_by` int(11) NOT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.leave_carryfor_opening: ~0 rows (approximately)
/*!40000 ALTER TABLE `leave_carryfor_opening` DISABLE KEYS */;
/*!40000 ALTER TABLE `leave_carryfor_opening` ENABLE KEYS */;


-- Dumping structure for table chiru.leave_carry_forward
CREATE TABLE IF NOT EXISTS `leave_carry_forward` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `leave_id` int(11) DEFAULT NULL,
  `expire_time` varchar(50) DEFAULT NULL,
  `expire_duration` varchar(50) DEFAULT NULL COMMENT '1=week,2=month,3=year',
  `max_leave_cf` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.leave_carry_forward: ~0 rows (approximately)
/*!40000 ALTER TABLE `leave_carry_forward` DISABLE KEYS */;
/*!40000 ALTER TABLE `leave_carry_forward` ENABLE KEYS */;


-- Dumping structure for table chiru.leave_carry_forward_year
CREATE TABLE IF NOT EXISTS `leave_carry_forward_year` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `leave_id` int(11) DEFAULT NULL,
  `leave_period_id` int(11) DEFAULT NULL,
  `expire_time` varchar(50) DEFAULT NULL,
  `expire_duration` varchar(50) DEFAULT NULL COMMENT '1=week,2=month,3=year',
  `max_leave_cf` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.leave_carry_forward_year: ~0 rows (approximately)
/*!40000 ALTER TABLE `leave_carry_forward_year` DISABLE KEYS */;
/*!40000 ALTER TABLE `leave_carry_forward_year` ENABLE KEYS */;


-- Dumping structure for table chiru.leave_entitlment
CREATE TABLE IF NOT EXISTS `leave_entitlment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(11) DEFAULT NULL COMMENT '3=by employee, 2=by leave type',
  `leave_id` int(11) DEFAULT NULL,
  `loc_id` int(11) DEFAULT NULL COMMENT 'if type=''2'' than type_id=location',
  `emp_id` int(11) DEFAULT NULL,
  `leave_period` int(11) DEFAULT '0',
  `entitlment` float NOT NULL,
  `created_by` varchar(255) DEFAULT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.leave_entitlment: ~0 rows (approximately)
/*!40000 ALTER TABLE `leave_entitlment` DISABLE KEYS */;
/*!40000 ALTER TABLE `leave_entitlment` ENABLE KEYS */;


-- Dumping structure for table chiru.leave_general_rule
CREATE TABLE IF NOT EXISTS `leave_general_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `leave_id` int(11) DEFAULT NULL,
  `is_paid` int(11) DEFAULT '0',
  `accrual` enum('1','0') DEFAULT '0' COMMENT '1=enable accrual, 0=desble accural',
  `carry_forward` enum('1','0') NOT NULL DEFAULT '0' COMMENT '1=carry forward ,0=no carry forward',
  `half_day` enum('1','0') NOT NULL DEFAULT '0' COMMENT '1=half day ,0=no halfday',
  `allow_with_holiday` enum('1','0') NOT NULL DEFAULT '0' COMMENT '1="No",0=''Yes''',
  `servics_period` varchar(50) NOT NULL,
  `consecutive_days` varchar(50) NOT NULL,
  `addwithother` varchar(50) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.leave_general_rule: ~0 rows (approximately)
/*!40000 ALTER TABLE `leave_general_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `leave_general_rule` ENABLE KEYS */;


-- Dumping structure for table chiru.leave_general_rule_year
CREATE TABLE IF NOT EXISTS `leave_general_rule_year` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `leave_id` int(11) DEFAULT NULL,
  `leave_period_id` int(11) DEFAULT NULL,
  `is_paid` int(11) DEFAULT '0',
  `accrual` enum('1','0') DEFAULT '0' COMMENT '1=enable accrual, 0=desble accural',
  `carry_forward` enum('1','0') NOT NULL DEFAULT '0' COMMENT '1=carry forward ,0=no carry forward',
  `half_day` enum('1','0') NOT NULL DEFAULT '0' COMMENT '1=half day ,0=no halfday',
  `allow_with_holiday` enum('1','0') NOT NULL DEFAULT '0' COMMENT '1="No",0=''Yes''',
  `servics_period` varchar(50) NOT NULL,
  `consecutive_days` varchar(50) NOT NULL,
  `addwithother` varchar(50) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.leave_general_rule_year: ~0 rows (approximately)
/*!40000 ALTER TABLE `leave_general_rule_year` DISABLE KEYS */;
/*!40000 ALTER TABLE `leave_general_rule_year` ENABLE KEYS */;


-- Dumping structure for table chiru.leave_lwp_allow
CREATE TABLE IF NOT EXISTS `leave_lwp_allow` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dep_id` int(11) DEFAULT '0',
  `category_id` int(11) DEFAULT '0',
  `yearofservice_from` int(11) DEFAULT '0',
  `yearofservice_to` int(11) DEFAULT '0',
  `created_by` int(11) DEFAULT NULL,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.leave_lwp_allow: ~0 rows (approximately)
/*!40000 ALTER TABLE `leave_lwp_allow` DISABLE KEYS */;
/*!40000 ALTER TABLE `leave_lwp_allow` ENABLE KEYS */;


-- Dumping structure for table chiru.leave_period
CREATE TABLE IF NOT EXISTS `leave_period` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.leave_period: ~0 rows (approximately)
/*!40000 ALTER TABLE `leave_period` DISABLE KEYS */;
/*!40000 ALTER TABLE `leave_period` ENABLE KEYS */;


-- Dumping structure for table chiru.leave_segment
CREATE TABLE IF NOT EXISTS `leave_segment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `leave_id` int(11) NOT NULL DEFAULT '0',
  `mnth_id` int(11) DEFAULT NULL,
  `count` int(11) DEFAULT '0',
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.leave_segment: ~0 rows (approximately)
/*!40000 ALTER TABLE `leave_segment` DISABLE KEYS */;
/*!40000 ALTER TABLE `leave_segment` ENABLE KEYS */;


-- Dumping structure for table chiru.log_document_management
CREATE TABLE IF NOT EXISTS `log_document_management` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `action_query` longtext,
  `action` enum('1','2','3','4') DEFAULT NULL COMMENT '1=select ,2=insert,3=update,4=delete',
  `table_name` longtext,
  `table_value` longtext,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.log_document_management: ~0 rows (approximately)
/*!40000 ALTER TABLE `log_document_management` DISABLE KEYS */;
/*!40000 ALTER TABLE `log_document_management` ENABLE KEYS */;


-- Dumping structure for table chiru.log_hostel_management
CREATE TABLE IF NOT EXISTS `log_hostel_management` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `action_query` longtext,
  `action` enum('1','2','3','4') DEFAULT NULL COMMENT '1=select ,2=insert,3=update,4=delete',
  `table_name` longtext,
  `table_value` longtext,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.log_hostel_management: ~0 rows (approximately)
/*!40000 ALTER TABLE `log_hostel_management` DISABLE KEYS */;
/*!40000 ALTER TABLE `log_hostel_management` ENABLE KEYS */;


-- Dumping structure for table chiru.log_hr_management
CREATE TABLE IF NOT EXISTS `log_hr_management` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `action_query` longtext,
  `action` enum('1','2','3','4') DEFAULT NULL COMMENT '1=select ,2=insert,3=update,4=delete',
  `table_name` longtext,
  `table_value` longtext,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.log_hr_management: ~0 rows (approximately)
/*!40000 ALTER TABLE `log_hr_management` DISABLE KEYS */;
/*!40000 ALTER TABLE `log_hr_management` ENABLE KEYS */;


-- Dumping structure for table chiru.log_inventory_management
CREATE TABLE IF NOT EXISTS `log_inventory_management` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `action_query` longtext,
  `action` enum('1','2','3','4') DEFAULT NULL COMMENT '1=select ,2=insert,3=update,4=delete',
  `table_name` longtext,
  `table_value` longtext,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.log_inventory_management: ~0 rows (approximately)
/*!40000 ALTER TABLE `log_inventory_management` DISABLE KEYS */;
/*!40000 ALTER TABLE `log_inventory_management` ENABLE KEYS */;


-- Dumping structure for table chiru.log_page
CREATE TABLE IF NOT EXISTS `log_page` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `server_mac_add` varchar(255) DEFAULT NULL,
  `system_mac_add` varchar(255) DEFAULT NULL,
  `system_ip` varchar(255) DEFAULT NULL,
  `page_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_swedish_ci DEFAULT NULL,
  `server_computer_name` varchar(255) DEFAULT NULL,
  `local_computer_name` varchar(255) DEFAULT NULL,
  `browser_and_os` longtext,
  `user_id` int(11) DEFAULT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.log_page: ~1 rows (approximately)
/*!40000 ALTER TABLE `log_page` DISABLE KEYS */;
INSERT INTO `log_page` (`id`, `server_mac_add`, `system_mac_add`, `system_ip`, `page_name`, `server_computer_name`, `local_computer_name`, `browser_and_os`, `user_id`, `created_date`, `company_id`) VALUES
	(1, '00-19-99-CE-14-1F', '1', '122.177.91.194', '/chiru/ajax/clockbioajax.php', 'EAGLE544', 'abts-north-dynamic-194.91.177.122.airtelbroadband.in', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.132 Safari/537.36', 0, '2018-02-04 10:46:37', 0);
/*!40000 ALTER TABLE `log_page` ENABLE KEYS */;


-- Dumping structure for table chiru.log_purchase_management
CREATE TABLE IF NOT EXISTS `log_purchase_management` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `action_query` longtext,
  `action` enum('1','2','3','4') DEFAULT NULL COMMENT '1=select ,2=insert,3=update,4=delete',
  `table_name` longtext,
  `table_value` longtext,
  `created_date` timestamp NULL DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.log_purchase_management: ~0 rows (approximately)
/*!40000 ALTER TABLE `log_purchase_management` DISABLE KEYS */;
/*!40000 ALTER TABLE `log_purchase_management` ENABLE KEYS */;


-- Dumping structure for table chiru.log_user_management
CREATE TABLE IF NOT EXISTS `log_user_management` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `action_query` longtext,
  `action` enum('1','2','3','4') DEFAULT NULL COMMENT '1=select ,2=insert,3=update,4=delete',
  `table_name` longtext,
  `table_value` longtext,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.log_user_management: ~0 rows (approximately)
/*!40000 ALTER TABLE `log_user_management` DISABLE KEYS */;
/*!40000 ALTER TABLE `log_user_management` ENABLE KEYS */;


-- Dumping structure for table chiru.menu
CREATE TABLE IF NOT EXISTS `menu` (
	`id` INT(11) NOT NULL AUTO_INCREMENT,
	`name` VARCHAR(255) NOT NULL,
	`menu_details` VARCHAR(255) NULL DEFAULT NULL,
	`log` INT(11) NOT NULL DEFAULT '0',
	`logo` VARCHAR(255) NOT NULL DEFAULT 'fa-laptop',
	`dasboard_link` VARCHAR(255) NOT NULL DEFAULT '#',
	`report_name` VARCHAR(255) NOT NULL DEFAULT '#',
	`android_activity_name` VARCHAR(255) NOT NULL DEFAULT '#',
	`android_img_file_name` VARCHAR(255) NOT NULL DEFAULT '#',
	`for_android` INT(11) NOT NULL DEFAULT '0',
	`main_menu` INT(11) NOT NULL DEFAULT '0',
	`main_menu_id` INT(11) NOT NULL DEFAULT '0',
	`master` INT(11) NOT NULL DEFAULT '0',
	`entry` INT(11) NOT NULL DEFAULT '0',
	`report` INT(11) NOT NULL DEFAULT '0',
	`other` INT(11) NOT NULL DEFAULT '0',
	`dashboard` INT(11) NOT NULL DEFAULT '0',
	`hyperlink` VARCHAR(255) NOT NULL DEFAULT '#',
	`order1` INT(11) NOT NULL DEFAULT '0',
	`active` INT(11) NOT NULL DEFAULT '0',
	`real_active` INT(11) NOT NULL DEFAULT '0',
	`company_id` INT(11) NULL DEFAULT '0',
	PRIMARY KEY (`id`)
)
COLLATE='latin1_swedish_ci'
ENGINE=InnoDB
ROW_FORMAT=COMPACT
AUTO_INCREMENT=424
AVG_ROW_LENGTH=413
;


INSERT INTO `menu` (`id`, `name`, `menu_details`, `log`, `logo`, `dasboard_link`, `report_name`, `main_menu`, `main_menu_id`, `master`, `entry`, `report`, `other`, `dashboard`, `hyperlink`, `order1`, `active`, `real_active`, `company_id`) VALUES
	(1, 'HR MANAGEMENT', NULL, 0, 'fa-sitemap', '../Dashboard_charts/dashboard.php?id=1', '#', 1, 0, 0, 0, 0, 0, 1, '#', 5, 0, 1, 0),
	(11, 'CATEGORY', NULL, 0, 'fa-laptop', '', '#', 0, 1, 1, 0, 0, 0, 0, '../hrm/add_category.php', 1, 0, 0, 0),
	(12, 'DEPARTMENT', NULL, 0, 'fa-laptop', '', '#', 0, 1, 1, 0, 0, 0, 0, '../hrm/add_department.php', 2, 0, 0, 0),
	(14, 'DESIGNATION', NULL, 0, 'fa-laptop', '', '#', 0, 1, 1, 0, 0, 0, 0, '../hrm/add_position.php', 3, 0, 0, 0),
	(16, 'LEAVE POLICY', NULL, 0, 'fa-laptop', '', '#', 0, 1, 1, 0, 0, 0, 0, '../hrm/leave_policy.php', 5, 0, 0, 0),
	(17, 'EMPLOYEE ENTRY', 'To add new employee in organization', 0, 'ion-person-add', '', '#', 0, 1, 0, 1, 0, 0, 0, '../hrm/admission.php', 1, 0, 0, 0),
	(19, 'ATTENDANCE REGISTER', 'To get attandence sumarry.', 0, ' fa-check-square-o', '', '#', 0, 1, 0, 1, 0, 0, 0, '../hrm/attendance_register.php', 3, 1, 0, 0),
	(20, 'BANK DETAILS', NULL, 0, 'fa-laptop', '', '#', 0, 1, 1, 0, 0, 0, 0, '../hrm/add_bank.php', 4, 1, 0, 0),
	(46, 'PAYROLL', NULL, 0, 'fa-laptop', '', '#', 0, 332, 1, 0, 0, 0, 0, '../hrm/payroll_policy.php', 6, 0, 1, 0),
	(76, 'CUSTOM REPORT', NULL, 0, 'fa-search-plus', '../Dashboard_charts/dashboard.php?id=76', '#', 1, 0, 0, 0, 0, 0, 0, '#', 13, 1, 0, 0),
	(77, 'STUDENT REPORT CREATE', NULL, 0, 'fa-laptop', '', '#', 0, 76, 1, 0, 0, 0, 0, '../utility/custom_report.php', 1, 0, 0, 0),
	(78, 'STUDENT REPORT', NULL, 0, 'fa-laptop', '', '#', 0, 76, 0, 0, 1, 0, 0, '../utility/view_report.php', 1, 0, 0, 0),
	(107, 'EMPLOYEE REPORT', NULL, 0, 'fa-laptop', '', '#', 0, 1, 0, 0, 1, 0, 0, '../hrm/search_create_report.php', 1, 0, 1, 0),
	(137, 'JOB MANAGEMENT', NULL, 0, 'fa-laptop', '', '#', 0, 1, 1, 0, 0, 0, 0, '../hrm/add_job.php', 7, 0, 0, 0),
	(138, 'HOLIDAY MANAGEMENT', NULL, 0, 'fa-laptop', '', '#', 0, 1, 1, 0, 0, 0, 0, '../hrm/holiday_master.php', 8, 0, 0, 0),
	(140, 'SET DAYS', NULL, 0, 'fa-laptop', '', '#', 0, 1, 1, 0, 0, 0, 0, '../hrm/week_day_set.php', 9, 0, 0, 0),
	(142, 'SET WORKING HOURS', NULL, 0, 'fa-laptop', '', '#', 0, 1, 1, 0, 0, 0, 0, '../hrm/working_hours_set.php', 10, 0, 0, 0),
	(157, 'DEPARTMENT V/S EMPLOYEE', NULL, 0, 'fa-laptop', '../Dashboard_charts/HR MANAGEMENT/hrm_deptemployee.php', '#', 0, 1, 0, 0, 0, 0, 1, '#', 1, 0, 0, 0),
	(158, 'DEPARTMENT V/S EMPLOYEE SALARY', NULL, 0, 'fa-laptop', '../Dashboard_charts/HR MANAGEMENT/hrm_deptempsalary.php', '#', 0, 1, 0, 0, 0, 0, 1, '#', 2, 0, 0, 0),
	(159, 'EMPLOYEE ATTENDANCE', NULL, 0, 'fa-laptop', '../Dashboard_charts/HR MANAGEMENT/hrm_atendence.php', '#', 0, 1, 0, 0, 0, 0, 1, '#', 3, 0, 0, 0),
	(160, 'EMPLOYEE ONLINE STATUS', NULL, 0, 'fa-laptop', '../Dashboard_charts/HR MANAGEMENT/hrm_onlinestatus.php', '#', 0, 1, 0, 0, 0, 0, 1, '#', 4, 0, 0, 0),
	(161, 'QUALIFICATION v/s NO. OF EMPLOYEE IN DEPT.', NULL, 0, 'fa-laptop', '../Dashboard_charts/HR MANAGEMENT/hrm_empqualification.php', '#', 0, 1, 0, 0, 0, 0, 1, '#', 5, 0, 0, 0),
	(162, 'ORGANIZATION CHART', NULL, 0, 'fa-laptop', '', '#', 0, 1, 0, 0, 1, 0, 0, '../hrm/org_chart.php', 9, 0, 1, 0),
	(163, 'PURCHASE MANAGEMENT', NULL, 0, 'fa-puzzle-piece', '../Dashboard_charts/dashboard.php?id=163', '#', 1, 0, 0, 0, 0, 0, 1, '#', 9, 0, 1, 0),
	(164, 'VENDOR REGISTRATION', NULL, 0, 'fa-laptop', '', '#', 0, 163, 1, 0, 0, 0, 0, '../purchase/vendor_reg.php', 1, 0, 1, 0),
	(165, 'CUSTOM REPORT', NULL, 0, 'fa-laptop', '', '#', 0, 1, 0, 1, 0, 0, 0, '../utility/custom_report_emp.php', 9, 0, 0, 0),
	(166, 'VIEW CUSTOM REPORT', NULL, 0, 'fa-laptop', '', '#', 0, 1, 0, 0, 1, 0, 0, '../utility/view_report_emp.php', 3, 0, 1, 0),
	(167, 'SET CEO', NULL, 0, 'fa-laptop', '', '#', 0, 1, 1, 0, 0, 0, 0, '../hrm/ceo.php', 11, 0, 0, 0),
	(168, 'SET DIRECTOR', NULL, 0, 'fa-laptop', '', '#', 0, 1, 1, 0, 0, 0, 0, '../hrm/directors.php', 12, 0, 0, 0),
	(169, 'SET HOD', NULL, 0, 'fa-laptop', '', '#', 0, 1, 1, 0, 0, 0, 0, '../hrm/dept_hod.php', 13, 0, 0, 0),
	(170, 'ADD PRODUCT', NULL, 0, 'fa-laptop', '', '#', 0, 163, 1, 0, 0, 0, 0, '../inventory/add_product.php', 2, 0, 1, 0),
	(175, 'PRODUCTS  ISSUE', NULL, 0, 'fa-laptop', '', '#', 0, 163, 0, 1, 0, 0, 0, '../inventory/manage_item.php', 1, 0, 0, 0),
	(176, 'SELLING REPORTS', NULL, 0, 'fa-laptop', ' ', '#', 0, 163, 0, 0, 1, 0, 0, '../inventory/product_sell_reports.php', 1, 0, 0, 0),
	(178, 'PAY SALARY', 'Pay salary to employees', 0, 'fa-thumbs-up', '', '#', 0, 332, 0, 1, 0, 0, 0, '../hrm/pay_slip_print.php', 8, 0, 0, 0),
	(180, 'APPROVE SALARY', 'Montly salary approval.', 0, 'fa-money', '', '#', 0, 332, 0, 1, 0, 0, 0, '../hrm/approve_salary.php', 7, 0, 0, 0),
	(182, 'GENERATE SALARY', 'Month wise salary genaration', 0, 'fa-credit-card', '', '#', 0, 332, 0, 1, 0, 0, 0, '../hrm/salary_generate.php', 4, 0, 0, 0),
	(204, 'SETTING', NULL, 0, 'fa-text-height', '../Dashboard_charts/dashboard.php?id=11', '#', 1, 0, 0, 0, 0, 0, 1, '', 15, 1, 0, 0),
	(205, 'ERP SEETING', NULL, 0, 'fa-laptop', '', '#', 0, 204, 1, 0, 0, 0, 0, '../erp-setting/set-logo.php', 1, 0, 0, 0),
	(212, 'CREATE DOCUMENTATION', NULL, 0, 'fa-laptop', '#', '#', 0, 1, 1, 0, 0, 0, 0, '../hrm/add_document.php', 20, 0, 0, 0),
	(218, 'LOG REPORT', NULL, 1, 'fa-laptop', '', 'HR MANAGEMENT  LOG REPORT', 0, 1, 0, 0, 1, 0, 0, '../login_management/log_report.php?db_name=log_hr_management&id=218', 10, 0, 1, 0),
	(220, 'LOG REPORT', NULL, 1, 'fa-laptop', '', 'CUSTOM REPORT  LOG REPORT', 0, 76, 0, 0, 1, 0, 0, '../login_management/log_report.php?db_name=log_custom_report&id=220', 1, 0, 0, 0),
	(228, 'LOG REPORT', NULL, 1, 'fa-laptop', '', 'PURCHASE MANAGEMENT  LOG REPORT', 0, 163, 0, 0, 1, 0, 0, '../login_management/log_report.php?db_name=log_purchase_management&id=228', 1, 0, 0, 0),
	(239, 'PAY SLIP REPORT', NULL, 0, 'fa-laptop', '', '#', 0, 332, 0, 0, 1, 0, 0, '../hrm/pay_slip_report.php', 2, 0, 0, 0),
	(241, 'ADD TAX GROUP', NULL, 0, 'fa-laptop', '#', '#', 0, 254, 1, 0, 0, 0, 0, '../tax_management/add_group.php', 17, 0, 0, 0),
	(242, 'ADD DEDUCTION', NULL, 0, 'fa-laptop', '#', '#', 0, 254, 1, 0, 0, 0, 0, '../tax_management/add_deduct.php', 18, 0, 0, 0),
	(243, 'ADD PERCENTAGE', NULL, 0, 'fa-laptop', '#', '#', 0, 254, 1, 0, 0, 0, 0, '../tax_management/add_percent.php', 16, 0, 0, 0),
	(244, 'ADD TAX YEAR', NULL, 0, 'fa-laptop', '#', '#', 0, 254, 1, 0, 0, 0, 0, '../tax_management/tax_year.php', 14, 0, 0, 0),
	(245, 'ADD INCOME RANGE', NULL, 0, 'fa-laptop', '#', '#', 0, 254, 1, 0, 0, 0, 0, '../tax_management/income_range.php', 15, 0, 0, 0),
	(248, 'EMPLOYEE  EXIT', NULL, 0, 'fa-laptop', '#', '#', 0, 346, 0, 1, 0, 0, 0, '../Exit_Employee/emp_leave.php', 10, 0, 0, 0),
	(252, 'SALARY SHEET', 'Get salary slip month wise.', 0, ' fa-file-o', '#', '#', 0, 332, 0, 0, 1, 0, 0, '../hrm/employee_salary_paid_statement.php', 7, 0, 0, 0),
	(254, 'TAX  MANAGEMENT', NULL, 0, 'fa-sitemap', '../Dashboard_charts/dashboard.php?id=1', '#', 1, 0, 0, 0, 0, 0, 1, '#', 5, 0, 1, 0),
	(255, 'CALCULATE TAX', NULL, 0, 'fa-laptop', '#', '#', 0, 254, 0, 1, 0, 0, 0, '../tax_management/cal_tax.php', 0, 0, 0, 0),
	(257, 'TAX REPORT', NULL, 0, 'fa-laptop', '#', '#', 0, 254, 0, 0, 1, 0, 0, '../tax_management/tax_report.php', 0, 0, 1, 0),
	(264, 'SALARY MANAGEMENT', 'Manage employees salary', 0, 'fa-rupee', '#', '#', 0, 332, 0, 1, 0, 0, 0, '../hrm/salary_management.php', 2, 0, 0, 0),
	(265, 'EMPLOYEE LEDGER', NULL, 0, 'fa-laptop', '#', '#', 0, 332, 0, 0, 1, 0, 0, '../hrm/emp_ledger.php', 7, 0, 0, 0),
	(272, 'EMPLOYEE ICARD', NULL, 0, 'fa-laptop', '#', '#', 0, 1, 1, 0, 0, 0, 0, '../Icard-Document/e-icard.php', 21, 0, 0, 0),
	(273, 'ATTENDANCE WAIVING', NULL, 0, 'fa-laptop', '#', '#', 0, 1, 1, 0, 0, 0, 0, '../hrm/attendence_waving.php', 22, 0, 0, 0),
	(274, 'MANAGE EPF CHALAN', NULL, 0, 'fa-laptop', '#', '#', 0, 332, 0, 1, 0, 0, 0, '../hrm/manage_epf_chalan.php', 8, 0, 0, 0),
	(283, 'MONTHLY PF  REPORT', NULL, 0, 'fa-laptop', '#', '#', 0, 332, 0, 0, 1, 0, 0, '../hrm/pf_monthly_report.php', 4, 0, 0, 0),
	(284, 'MONTHLY ESI REPORT', NULL, 0, 'fa-laptop', '#', '#', 0, 332, 0, 0, 1, 0, 0, '../hrm/esi_monthly_report.php', 5, 0, 0, 0),
	(285, 'MONTHLY TDS REPORT', NULL, 0, 'fa-laptop', '#', '#', 0, 332, 0, 0, 1, 0, 0, '../hrm/tds_monthly_report.php', 6, 0, 0, 0),
	(290, 'ATTENDANCE REPORTS', NULL, 0, 'fa-laptop', '#', '#', 0, 1, 0, 0, 1, 0, 0, '../hrm/advance_attendance_report.php', 8, 0, 1, 0),
	(304, 'LOCATION', NULL, 0, 'fa-laptop', '', '#', 0, 1, 1, 0, 0, 0, 0, '../hrm/add_loc.php', 0, 0, 0, 0),
	(308, 'GROUP', NULL, 0, 'fa-laptop', '#', '#', 0, 1, 1, 0, 0, 0, 0, '../hrm/add_group.php', 4, 0, 0, 0),
	(309, 'SHIFT', NULL, 0, 'fa-laptop', '#', '#', 0, 1, 1, 0, 0, 0, 0, '../hrm/add_shift.php', 4, 0, 0, 0),
	(310, 'SALARY SETTING', NULL, 0, 'fa-laptop', '#', '#', 0, 1, 1, 0, 0, 0, 0, '../hrm/set_salryrange.php', 5, 0, 0, 0),
	(311, 'ASSIGN LOCATION', NULL, 0, 'fa-laptop', '#', '#', 0, 1, 0, 1, 0, 0, 0, '../hrm/assign_loc.php', 2, 0, 0, 0),
	(312, 'GROUP ALLOCATION', NULL, 0, 'fa-laptop', '#', '#', 0, 1, 0, 1, 0, 0, 0, '../hrm/assign_group.php', 2, 0, 0, 0),
	(313, 'ASSIGN SHIFT', NULL, 0, 'fa-laptop', '#', '#', 0, 1, 0, 1, 0, 0, 0, '../hrm/assign_shift.php', 2, 0, 0, 0),
	(316, 'LEAVE ENTITLEMENTS', NULL, 0, 'fa-laptop', '#', '#', 0, 1, 0, 1, 0, 0, 0, '../hrm/leave_entitlement.php', 2, 0, 0, 0),
	(317, 'CARRY FORWARD / OPENING LEAVES', NULL, 0, 'fa-laptop', '#', '#', 0, 1, 0, 1, 0, 0, 0, '../hrm/carryfwd_opening_leave.php', 2, 0, 0, 0),
	(318, 'DAILY REPORT', NULL, 0, 'fa-laptop', '#', '#', 0, 1, 0, 0, 1, 0, 0, '../hrm/daily_report.php', 8, 0, 1, 0),
	(319, 'CREATE OPENING', NULL, 0, 'fa-laptop', '#', '#', 0, 325, 1, 0, 0, 0, 0, '../recruitment/recruitment_job.php', 0, 0, 1, 0),
	(321, 'CANDIDATE REPORT', NULL, 0, 'fa-laptop', '#', '#', 0, 325, 0, 0, 1, 0, 0, '../recruitment/condidate_report.php', 0, 0, 0, 0),
	(322, 'SCORE REPORT', NULL, 0, 'fa-laptop', '#', '#', 0, 325, 0, 0, 1, 0, 0, '../recruitment/score_report.php', 0, 0, 0, 0),
	(323, 'APPROVED REPORT', NULL, 0, 'fa-laptop', '#', '#', 0, 325, 0, 0, 1, 0, 0, '../recruitment/apporved.php', 0, 0, 0, 0),
	(325, 'RECRUITMENT  MANAGEMENT', NULL, 0, 'fa-suitcase', '../Dashboard_charts/dashboard.php?id=8', '#', 1, 0, 0, 0, 0, 0, 0, '', 14, 1, 0, 0),
	(326, 'CREATE ROUND & STAGE', NULL, 0, 'fa-laptop', '#', '#', 0, 325, 1, 0, 0, 0, 0, '../recruitment/create_round', 0, 0, 1, 0),
	(327, 'CHEEK DACUMENT', NULL, 0, 'fa-laptop', '#', '#', 0, 325, 0, 1, 0, 0, 0, '../recruitment/cheek_admin_document_client', 0, 0, 0, 0),
	(328, 'TDS DETAILS', NULL, 0, 'fa-laptop', '#', '#', 0, 332, 0, 0, 1, 0, 0, '../hrm/tds_details.php', 6, 0, 0, 0),
	(329, 'ATTENDANCE APPROVE', NULL, 0, 'fa-laptop', '#', '#', 0, 1, 0, 1, 0, 0, 0, '../hrm/attendance_approve.php', 3, 1, 0, 0),
	(330, 'ARREAR PROCESS', NULL, 0, 'fa-laptop', '#', '#', 0, 332, 0, 1, 0, 0, 0, '../hrm/arrear_procsee.php', 5, 0, 0, 0),
	(331, 'DEDUCTION PROCESS', NULL, 0, 'fa-laptop', '#', '#', 0, 332, 0, 1, 0, 0, 0, '../hrm/deduction_process.php', 6, 0, 0, 0),
	(332, 'PAYROLL MANAGEMENT', NULL, 0, 'fa-sitemap', '../Dashboard_charts/dashboard.php?id=332', '#', 1, 0, 0, 0, 0, 0, 1, '#', 5, 0, 1, 0),
	(333, 'ACTIVITY MANAGEMENT', NULL, 0, 'fa-sitemap', '../Dashboard_charts/dashboard.php?id=333', '#', 1, 0, 0, 0, 0, 0, 1, '#', 5, 0, 1, 0),
	(334, 'ADD ACTIVITY', NULL, 0, 'fa-laptop', '#', '#', 0, 333, 1, 0, 0, 0, 0, '../activity_managment/add_activity.php', 0, 0, 1, 0),
	(335, 'ACTIVITY MANAGE', NULL, 0, 'fa-laptop', '#', '#', 0, 333, 0, 1, 0, 0, 0, '../activity_managment/activity_manage.php', 0, 0, 0, 0),
	(336, 'NEWS MANAGEMENT', NULL, 0, 'fa-sitemap', '../Dashboard_charts/dashboard.php?id=333', '#', 1, 0, 0, 0, 0, 0, 1, '#', 5, 0, 0, 0),
	(338, 'REIMBURSEMENT  MANAGEMENT', NULL, 0, 'fa-sitemap', '../Dashboard_charts/dashboard.php?id=333', '#', 1, 0, 0, 0, 0, 0, 1, '#', 5, 0, 0, 0),
	(340, 'REIMBURSEMENT REPORT', NULL, 0, 'fa-sitemap', '#', '#', 0, 338, 0, 0, 1, 0, 0, '../reimbursement_report/view_reimbursement_report.php', 5, 0, 0, 0),
	(341, 'Reimbursement  Claim', NULL, 0, 'fa-sitemap', '#', '#', 0, 338, 0, 1, 0, 0, 0, '../reimbursement_report/reimbursement_report.php', 5, 0, 0, 0),
	(342, 'Reibursement Claim Paid', NULL, 0, 'fa-sitemap', '#', '#', 0, 338, 0, 1, 0, 0, 0, '../reimbursement_report/reimbursement_claim_paid.php', 5, 0, 0, 0),
	(343, 'TRANSPOTATION MODE', NULL, 0, 'fa-laptop', '#', '#', 0, 338, 1, 0, 0, 0, 0, '../reimbursement_report/add_mode_type.php', 0, 0, 1, 0),
	(344, 'Welcome', NULL, 0, 'fa fa-dashboard', '../Dashboard_charts/welcome.php', '#', 0, 1, 0, 0, 0, 0, 1, '../Dashboard_charts/welcome.php', 0, 0, 0, 0),
	(345, 'ATTENDANCE  CLOSING', NULL, 0, 'fa-laptop', '#', '#', 0, 1, 1, 0, 0, 0, 0, '../hrm/attendence_closing.php', 23, 0, 0, 0),
	(346, 'EMPLOYEE EXIT', NULL, 0, 'fa-book', '../Dashboard_charts/dashboard.php?id=1', '#', 1, 0, 0, 0, 0, 0, 1, '#', 5, 0, 1, 0),
	(347, 'NOTICE PERIOD', NULL, 0, 'fa-laptop', '#', '#', 0, 346, 1, 0, 0, 0, 0, '../Exit_Employee/add_notice_period.php', 0, 0, 1, 0),
	(348, 'ADD LEVEL', NULL, 0, 'fa-laptop', '#', '#', 0, 346, 1, 0, 0, 0, 0, '../Exit_Employee/exit_policy.php', 0, 0, 1, 0),
	(349, 'FULL &  FINAL SHEET', NULL, 0, 'fa-laptop', '#', '#', 0, 346, 0, 0, 1, 0, 0, '../hrm\\full_and_fill_statements.php', 1, 0, 0, 0),
	(350, 'APPROVAL FOR EXIT', NULL, 0, 'fa-laptop', '#', '#', 0, 346, 0, 1, 0, 0, 0, '../Exit_Employee/exit_employee_approval.php', 1, 0, 0, 0),
	(351, 'EMPLOYEE RESIGNE', NULL, 0, 'fa-laptop', '#', '#', 0, 346, 0, 1, 0, 0, 0, '../Exit_Employee/employee_resigne.php', 0, 0, 0, 0),
	(352, 'EXIT REPORT', NULL, 0, 'fa-laptop', '#', '#', 0, 346, 0, 0, 1, 0, 0, '../hrm/employee_exit_report.php', 0, 0, 0, 0),
	(353, 'ASSIGN C-OFF', NULL, 0, 'fa-laptop', '#', '#', 0, 1, 0, 1, 0, 0, 0, '../hrm/assign_coff.php', 0, 0, 0, 0),
	(354, 'C-OFF APPROVAL', NULL, 0, 'fa-laptop', '#', '#', 0, 1, 0, 1, 0, 0, 0, '../hrm/approval_coff.php', 0, 0, 0, 0),
	(355, 'COMPANY', NULL, 0, 'fa-laptop', '', '#', 0, 1, 1, 0, 0, 0, 0, '../hrm/add_company.php', 1, 0, 0, 0),
	(356, 'MANAGE ATTENDANCE', 'To get attandence sumarry.', 0, ' fa-check-square-o', '', '#', 0, 1, 0, 1, 0, 0, 0, '../hrm/search_create_report_mng.php', 3, 0, 0, 0),
	(357, 'TASK  MANAGEMENT', NULL, 0, 'fa-sitemap', '../Dashboard_charts/dashboard.php?id=332', '#', 1, 0, 0, 0, 0, 0, 1, '#', 5, 0, 1, 0),
	(358, 'CREATE PROJECT', NULL, 0, 'fa-laptop', '', '#', 0, 357, 1, 0, 0, 0, 0, '../task_management/project.php', 6, 0, 1, 0),
	(359, 'TASK', NULL, 0, 'fa-laptop', '', '#', 0, 357, 0, 1, 0, 0, 0, '../task_management/task.php', 6, 0, 0, 0),
	(360, 'USER MANAGEMENT', NULL, 0, ' fa-cogs', '../Dashboard_charts/dashboard.php?id=80', '#', 1, 0, 0, 0, 0, 0, 0, '#', 15, 0, 1, 0),
	(361, 'USER PRIVILAGE', NULL, 0, 'fa-laptop', '', '#', 0, 360, 1, 0, 0, 0, 0, '../Admistration/user_previlage.php', 1, 0, 0, 0),
	(362, 'CHANGE USER PASSWORD', NULL, 0, 'fa-laptop', '', '#', 0, 360, 1, 0, 0, 0, 0, '../Admistration/user.php', 2, 0, 0, 0),
	(363, 'CREATE ADMIN USER', NULL, 0, 'fa-laptop', '', '#', 0, 360, 1, 0, 0, 0, 0, '../Admistration/admin.php', 3, 0, 0, 0),
	(364, 'LOG REPORT', NULL, 1, 'fa-laptop', '', 'USER MANAGEMENT  LOG REPORT', 0, 360, 0, 0, 1, 0, 0, '../login_management/log_report.php?db_name=log_user_management&id=233', 1, 0, 1, 0),
	(365, 'CREATE MENU', NULL, 0, 'fa-laptop', '#', '#', 0, 360, 1, 0, 0, 0, 0, '../Admistration/add_menu.php', 4, 0, 0, 0),
	(366, 'ATTENDENCE', NULL, 0, 'fa-laptop', '#', '#', 0, 1, 0, 1, 0, 0, 0, '../employee/attendance_register_emp.php', 0, 0, 0, 0),
	(367, 'ACTIVE EMPLOYEES REPORT', NULL, 0, 'fa-laptop', '#', '#', 0, 357, 0, 0, 1, 0, 0, '../task_management/task_all_report.php', 0, 0, 0, 0),
	(368, 'PROJECTWISE TASK REPORT', NULL, 0, 'fa-laptop', '#', '#', 0, 357, 0, 0, 1, 0, 0, '../task_management/project_wise_report.php', 1, 0, 0, 0),
	(369, 'EMPLOYEE WISE TASK REPORT', NULL, 0, 'fa-laptop', '#', '#', 0, 357, 0, 0, 1, 0, 0, '../task_management/employee_work_report.PHP', 0, 0, 0, 0),
	(370, 'MONTH ATTENDENCE REGISTER ALL', NULL, 0, 'fa-laptop', '', '#', 0, 1, 0, 0, 1, 0, 0, '../hrm/inoutsum_all.php', 2, 0, 0, 0),
	(371, 'MONTH ATTENDENCE REGISTER ANALIZE', NULL, 0, 'fa-laptop', '', '#', 0, 1, 0, 0, 1, 0, 0, '../hrm/inoutsum_all_sum.php', 2, 0, 0, 0);
/*!40000 ALTER TABLE `menu` ENABLE KEYS */;


-- Dumping structure for table chiru.messages_for_employees
CREATE TABLE IF NOT EXISTS `messages_for_employees` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_id` varchar(50) NOT NULL DEFAULT '0',
  `emp_msg_id` int(11) NOT NULL DEFAULT '0',
  `msg` blob,
  `create_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) NOT NULL DEFAULT '0',
  `status` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.messages_for_employees: ~0 rows (approximately)
/*!40000 ALTER TABLE `messages_for_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages_for_employees` ENABLE KEYS */;


-- Dumping structure for table chiru.notice_board
CREATE TABLE IF NOT EXISTS `notice_board` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` longtext,
  `priority` smallint(4) NOT NULL DEFAULT '0',
  `date` date DEFAULT NULL,
  `status` enum('0','1') DEFAULT '0' COMMENT '0=inactive 1=active',
  `status_for` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0 student 1employee',
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.notice_board: ~0 rows (approximately)
/*!40000 ALTER TABLE `notice_board` DISABLE KEYS */;
/*!40000 ALTER TABLE `notice_board` ENABLE KEYS */;


-- Dumping structure for table chiru.org_account
CREATE TABLE IF NOT EXISTS `org_account` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date1` date DEFAULT NULL,
  `product_id` int(11) DEFAULT NULL,
  `perticular_name` varchar(255) DEFAULT NULL,
  `no_item` varchar(255) DEFAULT NULL,
  `selling_price` int(11) unsigned zerofill DEFAULT NULL,
  `per_unit_sell_price` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `dr` varchar(255) DEFAULT NULL,
  `cr` varchar(255) DEFAULT NULL,
  `v_no` varchar(255) DEFAULT NULL,
  `perticular_type` enum('0','1','2','3','4','5') DEFAULT NULL COMMENT '0= Income,1= Fees,2=Transport,3=Sale,4=Salary,5=purchase',
  `amount_type` enum('0','1') DEFAULT NULL COMMENT '0= Income (DR), 1= Expense (CR)',
  `created_by` int(11) DEFAULT NULL,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.org_account: ~0 rows (approximately)
/*!40000 ALTER TABLE `org_account` DISABLE KEYS */;
/*!40000 ALTER TABLE `org_account` ENABLE KEYS */;


-- Dumping structure for table chiru.payroll_basic_pay
CREATE TABLE IF NOT EXISTS `payroll_basic_pay` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `percentage` int(11) DEFAULT NULL,
  `payrool_id` varchar(50) DEFAULT NULL COMMENT 'basic_pay',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.payroll_basic_pay: ~0 rows (approximately)
/*!40000 ALTER TABLE `payroll_basic_pay` DISABLE KEYS */;
/*!40000 ALTER TABLE `payroll_basic_pay` ENABLE KEYS */;


-- Dumping structure for table chiru.payroll_categories
CREATE TABLE IF NOT EXISTS `payroll_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `payroll_category_id` int(11) DEFAULT NULL,
  `is_deduction` tinyint(1) DEFAULT NULL COMMENT '1=deduction,0=earning',
  `deduction_type` tinyint(1) DEFAULT NULL COMMENT '1=day basis, 0=monthly',
  `radio` varchar(255) DEFAULT NULL COMMENT 'f=fixed amount and p means percentage amount',
  `deduction_from` varchar(50) DEFAULT NULL,
  `amount` float DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=2340;

-- Dumping data for table chiru.payroll_categories: ~0 rows (approximately)
/*!40000 ALTER TABLE `payroll_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `payroll_categories` ENABLE KEYS */;


-- Dumping structure for table chiru.payroll_categories_salarygroup
CREATE TABLE IF NOT EXISTS `payroll_categories_salarygroup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `salarygroup_id` int(11) DEFAULT NULL,
  `payroll_head_id` varchar(50) DEFAULT NULL,
  `payroll_head_type` varchar(50) DEFAULT NULL COMMENT '0=dedction,1=earning',
  `is_percentage` int(11) DEFAULT NULL COMMENT '1=percentage, 0=fix',
  `percentage` float DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.payroll_categories_salarygroup: ~0 rows (approximately)
/*!40000 ALTER TABLE `payroll_categories_salarygroup` DISABLE KEYS */;
/*!40000 ALTER TABLE `payroll_categories_salarygroup` ENABLE KEYS */;


-- Dumping structure for table chiru.payroll_other_deduction
CREATE TABLE IF NOT EXISTS `payroll_other_deduction` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `status` enum('Y','N') DEFAULT 'Y',
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.payroll_other_deduction: ~0 rows (approximately)
/*!40000 ALTER TABLE `payroll_other_deduction` DISABLE KEYS */;
/*!40000 ALTER TABLE `payroll_other_deduction` ENABLE KEYS */;


-- Dumping structure for table chiru.payroll_salarygroup
CREATE TABLE IF NOT EXISTS `payroll_salarygroup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.payroll_salarygroup: ~0 rows (approximately)
/*!40000 ALTER TABLE `payroll_salarygroup` DISABLE KEYS */;
/*!40000 ALTER TABLE `payroll_salarygroup` ENABLE KEYS */;


-- Dumping structure for table chiru.payroll_settings
CREATE TABLE IF NOT EXISTS `payroll_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `days` int(11) DEFAULT NULL COMMENT '1=total days, 2=working days',
  `holidays` int(11) DEFAULT NULL COMMENT '1=include 2=exclude',
  `week_off` int(11) DEFAULT NULL COMMENT '1=include 2=exclude',
  `compensation` int(11) DEFAULT NULL COMMENT '1=overtime 2=exculde',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.payroll_settings: ~0 rows (approximately)
/*!40000 ALTER TABLE `payroll_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `payroll_settings` ENABLE KEYS */;


-- Dumping structure for table chiru.recruit_interview
CREATE TABLE IF NOT EXISTS `recruit_interview` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `recr_stag_id` int(11) NOT NULL DEFAULT '0',
  `interviwer_id` varchar(50) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.recruit_interview: ~0 rows (approximately)
/*!40000 ALTER TABLE `recruit_interview` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_interview` ENABLE KEYS */;


-- Dumping structure for table chiru.recruit_round
CREATE TABLE IF NOT EXISTS `recruit_round` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `round_name` varchar(50) NOT NULL DEFAULT '0',
  `priority` varchar(50) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.recruit_round: ~0 rows (approximately)
/*!40000 ALTER TABLE `recruit_round` DISABLE KEYS */;
/*!40000 ALTER TABLE `recruit_round` ENABLE KEYS */;


-- Dumping structure for table chiru.reimbursement_claim_approve
CREATE TABLE IF NOT EXISTS `reimbursement_claim_approve` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) DEFAULT NULL COMMENT 'session id user table id',
  `apply_od_id` int(11) DEFAULT NULL,
  `od_date` date DEFAULT NULL,
  `remark` varchar(250) DEFAULT NULL,
  `claim_id` timestamp NULL DEFAULT NULL,
  `amount` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT '0',
  `approving_manager` int(11) DEFAULT NULL COMMENT 'user table id',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.reimbursement_claim_approve: ~0 rows (approximately)
/*!40000 ALTER TABLE `reimbursement_claim_approve` DISABLE KEYS */;
/*!40000 ALTER TABLE `reimbursement_claim_approve` ENABLE KEYS */;


-- Dumping structure for table chiru.requitment
CREATE TABLE IF NOT EXISTS `requitment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `job_title` int(11) NOT NULL DEFAULT '0',
  `department` int(11) NOT NULL DEFAULT '0',
  `no_of_vacancies` int(11) NOT NULL DEFAULT '0',
  `location` int(11) NOT NULL DEFAULT '0',
  `description` longtext NOT NULL,
  `approver_id` varchar(50) NOT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.requitment: ~0 rows (approximately)
/*!40000 ALTER TABLE `requitment` DISABLE KEYS */;
/*!40000 ALTER TABLE `requitment` ENABLE KEYS */;


-- Dumping structure for table chiru.resignation_latter
CREATE TABLE IF NOT EXISTS `resignation_latter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_id` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0' COMMENT '0=pending,1=approved,2=disapproved,3=applied,4=deleted',
  `apply_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `remark` longtext NOT NULL,
  `by_user_id` int(11) NOT NULL,
  `notice_periad_start` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.resignation_latter: ~0 rows (approximately)
/*!40000 ALTER TABLE `resignation_latter` DISABLE KEYS */;
/*!40000 ALTER TABLE `resignation_latter` ENABLE KEYS */;


-- Dumping structure for table chiru.resign_cycle_emp
CREATE TABLE IF NOT EXISTS `resign_cycle_emp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_id` int(11) NOT NULL DEFAULT '0',
  `level_id` int(11) NOT NULL DEFAULT '0',
  `approved_id` int(11) NOT NULL DEFAULT '0',
  `status` varchar(50) NOT NULL DEFAULT '0',
  `remarks` varchar(255) NOT NULL DEFAULT '0',
  `emp_apply_date` varchar(50) NOT NULL DEFAULT '0',
  `approver_app_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `resign_id` int(11) NOT NULL DEFAULT '0',
  `cheek_status` int(11) NOT NULL DEFAULT '0' COMMENT '0=off,1=yes',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.resign_cycle_emp: ~0 rows (approximately)
/*!40000 ALTER TABLE `resign_cycle_emp` DISABLE KEYS */;
/*!40000 ALTER TABLE `resign_cycle_emp` ENABLE KEYS */;


-- Dumping structure for table chiru.salaryrange_setting
CREATE TABLE IF NOT EXISTS `salaryrange_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) DEFAULT NULL,
  `status` enum('Y','N') DEFAULT 'Y' COMMENT '''Y''=Active, ''N''=Inactive',
  `start` int(11) DEFAULT NULL,
  `end` int(11) DEFAULT NULL,
  `created_by` varchar(45) DEFAULT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.salaryrange_setting: ~0 rows (approximately)
/*!40000 ALTER TABLE `salaryrange_setting` DISABLE KEYS */;
/*!40000 ALTER TABLE `salaryrange_setting` ENABLE KEYS */;


-- Dumping structure for table chiru.shift_log
CREATE TABLE IF NOT EXISTS `shift_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_id` int(11) DEFAULT NULL,
  `loc_id` int(11) DEFAULT NULL,
  `type` int(11) DEFAULT NULL COMMENT 'type=''1''=by group,type=''2''->by department, type=3->By employee',
  `type_id` int(11) DEFAULT NULL COMMENT 'if type=''1'' than type_id=group_id and type=''2'' than type_id=''dep_id''',
  `shift_id` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `assign_date` datetime DEFAULT NULL,
  `change_date` datetime DEFAULT NULL,
  `remove_date` datetime NOT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table chiru.shift_log: ~0 rows (approximately)
/*!40000 ALTER TABLE `shift_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `shift_log` ENABLE KEYS */;


-- Dumping structure for table chiru.shortleave_setting
CREATE TABLE IF NOT EXISTS `shortleave_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `frequency` int(11) DEFAULT NULL COMMENT '1=weekly,2=monthly',
  `max_leave_taken` int(11) DEFAULT NULL,
  `max_leave` int(11) DEFAULT NULL,
  `leave_time` int(11) DEFAULT NULL,
  `apply_aftime` int(11) DEFAULT NULL,
  `apply_bftime` int(11) DEFAULT NULL,
  `created_by` varchar(45) DEFAULT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.shortleave_setting: ~0 rows (approximately)
/*!40000 ALTER TABLE `shortleave_setting` DISABLE KEYS */;
/*!40000 ALTER TABLE `shortleave_setting` ENABLE KEYS */;


-- Dumping structure for table chiru.states
CREATE TABLE IF NOT EXISTS `states` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `state_name` varchar(255) NOT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.states: ~30 rows (approximately)
/*!40000 ALTER TABLE `states` DISABLE KEYS */;
INSERT INTO `states` (`id`, `state_name`, `company_id`) VALUES
	(1, 'Uttar Pradesh', 0),
	(2, 'Maharashtra', 0),
	(3, 'Bihar', 0),
	(4, 'West Bengal', 0),
	(5, 'Madhya Pradesh', 0),
	(6, 'Tamil Nadu', 0),
	(7, 'Rajasthan', 0),
	(8, 'Karnataka', 0),
	(9, 'Gujarat', 0),
	(10, 'Andhra Pradesh', 0),
	(11, 'Orissa', 0),
	(12, 'Telangana', 0),
	(13, 'Kerala', 0),
	(14, 'Jharkhand', 0),
	(15, 'Assam', 0),
	(16, 'Punjab', 0),
	(17, 'Chhattisgarh', 0),
	(18, 'Haryana', 0),
	(19, 'Jammu and Kashmir', 0),
	(20, 'Uttarakhand', 0),
	(21, 'Himachal Pradesh', 0),
	(22, 'Tripura', 0),
	(23, 'Meghalaya', 0),
	(24, 'Manipur', 0),
	(25, 'Nagaland', 0),
	(26, 'Goa', 0),
	(27, 'Arunachal Pradesh', 0),
	(28, 'Mizoram', 0),
	(29, 'Sikkim', 0),
	(30, 'Delhi', 0);
/*!40000 ALTER TABLE `states` ENABLE KEYS */;


-- Dumping structure for table chiru.students
CREATE TABLE IF NOT EXISTS `students` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admission_no` varchar(255) NOT NULL,
  `form_no` varchar(255) DEFAULT NULL,
  `class_roll_no` varchar(255) NOT NULL,
  `admission_date` date DEFAULT NULL,
  `prefix` varchar(255) DEFAULT NULL,
  `first_name` varchar(255) DEFAULT NULL,
  `middle_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `batch_id` int(11) DEFAULT NULL,
  `section_id` int(11) DEFAULT '0',
  `course_id` int(11) NOT NULL,
  `date_of_birth` date DEFAULT NULL,
  `gender` varchar(255) DEFAULT NULL,
  `blood_group` varchar(255) DEFAULT NULL,
  `birth_place` varchar(255) DEFAULT NULL,
  `nationality_id` int(11) DEFAULT NULL,
  `nationality_type` varchar(255) DEFAULT NULL,
  `nationality` varchar(255) DEFAULT NULL,
  `language` varchar(255) DEFAULT NULL,
  `passport_exp_date` datetime DEFAULT NULL,
  `passport_no` varchar(255) DEFAULT NULL,
  `visa_no` varchar(255) NOT NULL,
  `visa_issdate` datetime NOT NULL,
  `visa_validity` datetime DEFAULT NULL,
  `religion` varchar(255) DEFAULT NULL,
  `domstate` varchar(255) DEFAULT NULL,
  `student_category_id` int(11) DEFAULT NULL,
  `student_type` int(11) DEFAULT NULL,
  `exchange_from` varchar(255) DEFAULT '',
  `address_line1` varchar(255) DEFAULT NULL,
  `address_line2` varchar(255) DEFAULT NULL,
  `local_guardians` varchar(255) DEFAULT NULL,
  `local_contacts` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `pin_code` varchar(255) DEFAULT NULL,
  `country_id` int(11) DEFAULT NULL,
  `phone1` varchar(255) DEFAULT NULL,
  `phone2` varchar(255) DEFAULT NULL,
  `embassy_name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `immediate_contact_id` int(11) DEFAULT NULL,
  `document_submit` varchar(255) DEFAULT NULL,
  `is_sms_enabled` tinyint(1) DEFAULT '1',
  `photo_file_name` varchar(255) DEFAULT NULL,
  `photo_content_type` varchar(255) DEFAULT NULL,
  `photo_data` mediumblob,
  `status_description` varchar(255) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT '1',
  `pre_status` tinyint(1) DEFAULT '1',
  `is_deleted` tinyint(1) DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `has_paid_fees` tinyint(1) DEFAULT '0',
  `photo_file_size` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `library_card` varchar(255) DEFAULT NULL,
  `bio_card_number` varchar(255) DEFAULT NULL,
  `bio_card_to_machine` int(11) DEFAULT '0' COMMENT '0= not 1=yes',
  `is_email_enabled` tinyint(1) DEFAULT '1',
  `sibling_id` int(11) DEFAULT NULL,
  `done` varchar(50) DEFAULT NULL,
  `ref_type` enum('1','2','3','4') DEFAULT '4' COMMENT '1=Refer By Student, 2=Refer Employee, 3=Refer By Agent, 4=Direct Admission',
  `ref_id` int(11) DEFAULT NULL,
  `done1` varchar(50) DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `address_line1` (`address_line1`),
  KEY `address_line1_2` (`address_line1`),
  KEY `address_line2` (`address_line2`),
  KEY `address_line2_2` (`address_line2`),
  KEY `address_line2_3` (`address_line2`),
  KEY `admission_date` (`admission_date`),
  KEY `admission_no` (`admission_no`),
  KEY `batch_id` (`batch_id`),
  KEY `birth_place` (`birth_place`),
  KEY `birth_place_2` (`birth_place`),
  KEY `blood_group` (`blood_group`),
  KEY `course_id` (`course_id`),
  KEY `date_of_birth` (`date_of_birth`),
  KEY `domstate` (`domstate`),
  KEY `domstate_2` (`domstate`),
  KEY `domstate_3` (`domstate`),
  KEY `domstate_4` (`domstate`),
  KEY `domstate_5` (`domstate`),
  KEY `domstate_6` (`domstate`),
  KEY `email` (`email`),
  KEY `exchange_from` (`exchange_from`),
  KEY `exchange_from_2` (`exchange_from`),
  KEY `exchange_from_3` (`exchange_from`),
  KEY `first_name` (`first_name`),
  KEY `first_name_2` (`first_name`,`middle_name`,`last_name`),
  KEY `index_students_on_admission_no` (`admission_no`(10)),
  KEY `index_students_on_batch_id` (`batch_id`),
  KEY `index_students_on_first_name_and_middle_name_and_last_name` (`first_name`(10),`middle_name`(10),`last_name`(10)),
  KEY `last_name` (`last_name`),
  KEY `local_contacts` (`local_contacts`),
  KEY `local_contacts_2` (`local_contacts`),
  KEY `local_guardians` (`local_guardians`),
  KEY `local_guardians_2` (`local_guardians`),
  KEY `nationality` (`nationality`),
  KEY `passport_exp_date` (`passport_exp_date`),
  KEY `passport_no` (`passport_no`),
  KEY `phone1` (`phone1`),
  KEY `pin_code` (`pin_code`),
  KEY `religion` (`religion`),
  KEY `religion_2` (`religion`),
  KEY `student_category_id` (`student_category_id`),
  KEY `student_category_id_2` (`student_category_id`),
  KEY `student_data_index` (`nationality_id`,`immediate_contact_id`,`student_category_id`),
  KEY `student_type` (`student_type`),
  KEY `visa_validity` (`visa_validity`),
  KEY `visa_validity_2` (`visa_validity`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.students: ~0 rows (approximately)
/*!40000 ALTER TABLE `students` DISABLE KEYS */;
/*!40000 ALTER TABLE `students` ENABLE KEYS */;


-- Dumping structure for table chiru.student_categories
CREATE TABLE IF NOT EXISTS `student_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.student_categories: ~0 rows (approximately)
/*!40000 ALTER TABLE `student_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `student_categories` ENABLE KEYS */;


-- Dumping structure for table chiru.subject_leaves
CREATE TABLE IF NOT EXISTS `subject_leaves` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) DEFAULT NULL,
  `month_date` date DEFAULT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `employee_id` int(11) DEFAULT NULL,
  `class_timing_id` int(11) DEFAULT NULL,
  `reason` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `batch_id` int(11) DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `index_subject_leaves_on_month_date_and_subject_id_and_batch_id` (`month_date`,`subject_id`,`batch_id`),
  KEY `index_subject_leaves_on_student_id_and_batch_id` (`student_id`,`batch_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.subject_leaves: ~0 rows (approximately)
/*!40000 ALTER TABLE `subject_leaves` DISABLE KEYS */;
/*!40000 ALTER TABLE `subject_leaves` ENABLE KEYS */;


-- Dumping structure for table chiru.subtask
CREATE TABLE IF NOT EXISTS `subtask` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) DEFAULT NULL,
  `task_id` int(11) DEFAULT NULL,
  `sub_task_name` longtext,
  `task_created_by` int(11) NOT NULL DEFAULT '0',
  `priority` enum('0','1','2') DEFAULT NULL COMMENT '0=Low,1=Normal,2=high',
  `task_des` blob NOT NULL COMMENT 'task description',
  `active` enum('Y','N') DEFAULT 'N' COMMENT 'y=active,n=inactive',
  `task_staus` enum('0','1','2','3','4','5','6') DEFAULT NULL COMMENT '0=pending,1=done,2=half done,3=percial done,4=dead line over,5=done before dead line',
  `startdate` datetime DEFAULT NULL,
  `enddate` datetime DEFAULT NULL,
  `deadline` datetime DEFAULT NULL,
  `createddate` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `modify_date` timestamp NULL DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.subtask: ~0 rows (approximately)
/*!40000 ALTER TABLE `subtask` DISABLE KEYS */;
/*!40000 ALTER TABLE `subtask` ENABLE KEYS */;


-- Dumping structure for table chiru.sub_task_assignees
CREATE TABLE IF NOT EXISTS `sub_task_assignees` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) DEFAULT NULL,
  `sub_task_id` int(11) DEFAULT NULL,
  `task_id` int(11) DEFAULT NULL,
  `responsible_id` int(11) DEFAULT NULL COMMENT 'Responsible Person',
  `participant_ids` varchar(255) DEFAULT NULL COMMENT 'Participants ids',
  `observer_ids` varchar(255) DEFAULT NULL COMMENT 'Observers ids ',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.sub_task_assignees: ~0 rows (approximately)
/*!40000 ALTER TABLE `sub_task_assignees` DISABLE KEYS */;
/*!40000 ALTER TABLE `sub_task_assignees` ENABLE KEYS */;


-- Dumping structure for table chiru.sub_task_check_list
CREATE TABLE IF NOT EXISTS `sub_task_check_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `project_id` int(11) DEFAULT NULL,
  `subtask_id` int(11) DEFAULT NULL,
  `task_id` int(11) DEFAULT NULL,
  `descpirtion` blob,
  `status` enum('Y','N') DEFAULT 'N',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `checklist_status` int(11) DEFAULT NULL COMMENT '1=Pending, 2=Approved',
  `viewed_by_observer` int(11) DEFAULT '0' COMMENT '0= not viewed,1=''viewed''',
  `approved_status` int(11) DEFAULT '0' COMMENT '0=not approved, 1=''approved''',
  `observer_remark` varchar(255) DEFAULT NULL,
  `approving_observer_id` int(11) DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.sub_task_check_list: ~0 rows (approximately)
/*!40000 ALTER TABLE `sub_task_check_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `sub_task_check_list` ENABLE KEYS */;


-- Dumping structure for table chiru.sub_task_details
CREATE TABLE IF NOT EXISTS `sub_task_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(11) NOT NULL DEFAULT '0',
  `sub_task_id` int(11) NOT NULL DEFAULT '0',
  `task_status` enum('0','1') DEFAULT NULL COMMENT '0=Assign,1=Process',
  `createddate` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `participants_ids` varchar(255) DEFAULT NULL COMMENT 'Participants_ids',
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.sub_task_details: ~0 rows (approximately)
/*!40000 ALTER TABLE `sub_task_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `sub_task_details` ENABLE KEYS */;


-- Dumping structure for table chiru.table_details
CREATE TABLE IF NOT EXISTS `table_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `table_name` varchar(255) DEFAULT NULL,
  `table_details` varchar(255) DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.table_details: ~0 rows (approximately)
/*!40000 ALTER TABLE `table_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `table_details` ENABLE KEYS */;


-- Dumping structure for table chiru.task
CREATE TABLE IF NOT EXISTS `task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) DEFAULT NULL,
  `task_created_by` int(11) NOT NULL DEFAULT '0',
  `task_name` longtext,
  `priority` enum('0','1','2') DEFAULT NULL COMMENT '0=Low,1=Normal,2=high',
  `task_des` blob NOT NULL COMMENT 'task description',
  `active` enum('Y','N') DEFAULT 'N' COMMENT 'y=active,n=inactive',
  `task_staus` enum('0','1','2','3','4','5','6','7','8','9','10','11','12') DEFAULT NULL COMMENT '0=pending,1=done,2=half done,3=percial done,4=dead line over,5=done before dead line,8=testing,9=completed,10=''continue'',11=''for update'',12=''closed''',
  `startdate` datetime DEFAULT NULL,
  `enddate` datetime DEFAULT NULL,
  `deadline` datetime DEFAULT NULL,
  `createddate` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `modify_date` timestamp NULL DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  `sub_task_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.task: ~0 rows (approximately)
/*!40000 ALTER TABLE `task` DISABLE KEYS */;
/*!40000 ALTER TABLE `task` ENABLE KEYS */;


-- Dumping structure for table chiru.task_assignees
CREATE TABLE IF NOT EXISTS `task_assignees` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(11) DEFAULT NULL,
  `responsible_id` int(11) DEFAULT NULL COMMENT 'Responsible Person',
  `participant_ids` varchar(255) DEFAULT NULL COMMENT 'Participants ids',
  `observer_ids` varchar(255) DEFAULT NULL COMMENT 'Observers ids ',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.task_assignees: ~0 rows (approximately)
/*!40000 ALTER TABLE `task_assignees` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_assignees` ENABLE KEYS */;


-- Dumping structure for table chiru.task_check_list
CREATE TABLE IF NOT EXISTS `task_check_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `task_id` int(11) DEFAULT NULL,
  `descpirtion` blob,
  `status` enum('Y','N') DEFAULT 'N',
  `viewed_by_observer` int(11) DEFAULT '0' COMMENT '''0= not viewed,1=\\''viewed\\',
  `approved_status` int(11) DEFAULT '0' COMMENT ' ''0=default, 1=\\''approved\\'',2=\\''not approved\\',
  `observer_remark` varchar(255) DEFAULT NULL,
  `approving_observer_id` int(50) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `checklist_status` int(11) DEFAULT NULL COMMENT '1=Pending, 2=Approved',
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.task_check_list: ~0 rows (approximately)
/*!40000 ALTER TABLE `task_check_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_check_list` ENABLE KEYS */;


-- Dumping structure for table chiru.task_details
CREATE TABLE IF NOT EXISTS `task_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(11) NOT NULL DEFAULT '0',
  `task_status` enum('0','1') DEFAULT NULL COMMENT '0=Assign,1=Process',
  `createddate` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `participants_ids` varchar(255) DEFAULT NULL COMMENT 'Participants_ids',
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.task_details: ~0 rows (approximately)
/*!40000 ALTER TABLE `task_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_details` ENABLE KEYS */;


-- Dumping structure for table chiru.task_project
CREATE TABLE IF NOT EXISTS `task_project` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_created_by` int(11) DEFAULT '0',
  `project_name` varchar(255) NOT NULL DEFAULT '0',
  `project_status` enum('1','0') DEFAULT '0' COMMENT '1=''continues'',0=''non-continuos''',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `active` enum('Y','N') DEFAULT 'N',
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.task_project: ~0 rows (approximately)
/*!40000 ALTER TABLE `task_project` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_project` ENABLE KEYS */;


-- Dumping structure for table chiru.task_situation
CREATE TABLE IF NOT EXISTS `task_situation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(11) NOT NULL,
  `task_status` enum('2','3','4') DEFAULT NULL COMMENT '2=Pause,3=Resume,4=Complete',
  `participants_ids` varchar(255) DEFAULT NULL COMMENT 'Participants_ids',
  `createddate` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.task_situation: ~0 rows (approximately)
/*!40000 ALTER TABLE `task_situation` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_situation` ENABLE KEYS */;


-- Dumping structure for table chiru.task_timing
CREATE TABLE IF NOT EXISTS `task_timing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL COMMENT ' ',
  `start_time` time DEFAULT '00:00:00' COMMENT ' ',
  `end_time` time DEFAULT '00:00:00',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.task_timing: ~0 rows (approximately)
/*!40000 ALTER TABLE `task_timing` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_timing` ENABLE KEYS */;


-- Dumping structure for table chiru.tax_age_details
CREATE TABLE IF NOT EXISTS `tax_age_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year_id` int(11) NOT NULL DEFAULT '0',
  `age` varchar(50) NOT NULL DEFAULT '0',
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.tax_age_details: ~0 rows (approximately)
/*!40000 ALTER TABLE `tax_age_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `tax_age_details` ENABLE KEYS */;


-- Dumping structure for table chiru.tax_income_details
CREATE TABLE IF NOT EXISTS `tax_income_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year_id` int(11) NOT NULL DEFAULT '0',
  `income_rage` varchar(255) NOT NULL DEFAULT '0',
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.tax_income_details: ~0 rows (approximately)
/*!40000 ALTER TABLE `tax_income_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `tax_income_details` ENABLE KEYS */;


-- Dumping structure for table chiru.tax_rate_details
CREATE TABLE IF NOT EXISTS `tax_rate_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year_id` int(11) NOT NULL DEFAULT '0',
  `age_id` int(11) NOT NULL DEFAULT '0',
  `income_rage_id` int(11) NOT NULL DEFAULT '0',
  `percentage` int(11) DEFAULT '0',
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.tax_rate_details: ~0 rows (approximately)
/*!40000 ALTER TABLE `tax_rate_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `tax_rate_details` ENABLE KEYS */;


-- Dumping structure for table chiru.tax_year
CREATE TABLE IF NOT EXISTS `tax_year` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` varchar(50) NOT NULL DEFAULT '0',
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.tax_year: ~0 rows (approximately)
/*!40000 ALTER TABLE `tax_year` DISABLE KEYS */;
/*!40000 ALTER TABLE `tax_year` ENABLE KEYS */;


-- Dumping structure for table chiru.tblt_timesheet
CREATE TABLE IF NOT EXISTS `tblt_timesheet` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `punchingcode` int(11) NOT NULL COMMENT 'employee id',
  `date` date DEFAULT NULL,
  `date_time1` timestamp NULL DEFAULT NULL,
  `by_hr` int(11) unsigned DEFAULT NULL COMMENT 'user table id',
  `shift_id` int(11) unsigned DEFAULT '0',
  `attendence_type` varchar(255) DEFAULT NULL COMMENT 'OD=persent with od,MO=again modify,BA=bluck attendence',
  `ip` varchar(50) DEFAULT NULL,
  `port` varchar(50) DEFAULT NULL,
  `time` time DEFAULT NULL,
  `date_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `Tid` decimal(5,0) DEFAULT NULL COMMENT '2= punch in 3= punchout',
  `device` varchar(50) DEFAULT NULL,
  `update1` enum('0','1') DEFAULT '0',
  `nEventIdn` varchar(50) DEFAULT 're1',
  `emp_id` int(11) DEFAULT NULL,
  `od_id` int(11) DEFAULT NULL,
  `short_leave_id` int(11) DEFAULT NULL,
  `details_update` int(11) DEFAULT '0',
  `company_id` int(11) DEFAULT '0',
  `current_location` varchar(255) DEFAULT NULL,
  `lat` varchar(255) DEFAULT NULL,
  `lng` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.tblt_timesheet: ~0 rows (approximately)
/*!40000 ALTER TABLE `tblt_timesheet` DISABLE KEYS */;
/*!40000 ALTER TABLE `tblt_timesheet` ENABLE KEYS */;


-- Dumping structure for table chiru.tblt_timesheet_arc
CREATE TABLE IF NOT EXISTS `tblt_timesheet_arc` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `punchingcode` int(11) NOT NULL COMMENT 'employee id',
  `date` date DEFAULT NULL,
  `date_time1` timestamp NULL DEFAULT NULL,
  `by_hr` int(11) unsigned DEFAULT NULL COMMENT 'user table id',
  `shift_id` int(11) unsigned DEFAULT '0',
  `attendence_type` varchar(255) DEFAULT NULL COMMENT 'OD=persent with od,MO=again modify,BA=bluck attendence',
  `ip` varchar(50) DEFAULT NULL,
  `port` varchar(50) DEFAULT NULL,
  `time` time DEFAULT NULL,
  `date_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `Tid` decimal(5,0) DEFAULT NULL COMMENT '2= punch in 3= punchout',
  `device` varchar(50) DEFAULT NULL,
  `update1` enum('0','1') DEFAULT '0',
  `nEventIdn` varchar(50) DEFAULT 're1',
  `emp_id` int(11) DEFAULT NULL,
  `od_id` int(11) DEFAULT NULL,
  `short_leave_id` int(11) DEFAULT NULL,
  `details_update` int(11) DEFAULT '0',
  `company_id` int(11) DEFAULT '0',
  `current_location` varchar(255) DEFAULT NULL,
  `lat` varchar(255) DEFAULT NULL,
  `lng` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.tblt_timesheet_arc: ~0 rows (approximately)
/*!40000 ALTER TABLE `tblt_timesheet_arc` DISABLE KEYS */;
/*!40000 ALTER TABLE `tblt_timesheet_arc` ENABLE KEYS */;


-- Dumping structure for table chiru.tblt_timesheet_cal
CREATE TABLE IF NOT EXISTS `tblt_timesheet_cal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `punchingcode` int(11) NOT NULL COMMENT 'employee id',
  `date` date DEFAULT NULL,
  `start_time` timestamp NULL DEFAULT NULL,
  `end_time` timestamp NULL DEFAULT NULL,
  `toll_time` int(11) DEFAULT NULL,
  `shift_id` int(11) unsigned DEFAULT '0',
  `day_count` varchar(255) DEFAULT '0',
  `total_working_hr` varchar(255) DEFAULT '0',
  `shift_working_hr_sec` varchar(255) DEFAULT '0',
  `late_early` varchar(255) DEFAULT '0',
  `total_working_hr_sec` varchar(255) DEFAULT '0',
  `shift_name` varchar(50) DEFAULT '0',
  `shift_start_time` varchar(50) DEFAULT '0',
  `shift_end_time` varchar(50) DEFAULT '0',
  `shift_working_hours` varchar(50) DEFAULT '0',
  `shift_gross_time` varchar(50) DEFAULT '0',
  `shift_half_day` varchar(50) DEFAULT '0',
  `date_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `emp_id` int(11) DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  `is_leave` int(11) DEFAULT NULL,
  `is_leave_type` int(11) DEFAULT NULL,
  `is_od` int(11) DEFAULT NULL,
  `is_short_leave` varchar(255) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10938 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.tblt_timesheet_cal: ~0 rows (approximately)
/*!40000 ALTER TABLE `tblt_timesheet_cal` DISABLE KEYS */;
/*!40000 ALTER TABLE `tblt_timesheet_cal` ENABLE KEYS */;


-- Dumping structure for table chiru.tbl_category
CREATE TABLE IF NOT EXISTS `tbl_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` longtext NOT NULL,
  `sub_cat` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=1820;

-- Dumping data for table chiru.tbl_category: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_category` ENABLE KEYS */;


-- Dumping structure for table chiru.tbl_deductions
CREATE TABLE IF NOT EXISTS `tbl_deductions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `deductions_rules_name` varchar(255) DEFAULT NULL,
  `deductions_limit` varchar(50) DEFAULT NULL,
  `deductions_discription` varchar(255) DEFAULT NULL,
  `deductions_details` blob,
  `group_limit` int(11) DEFAULT '0',
  `group_id` int(11) DEFAULT '0',
  `status` enum('Y','N') DEFAULT 'Y',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.tbl_deductions: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_deductions` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_deductions` ENABLE KEYS */;


-- Dumping structure for table chiru.tbl_deduct_record
CREATE TABLE IF NOT EXISTS `tbl_deduct_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_id` int(11) DEFAULT NULL,
  `year_id` int(11) DEFAULT NULL,
  `deduction_rules_id` int(11) DEFAULT NULL,
  `group_id` int(11) DEFAULT NULL,
  `amount` varchar(50) DEFAULT NULL,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.tbl_deduct_record: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_deduct_record` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_deduct_record` ENABLE KEYS */;


-- Dumping structure for table chiru.tbl_employee_group
CREATE TABLE IF NOT EXISTS `tbl_employee_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_id` int(45) DEFAULT NULL,
  `loc_id` int(11) DEFAULT NULL,
  `emp_number` varchar(255) DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL,
  `position_id` int(11) DEFAULT NULL,
  `group_id` int(11) DEFAULT NULL,
  `add_date` date DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.tbl_employee_group: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_employee_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_employee_group` ENABLE KEYS */;


-- Dumping structure for table chiru.tbl_employe_exit_level
CREATE TABLE IF NOT EXISTS `tbl_employe_exit_level` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_deg_id` int(11) DEFAULT NULL,
  `level` varchar(255) DEFAULT NULL,
  `level_name` varchar(255) DEFAULT NULL,
  `appover_set` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` varchar(50) DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  `type` enum('0','1') DEFAULT NULL COMMENT '0=employee,1=degination',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.tbl_employe_exit_level: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_employe_exit_level` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_employe_exit_level` ENABLE KEYS */;


-- Dumping structure for table chiru.tbl_group
CREATE TABLE IF NOT EXISTS `tbl_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) NOT NULL,
  `group_limit` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.tbl_group: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_group` ENABLE KEYS */;


-- Dumping structure for table chiru.tbl_hrm_shift
CREATE TABLE IF NOT EXISTS `tbl_hrm_shift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(11) DEFAULT NULL COMMENT 'type=''1''=by group,type=''2''->by department, type=3->By employee',
  `loc_id` int(11) DEFAULT NULL,
  `type_id` int(11) DEFAULT NULL COMMENT 'if type=''1'' than type_id=group_id and type=''2'' than type_id=''dep_id''',
  `emp_id` int(11) DEFAULT NULL,
  `shift_id` int(11) DEFAULT NULL,
  `day_off` varchar(255) DEFAULT NULL COMMENT '''0''=''sun'',''1''=''mon'',''2''=''tue'',''3''=''wed'',''4''=''thur'',''5''=''fri'',''6''=''sat''',
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `created_by` varchar(255) DEFAULT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.tbl_hrm_shift: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_hrm_shift` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_hrm_shift` ENABLE KEYS */;


-- Dumping structure for table chiru.tbl_hrm_shift_dayoff
CREATE TABLE IF NOT EXISTS `tbl_hrm_shift_dayoff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shift_id` int(11) DEFAULT NULL COMMENT 'shift insert id',
  `day_off` int(11) DEFAULT NULL,
  `day_name_shift` int(11) DEFAULT NULL,
  `half_day` int(11) DEFAULT '0',
  `created_by` varchar(255) DEFAULT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.tbl_hrm_shift_dayoff: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_hrm_shift_dayoff` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_hrm_shift_dayoff` ENABLE KEYS */;


-- Dumping structure for table chiru.tbl_icard
CREATE TABLE IF NOT EXISTS `tbl_icard` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stu_id` int(11) NOT NULL,
  `status` varchar(255) NOT NULL,
  `add_date` date NOT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=54;

-- Dumping data for table chiru.tbl_icard: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_icard` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_icard` ENABLE KEYS */;


-- Dumping structure for table chiru.tbl_inventory_location
CREATE TABLE IF NOT EXISTS `tbl_inventory_location` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=1365;

-- Dumping data for table chiru.tbl_inventory_location: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_inventory_location` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_inventory_location` ENABLE KEYS */;


-- Dumping structure for table chiru.tbl_issue_product_log
CREATE TABLE IF NOT EXISTS `tbl_issue_product_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` varchar(255) NOT NULL DEFAULT '0',
  `location_id` int(11) NOT NULL DEFAULT '0',
  `product_key` varchar(255) NOT NULL DEFAULT '0',
  `sub_cat` varchar(255) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `user_id` varchar(255) NOT NULL DEFAULT '0',
  `selling_price` int(11) NOT NULL DEFAULT '0',
  `dep_name` varchar(50) NOT NULL DEFAULT '0',
  `other_info` varchar(50) NOT NULL DEFAULT '0',
  `retern_info` varchar(50) NOT NULL DEFAULT '0',
  `no_item_issued` int(11) NOT NULL DEFAULT '0',
  `issue_date` datetime DEFAULT NULL,
  `selling_status` int(11) NOT NULL DEFAULT '0' COMMENT '0=issue product 1=selling product',
  `per_unit_sell_price` int(11) NOT NULL DEFAULT '0',
  `per_unit_buy_price` int(11) NOT NULL DEFAULT '0',
  `return_date` datetime DEFAULT NULL,
  `returnable_date` date DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=234;

-- Dumping data for table chiru.tbl_issue_product_log: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_issue_product_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_issue_product_log` ENABLE KEYS */;


-- Dumping structure for table chiru.tbl_notice_period
CREATE TABLE IF NOT EXISTS `tbl_notice_period` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `position_id` int(11) DEFAULT NULL,
  `days` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` varchar(50) DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  `type` enum('0','1') DEFAULT NULL COMMENT '0=employee,1=degination',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.tbl_notice_period: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_notice_period` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_notice_period` ENABLE KEYS */;


-- Dumping structure for table chiru.tbl_org_holidays
CREATE TABLE IF NOT EXISTS `tbl_org_holidays` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `year` int(15) NOT NULL,
  `month` varchar(255) NOT NULL,
  `date` varchar(15) NOT NULL,
  `holiday_name` varchar(255) NOT NULL,
  `loc_id` int(11) NOT NULL,
  `add_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=780;

-- Dumping data for table chiru.tbl_org_holidays: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_org_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_org_holidays` ENABLE KEYS */;


-- Dumping structure for table chiru.tbl_product
CREATE TABLE IF NOT EXISTS `tbl_product` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT 'NULL',
  `product_id` int(12) DEFAULT NULL,
  `sub_cat` varchar(50) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `category_id` varchar(255) NOT NULL,
  `tax` varchar(255) NOT NULL,
  `tax_total` varchar(255) NOT NULL,
  `invoice` varchar(255) NOT NULL,
  `pre_price` varchar(255) NOT NULL,
  `total` varchar(255) NOT NULL,
  `no_item` varchar(255) NOT NULL,
  `sal_pre_price` varchar(255) NOT NULL,
  `sal_total` varchar(255) NOT NULL,
  `sal_no_item` varchar(255) NOT NULL,
  `vendor_id` int(11) DEFAULT NULL,
  `product_type_id` int(11) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=528;

-- Dumping data for table chiru.tbl_product: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_product` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_product` ENABLE KEYS */;


-- Dumping structure for table chiru.tbl_product_detail
CREATE TABLE IF NOT EXISTS `tbl_product_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `type` int(11) NOT NULL,
  `product_primary_id` int(11) unsigned NOT NULL,
  `user_id` varchar(255) NOT NULL,
  `location_id` int(11) NOT NULL,
  `category_id` varchar(50) NOT NULL,
  `sub_cat` varchar(50) NOT NULL,
  `dep_name` varchar(255) NOT NULL,
  `product_key` varchar(255) NOT NULL,
  `other_info` longtext NOT NULL,
  `profit` int(11) NOT NULL,
  `issue_status` int(11) NOT NULL DEFAULT '0' COMMENT '0means notissue and 1meansissue',
  `selling_status` int(11) NOT NULL DEFAULT '0' COMMENT '0=not a selling product or not sell 1=sell thisproduct',
  `selling_price` int(11) NOT NULL,
  `per_unit_sell_price` int(11) NOT NULL,
  `no_item` int(11) NOT NULL,
  `issue_date` datetime NOT NULL,
  `per_unit_buy_price` int(11) NOT NULL DEFAULT '0',
  `return_date` date NOT NULL,
  `returnable_date` date NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `is_deleted` int(12) NOT NULL DEFAULT '0',
  `is_consume` int(2) NOT NULL DEFAULT '0',
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=235;

-- Dumping data for table chiru.tbl_product_detail: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_product_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_product_detail` ENABLE KEYS */;


-- Dumping structure for table chiru.tbl_registration
CREATE TABLE IF NOT EXISTS `tbl_registration` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(255) NOT NULL,
  `organi_name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `website` varchar(255) NOT NULL,
  `phone_number` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `pin_code` varchar(255) NOT NULL,
  `country` varchar(255) NOT NULL,
  `txt_pass` varchar(255) NOT NULL,
  `lib_pass` varchar(255) NOT NULL,
  `receipt_number` varchar(255) NOT NULL,
  `logo` varchar(255) NOT NULL,
  `salt` longtext,
  `org_type` enum('0','1') NOT NULL DEFAULT '1' COMMENT '0=>for school, 1=>for college and university',
  `mode` enum('0','1') NOT NULL DEFAULT '1' COMMENT '0=cloud 1= off_line',
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.tbl_registration: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_registration` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_registration` ENABLE KEYS */;


-- Dumping structure for table chiru.tbl_set_tea_time
CREATE TABLE IF NOT EXISTS `tbl_set_tea_time` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shift_inserted_id` int(11) NOT NULL DEFAULT '0',
  `lunch_start_time` varchar(50) NOT NULL DEFAULT '0',
  `lunch_end_time` varchar(50) NOT NULL DEFAULT '0',
  `tea_start_time` varchar(50) NOT NULL DEFAULT '0',
  `tea_end_time` varchar(50) NOT NULL DEFAULT '0',
  `add_in_workinghours` enum('1','0') NOT NULL DEFAULT '0' COMMENT '1 = include in working hours , 0=execlude from working hours',
  `created_to` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.tbl_set_tea_time: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_set_tea_time` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_set_tea_time` ENABLE KEYS */;


-- Dumping structure for table chiru.tbl_tax
CREATE TABLE IF NOT EXISTS `tbl_tax` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `tax_value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `ss` varchar(50) DEFAULT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=4096;

-- Dumping data for table chiru.tbl_tax: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_tax` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_tax` ENABLE KEYS */;


-- Dumping structure for table chiru.tbl_type
CREATE TABLE IF NOT EXISTS `tbl_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=8192;

-- Dumping data for table chiru.tbl_type: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_type` ENABLE KEYS */;


-- Dumping structure for table chiru.tbl_user_login
CREATE TABLE IF NOT EXISTS `tbl_user_login` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `system_ip` varchar(255) NOT NULL,
  `login_time` datetime NOT NULL,
  `user_id` varchar(255) NOT NULL,
  `logout_time` datetime NOT NULL,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=72;

-- Dumping data for table chiru.tbl_user_login: ~0 rows (approximately)
/*!40000 ALTER TABLE `tbl_user_login` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_user_login` ENABLE KEYS */;


-- Dumping structure for table chiru.template_invoice
CREATE TABLE IF NOT EXISTS `template_invoice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cname` varchar(50) NOT NULL,
  `image` varchar(50) NOT NULL,
  `address` varchar(50) NOT NULL,
  `ph_no` varchar(50) NOT NULL,
  `email` varchar(50) NOT NULL,
  `website` varchar(50) NOT NULL,
  `note` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.template_invoice: ~0 rows (approximately)
/*!40000 ALTER TABLE `template_invoice` DISABLE KEYS */;
/*!40000 ALTER TABLE `template_invoice` ENABLE KEYS */;


-- Dumping structure for table chiru.title_web
CREATE TABLE IF NOT EXISTS `title_web` (
  `id` int(11) NOT NULL,
  `Title` varchar(255) DEFAULT NULL,
  `Is_active` enum('0','1') DEFAULT '0' COMMENT '0=not deleted,1=Deleted',
  `created_by` int(11) DEFAULT NULL,
  `created_on` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.title_web: ~0 rows (approximately)
/*!40000 ALTER TABLE `title_web` DISABLE KEYS */;
INSERT INTO `title_web` (`id`, `Title`, `Is_active`, `created_by`, `created_on`) VALUES
	(1, 'HRM - HCM', '0', 1, '2017-03-15 14:58:36');
/*!40000 ALTER TABLE `title_web` ENABLE KEYS */;


-- Dumping structure for table chiru.today_attandence
CREATE TABLE IF NOT EXISTS `today_attandence` (
  `emp_number` varchar(255) DEFAULT NULL,
  `attandence` timestamp NULL DEFAULT NULL,
  `company_id` int(11) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.today_attandence: ~0 rows (approximately)
/*!40000 ALTER TABLE `today_attandence` DISABLE KEYS */;
/*!40000 ALTER TABLE `today_attandence` ENABLE KEYS */;


-- Dumping structure for table chiru.transportation_mode_type
CREATE TABLE IF NOT EXISTS `transportation_mode_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '0',
  `charges` varchar(50) DEFAULT '0' COMMENT 'per km charges',
  `status` enum('Y','N') DEFAULT NULL COMMENT 'Y=active , N=Inactive',
  `is_mandatory` enum('Y','N') DEFAULT 'N',
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.transportation_mode_type: ~0 rows (approximately)
/*!40000 ALTER TABLE `transportation_mode_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `transportation_mode_type` ENABLE KEYS */;


-- Dumping structure for table chiru.users
CREATE TABLE IF NOT EXISTS `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(255) DEFAULT NULL,
  `first_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `secure_unqid` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `account_type` int(11) DEFAULT NULL,
  `admin` tinyint(1) NOT NULL DEFAULT '0',
  `student` tinyint(1) NOT NULL DEFAULT '0',
  `employee` tinyint(1) NOT NULL DEFAULT '0',
  `agent` tinyint(1) NOT NULL DEFAULT '0',
  `condidate` tinyint(1) NOT NULL DEFAULT '0',
  `hashed_password` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `reset_password_code` varchar(255) DEFAULT NULL,
  `reset_password_code_until` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  `parent` tinyint(1) DEFAULT NULL,
  `is_first_login` tinyint(1) DEFAULT NULL,
  `portal_use` tinyint(1) DEFAULT '1' COMMENT '0=> use, 1=not use',
  `is_deleted` tinyint(1) DEFAULT '0',
  `password` varchar(255) NOT NULL,
  `user_status` varchar(255) NOT NULL,
  `android_id` varchar(255) NOT NULL,
  `user_type` varchar(255) NOT NULL,
  `account_status` tinyint(4) DEFAULT '0',
  `company_id` int(11) DEFAULT '0',
  `biomatric_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `index_users_on_username` (`username`(10))
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=123 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.users: ~0 rows (approximately)
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` (`id`, `username`, `first_name`, `last_name`, `secure_unqid`, `email`, `account_type`, `admin`, `student`, `employee`, `agent`, `condidate`, `hashed_password`, `salt`, `reset_password_code`, `reset_password_code_until`, `created_at`, `updated_at`, `parent`, `is_first_login`, `portal_use`, `is_deleted`, `password`, `user_status`, `android_id`, `user_type`, `account_status`, `company_id`, `biomatric_id`) VALUES
	(1, 'clockadmin', 'admin', 'admin', NULL, NULL, NULL, 1, 0, 0, 0, 0, NULL, NULL, NULL, '2017-03-01 11:28:19', '2017-03-01 11:28:19', '2017-03-01 11:28:19', NULL, NULL, 1, 0, 'clockadmin@321', 'Online', '', '', 0, 0, 0);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;


-- Dumping structure for table chiru.user_license
CREATE TABLE IF NOT EXISTS `user_license` (
  `id` int(11) NOT NULL DEFAULT '1',
  `licence_key` varchar(255) NOT NULL,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.user_license: ~0 rows (approximately)
/*!40000 ALTER TABLE `user_license` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_license` ENABLE KEYS */;


-- Dumping structure for table chiru.user_main_menu
CREATE TABLE IF NOT EXISTS `user_main_menu` (
  `user_id` int(50) NOT NULL,
  `main_menu_id` int(50) NOT NULL,
  `company_id` int(11) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=455;

-- Dumping data for table chiru.user_main_menu: ~0 rows (approximately)
/*!40000 ALTER TABLE `user_main_menu` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_main_menu` ENABLE KEYS */;


-- Dumping structure for table chiru.user_menu
CREATE TABLE IF NOT EXISTS `user_menu` (
  `user_id` int(50) NOT NULL,
  `menu_id` int(50) NOT NULL,
  `main_menu_id1` int(50) NOT NULL,
  `perticular` int(50) NOT NULL,
  `company_id` int(11) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=85;

-- Dumping data for table chiru.user_menu: ~0 rows (approximately)
/*!40000 ALTER TABLE `user_menu` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_menu` ENABLE KEYS */;


-- Dumping structure for table chiru.user_menu_dashboard
CREATE TABLE IF NOT EXISTS `user_menu_dashboard` (
  `user_id` int(50) NOT NULL,
  `menu_id` int(50) NOT NULL,
  `main_menu_id1` int(50) NOT NULL,
  `perticular` int(50) NOT NULL,
  `maindash` int(50) NOT NULL DEFAULT '0',
  `company_id` int(11) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=546 ROW_FORMAT=COMPACT;

-- Dumping data for table chiru.user_menu_dashboard: ~0 rows (approximately)
/*!40000 ALTER TABLE `user_menu_dashboard` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_menu_dashboard` ENABLE KEYS */;


-- Dumping structure for table chiru.user_setup
CREATE TABLE IF NOT EXISTS `user_setup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status` enum('0','1') NOT NULL DEFAULT '0',
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

-- Dumping data for table chiru.user_setup: ~0 rows (approximately)
/*!40000 ALTER TABLE `user_setup` DISABLE KEYS */;
INSERT INTO `user_setup` (`id`, `status`, `company_id`) VALUES
	(1, '1', 0);
/*!40000 ALTER TABLE `user_setup` ENABLE KEYS */;


-- Dumping structure for table chiru.vendor
CREATE TABLE IF NOT EXISTS `vendor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `company_name` varchar(255) DEFAULT NULL COMMENT 'Mast',
  `first_name` varchar(255) DEFAULT NULL COMMENT 'Must',
  `middle_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL COMMENT 'Must',
  `user_name` varchar(255) DEFAULT NULL COMMENT 'must with unique',
  `address1` varchar(255) DEFAULT NULL COMMENT 'Must',
  `address2` varchar(255) DEFAULT NULL,
  `pin_code` varchar(255) DEFAULT NULL COMMENT 'Must',
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `pho_number` varchar(255) DEFAULT NULL COMMENT 'Official Number',
  `mob_no` varchar(255) DEFAULT NULL COMMENT 'Must and unique',
  `email_id` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `web_site` varchar(255) DEFAULT NULL,
  `account_number` varchar(255) DEFAULT NULL COMMENT 'unique',
  `account_holder_name` varchar(255) DEFAULT NULL COMMENT 'unique',
  `ifsc_code` varchar(255) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `pan_number` varchar(255) DEFAULT NULL COMMENT 'unique',
  `apply_tds` int(11) DEFAULT '0',
  `tax_reg_number` varchar(255) DEFAULT NULL COMMENT 'unique',
  `remarks` varchar(255) DEFAULT NULL,
  `created_by` varchar(255) DEFAULT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `company_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=16384;



CREATE TRIGGER `employee_approve_od_after_insert` AFTER INSERT ON `employee_approve_od` FOR EACH ROW BEGIN
#od start time
# get shift id
#get punch id

set @biomatrix_id := (select employees.biometric_id from employees where employees.user_id=new.employee_id limit 1);

set @sql1 :=(select if((select next_day  as var1 from employee_shift where id=(SELECT tbl_hrm_shift.shift_id FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id= @biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id= @biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (SELECT SUBDATE(new.date,1)) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (SELECT SUBDATE(new.date,1))))) and employee_shift.punchout_time >(new.start_time) limit 1 ),(select next_day  as var1 from employee_shift where id=(SELECT tbl_hrm_shift.shift_id FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id= @biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id= @biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (SELECT SUBDATE(new.date,1)) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (SELECT SUBDATE(new.date,1))))) and employee_shift.punchout_time >(new.start_time) limit 1 ),0 ) );

set @sql2 :=(select if((SELECT tbl_hrm_shift.shift_id as var3 FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (SELECT SUBDATE(new.date,1)) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (SELECT SUBDATE(new.date,1)))) limit 1),(SELECT tbl_hrm_shift.shift_id as var3 FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (SELECT SUBDATE(new.date,1)) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (SELECT SUBDATE(new.date,1)))) limit 1),0 ));


set @sql3 :=(select if((SELECT tbl_hrm_shift.shift_id  as var2 FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (new.date) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (new.date))) limit 1),(SELECT tbl_hrm_shift.shift_id  as var2 FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (new.date) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (new.date))) limit 1),0 ));

set @shift_id=0;

if @sql1=0 && @sql3=0 then
set @shift_id=0;

elseif @sql1=1 then
set @shift_id=@sql2;
elseif @sql1=0 then
set @shift_id=@sql3;
end if;

#inser into tbltimesheet
insert into tblt_timesheet set tblt_timesheet.punchingcode=@biomatrix_id,  tblt_timesheet.date=new.date,tblt_timesheet.date_time1=concat(new.date,' ',new.start_time),tblt_timesheet.shift_id=@shift_id,tblt_timesheet.attendence_type='OD',tblt_timesheet.time=new.start_time;

insert into tblt_timesheet set tblt_timesheet.punchingcode=@biomatrix_id,  tblt_timesheet.date=new.date,tblt_timesheet.date_time1=concat(new.date,' ',new.end_time),tblt_timesheet.shift_id=@shift_id,tblt_timesheet.attendence_type='OD',tblt_timesheet.time=new.end_time;

#end insert
 
# end shift id
#end od start time

END;

CREATE TRIGGER `employee_approve_od_after_update` AFTER UPDATE ON `employee_approve_od` FOR EACH ROW BEGIN
#od start time
# get shift id
#get punch id

set @biomatrix_id := (select employees.biometric_id from employees where employees.user_id=new.employee_id limit 1);

set @sql1 :=(select if((select next_day  as var1 from employee_shift where id=(SELECT tbl_hrm_shift.shift_id FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id= @biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id= @biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (SELECT SUBDATE(new.date,1)) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (SELECT SUBDATE(new.date,1))))) and employee_shift.punchout_time >(new.start_time) limit 1 ),(select next_day  as var1 from employee_shift where id=(SELECT tbl_hrm_shift.shift_id FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id= @biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id= @biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (SELECT SUBDATE(new.date,1)) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (SELECT SUBDATE(new.date,1))))) and employee_shift.punchout_time >(new.start_time) limit 1 ),0 ) );

set @sql2 :=(select if((SELECT tbl_hrm_shift.shift_id as var3 FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (SELECT SUBDATE(new.date,1)) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (SELECT SUBDATE(new.date,1)))) limit 1),(SELECT tbl_hrm_shift.shift_id as var3 FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (SELECT SUBDATE(new.date,1)) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (SELECT SUBDATE(new.date,1)))) limit 1),0 ));


set @sql3 :=(select if((SELECT tbl_hrm_shift.shift_id  as var2 FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (new.date) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (new.date))) limit 1),(SELECT tbl_hrm_shift.shift_id  as var2 FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (new.date) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (new.date))) limit 1),0 ));

set @shift_id=0;

if @sql1=0 && @sql3=0 then
set @shift_id=0;

elseif @sql1=1 then
set @shift_id=@sql2;
elseif @sql1=0 then
set @shift_id=@sql3;
end if;

#inser into tbltimesheet
insert into tblt_timesheet set tblt_timesheet.punchingcode=@biomatrix_id,  tblt_timesheet.date=new.date,tblt_timesheet.date_time1=concat(new.date,' ',new.start_time),tblt_timesheet.shift_id=@shift_id,tblt_timesheet.attendence_type='OD',tblt_timesheet.time=new.start_time;

insert into tblt_timesheet set tblt_timesheet.punchingcode=@biomatrix_id,  tblt_timesheet.date=new.date,tblt_timesheet.date_time1=concat(new.date,' ',new.end_time),tblt_timesheet.shift_id=@shift_id,tblt_timesheet.attendence_type='OD',tblt_timesheet.time=new.end_time;

#end insert
 
# end shift id
#end od start time

END;

CREATE TRIGGER `employee_leaves_after_insert` AFTER INSERT ON `employee_leaves` FOR EACH ROW BEGIN

if (new.employee_leave_type_id)=9999 then

set @biomatrix_id := (select employees.biometric_id from employees where employees.user_id=new.employee_id limit 1);

set @short_leave_date := (select apply_short_leave.date  from apply_short_leave where apply_short_leave.employee_id=new.employee_id and new.leave_date limit 1);

set @short_leave_srt_date := (select apply_short_leave.start_time  from apply_short_leave where apply_short_leave.employee_id=new.employee_id and new.leave_date limit 1);

set @short_leave_end_date := (select apply_short_leave.end_time  from apply_short_leave where apply_short_leave.employee_id=new.employee_id and new.leave_date limit 1);

#check shift id

set @sql1 :=(select if((select next_day  as var1 from employee_shift where id=(SELECT tbl_hrm_shift.shift_id FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id= @biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id= @biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (SELECT SUBDATE(@short_leave_date,1)) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (SELECT SUBDATE(@short_leave_date,1))))) and employee_shift.punchout_time >(@short_leave_srt_date) limit 1 ),(select next_day  as var1 from employee_shift where id=(SELECT tbl_hrm_shift.shift_id FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id= @biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id= @biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (SELECT SUBDATE(@short_leave_date,1)) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (SELECT SUBDATE(@short_leave_date,1))))) and employee_shift.punchout_time >(@short_leave_srt_date) limit 1 ),0 ) );

set @sql2 :=(select if((SELECT tbl_hrm_shift.shift_id as var3 FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (SELECT SUBDATE(@short_leave_date,1)) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (SELECT SUBDATE(@short_leave_date,1)))) limit 1),(SELECT tbl_hrm_shift.shift_id as var3 FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (SELECT SUBDATE(@short_leave_date,1)) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (SELECT SUBDATE(@short_leave_date,1)))) limit 1),0 ));


set @sql3 :=(select if((SELECT tbl_hrm_shift.shift_id  as var2 FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (@short_leave_date) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (@short_leave_date))) limit 1),(SELECT tbl_hrm_shift.shift_id  as var2 FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (@short_leave_date) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (@short_leave_date))) limit 1),0 ));

set @shift_id=0;

if @sql1=0 && @sql3=0 then
set @shift_id=0;

elseif @sql1=1 then
set @shift_id=@sql2;
elseif @sql1=0 then
set @shift_id=@sql3;
end if;



#end
#inser into tbltimesheet
insert into tblt_timesheet set tblt_timesheet.punchingcode=@biomatrix_id,  tblt_timesheet.date=@short_leave_date,tblt_timesheet.date_time1=concat(@short_leave_date,' ',@short_leave_srt_date),tblt_timesheet.shift_id=@shift_id,tblt_timesheet.attendence_type='SL',tblt_timesheet.time=@short_leave_srt_date;

insert into tblt_timesheet set tblt_timesheet.punchingcode=@biomatrix_id,  tblt_timesheet.date=@short_leave_date,tblt_timesheet.date_time1=concat(@short_leave_date,' ',@short_leave_end_date),tblt_timesheet.shift_id=@shift_id,tblt_timesheet.attendence_type='SL',tblt_timesheet.time=@short_leave_end_date;

#end insert

end if;


END;

CREATE TRIGGER `employee_leaves_after_update` AFTER UPDATE ON `employee_leaves` FOR EACH ROW BEGIN

if (new.employee_leave_type_id)=9999 then

set @biomatrix_id := (select employees.biometric_id from employees where employees.user_id=new.employee_id limit 1);

set @short_leave_date := (select apply_short_leave.date  from apply_short_leave where apply_short_leave.employee_id=new.employee_id and new.leave_date limit 1);

set @short_leave_srt_date := (select apply_short_leave.start_time  from apply_short_leave where apply_short_leave.employee_id=new.employee_id and new.leave_date limit 1);

set @short_leave_end_date := (select apply_short_leave.end_time  from apply_short_leave where apply_short_leave.employee_id=new.employee_id and new.leave_date limit 1);

#check shift id

set @sql1 :=(select if((select next_day  as var1 from employee_shift where id=(SELECT tbl_hrm_shift.shift_id FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id= @biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id= @biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (SELECT SUBDATE(@short_leave_date,1)) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (SELECT SUBDATE(@short_leave_date,1))))) and employee_shift.punchout_time >(@short_leave_srt_date) limit 1 ),(select next_day  as var1 from employee_shift where id=(SELECT tbl_hrm_shift.shift_id FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id= @biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id= @biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (SELECT SUBDATE(@short_leave_date,1)) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (SELECT SUBDATE(@short_leave_date,1))))) and employee_shift.punchout_time >(@short_leave_srt_date) limit 1 ),0 ) );

set @sql2 :=(select if((SELECT tbl_hrm_shift.shift_id as var3 FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (SELECT SUBDATE(@short_leave_date,1)) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (SELECT SUBDATE(@short_leave_date,1)))) limit 1),(SELECT tbl_hrm_shift.shift_id as var3 FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (SELECT SUBDATE(@short_leave_date,1)) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (SELECT SUBDATE(@short_leave_date,1)))) limit 1),0 ));


set @sql3 :=(select if((SELECT tbl_hrm_shift.shift_id  as var2 FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (@short_leave_date) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (@short_leave_date))) limit 1),(SELECT tbl_hrm_shift.shift_id  as var2 FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (@short_leave_date) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (@short_leave_date))) limit 1),0 ));

set @shift_id=0;

if @sql1=0 && @sql3=0 then
set @shift_id=0;

elseif @sql1=1 then
set @shift_id=@sql2;
elseif @sql1=0 then
set @shift_id=@sql3;
end if;



#end
#inser into tbltimesheet
insert into tblt_timesheet set tblt_timesheet.punchingcode=@biomatrix_id,  tblt_timesheet.date=@short_leave_date,tblt_timesheet.date_time1=concat(@short_leave_date,' ',@short_leave_srt_date),tblt_timesheet.shift_id=@shift_id,tblt_timesheet.attendence_type='SL',tblt_timesheet.time=@short_leave_srt_date;

insert into tblt_timesheet set tblt_timesheet.punchingcode=@biomatrix_id,  tblt_timesheet.date=@short_leave_date,tblt_timesheet.date_time1=concat(@short_leave_date,' ',@short_leave_end_date),tblt_timesheet.shift_id=@shift_id,tblt_timesheet.attendence_type='SL',tblt_timesheet.time=@short_leave_end_date;

#end insert

end if;


END;

CREATE TRIGGER `tblt_timesheet_after_insert` AFTER INSERT ON `tblt_timesheet` FOR EACH ROW BEGIN
if (select count(*) from tblt_timesheet_cal where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1))>0 then

set @late_early :=(select tblt_timesheet_cal.late_early from tblt_timesheet_cal  where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1);
SET @start_time := (select tblt_timesheet_cal.start_time from tblt_timesheet_cal where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1);
SET @end_time :=new.date_time1;

set @diff=(select TIME_TO_SEC(TIMEDIFF(@end_time,@start_time)));
#if diff entry but starttime <
if @diff=0 then
update tblt_timesheet_cal set tblt_timesheet_cal.punchingcode=new.punchingcode,tblt_timesheet_cal.date=date(new.date_time1),tblt_timesheet_cal.start_time=new.date_time1,shift_id=new.shift_id,shift_name=(select name from employee_shift where id=new.shift_id limit 1),shift_start_time=(select start_time from employee_shift where id=new.shift_id limit 1) ,shift_end_time=(select end_time from employee_shift where id=new.shift_id limit 1) ,shift_working_hours=(select working_hours from employee_shift where id=new.shift_id limit 1) ,shift_gross_time=(select gross_time from employee_shift where id=new.shift_id limit 1) ,shift_half_day=(select half_day_time from employee_shift where id=new.shift_id limit 1),emp_id=(select id from employees where employees.biometric_id=new.punchingcode limit 1) where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1);
	#update late or early
update tblt_timesheet_cal set late_early=((TIME_TO_SEC(time(tblt_timesheet_cal.start_time)))-((TIME_TO_SEC(tblt_timesheet_cal.shift_start_time))+(SUBSTR(tblt_timesheet_cal.shift_gross_time,-2)*60))) where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1);

update tblt_timesheet_cal set tblt_timesheet_cal.shift_working_hr_sec =((SUBSTR(tblt_timesheet_cal.shift_working_hours,1,2)+0)*60*60+(SUBSTR(tblt_timesheet_cal.shift_working_hours,-2)+0))  where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1);

elseif @diff < 0 then
update tblt_timesheet_cal set tblt_timesheet_cal.punchingcode=new.punchingcode,tblt_timesheet_cal.date=date(new.date_time1),tblt_timesheet_cal.start_time=new.date_time1,shift_id=new.shift_id,shift_name=(select name from employee_shift where id=new.shift_id limit 1),shift_start_time=(select start_time from employee_shift where id=new.shift_id limit 1) ,shift_end_time=(select end_time from employee_shift where id=new.shift_id limit 1) ,shift_working_hours=(select working_hours from employee_shift where id=new.shift_id limit 1) ,shift_gross_time=(select gross_time from employee_shift where id=new.shift_id limit 1) ,shift_half_day=(select half_day_time from employee_shift where id=new.shift_id limit 1),emp_id=(select id from employees where employees.biometric_id=new.punchingcode limit 1) where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1);
	#update late or early
update tblt_timesheet_cal set late_early=((TIME_TO_SEC(time(tblt_timesheet_cal.start_time)))-((TIME_TO_SEC(tblt_timesheet_cal.shift_start_time))+(SUBSTR(tblt_timesheet_cal.shift_gross_time,-2)*60))) where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1);

update tblt_timesheet_cal set tblt_timesheet_cal.shift_working_hr_sec =((SUBSTR(tblt_timesheet_cal.shift_working_hours,1,2)+0)*60*60+(SUBSTR(tblt_timesheet_cal.shift_working_hours,-2)+0))  where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1);

#if diff entry but endtime >
	elseif @diff>0 then
	
	update tblt_timesheet_cal set tblt_timesheet_cal.end_time=new.date_time1,tblt_timesheet_cal.total_working_hr=TIMEDIFF(new.date_time1,tblt_timesheet_cal.start_time) where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1);
	
	
end if;

#END if diff entry but endtime >

#new entry
elseif (select count(*) from tblt_timesheet_cal where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1))<=0 then

insert into tblt_timesheet_cal set tblt_timesheet_cal.punchingcode=new.punchingcode,tblt_timesheet_cal.date=date(new.date_time1),tblt_timesheet_cal.start_time=new.date_time1,shift_id=new.shift_id,shift_name=(select name from employee_shift where id=new.shift_id limit 1),shift_start_time=(select start_time from employee_shift where id=new.shift_id limit 1) ,shift_end_time=(select end_time from employee_shift where id=new.shift_id limit 1) ,shift_working_hours=(select working_hours from employee_shift where id=new.shift_id limit 1) ,shift_gross_time=(select gross_time from employee_shift where id=new.shift_id limit 1) ,shift_half_day=(select half_day_time from employee_shift where id=new.shift_id limit 1),emp_id=(select id from employees where employees.biometric_id=new.punchingcode limit 1);

#update late or early
update tblt_timesheet_cal set late_early=((TIME_TO_SEC(time(tblt_timesheet_cal.start_time)))-((TIME_TO_SEC(tblt_timesheet_cal.shift_start_time))+(SUBSTR(tblt_timesheet_cal.shift_gross_time,-2)*60))) where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1);

update tblt_timesheet_cal set tblt_timesheet_cal.shift_working_hr_sec =((SUBSTR(tblt_timesheet_cal.shift_working_hours,1,2)+0)*60*60+(SUBSTR(tblt_timesheet_cal.shift_working_hours,-2)+0))  where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1);
end if;





#get values 
set @shift_id =0;
set @late_early =0;
set @is_null_late_early=0 ;
set @punch_out_diff = 0;
set @shift_id=0;
set @diff=0;
set @half_wrk_in_hr=0;

set @diff :=(select tblt_timesheet_cal.late_early from tblt_timesheet_cal  where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) and tblt_timesheet_cal.late_early is not NULL limit 1);

set @shift_id=(select tblt_timesheet_cal.shift_id from tblt_timesheet_cal  where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1);
set @punch_out_diff=0;

set @punch_out_diff=(select if( time(tblt_timesheet_cal.end_time)>=time(tblt_timesheet_cal.shift_end_time),1,0) from tblt_timesheet_cal   where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1 );

set @half_wrk_in_hr=( select if( TIME_TO_SEC(tblt_timesheet_cal.total_working_hr)>= (tblt_timesheet_cal.shift_working_hr_sec)/2,1,0 )  from tblt_timesheet_cal  where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1   );

set @is_null_late_early=0;
set @is_null_late_early=(select if( time(tblt_timesheet_cal.late_early) is NULL,0,1) from tblt_timesheet_cal   where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1 );
#end get values

update tblt_timesheet_cal set tblt_timesheet_cal.total_working_hr_sec = CONCAT('shift id=',@shift_id,' Late-early',@diff,' Punch Out DIff=',@punch_out_diff,' Half_Working=',@half_wrk_in_hr)  where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1 ;
##################################condition check #######################################

#---------------- 1.0/0.5 --------------------------------------#
if @shift_id >0 then
	if @diff <0 then
		
			if @punch_out_diff = 1 then
				#diff <= 0 punchout =1 
				update tblt_timesheet_cal set tblt_timesheet_cal.day_count='1.0' where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1 ;
			#end  @punch_out_dif = 1
			elseif @punch_out_diff = 0 then
			#check half day working
			if @half_wrk_in_hr=1 then
				#diff <= 0 punchout =0 and half working =1
			update tblt_timesheet_cal set tblt_timesheet_cal.day_count='0.5' where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1 ;
			elseif @half_wrk_in_hr=0 then
			#diff <= 0 punchout =0 and half working =0
			update tblt_timesheet_cal set tblt_timesheet_cal.day_count='0.0' where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1 ;
			end if;
			#end checking
			end if;
		
	#end @diff<=0
	
	elseif @diff >0 then
	#diff >0
			if @punch_out_diff = 1 then
				if @half_wrk_in_hr=1 then
				#diff > 0 punchout =1 and half working =1
				update tblt_timesheet_cal set tblt_timesheet_cal.day_count='0.5' where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1 ;
				elseif @half_wrk_in_hr=0 then
				#diff > 0 punchout =1 and half working =0
				update tblt_timesheet_cal set tblt_timesheet_cal.day_count='0.0' where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1 ;
				end if ;
			elseif  	@punch_out_diff = 0 then
			#diff > 0 punchout =0 
				if @half_wrk_in_hr=1 then
				#diff > 0 punchout =0 and half working =1
				update tblt_timesheet_cal set tblt_timesheet_cal.day_count='0.5' where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1 ;
				elseif @half_wrk_in_hr=0 then
				#diff > 0 punchout =0 and half working =0
				update tblt_timesheet_cal set tblt_timesheet_cal.day_count='0.0' where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1 ;
				end if ;
			end if;
	end if;
#end @shift_id
end if;
############## end 1.0 ################################



################ no shift id ####################
if @shift_id =0 then
	update tblt_timesheet_cal set tblt_timesheet_cal.day_count='0.0' where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1 ;
end if;
############### end no shift id ##################



#################################end update daycount ####################################




END;

CREATE TRIGGER `tblt_timesheet_after_update` AFTER UPDATE ON `tblt_timesheet` FOR EACH ROW BEGIN
if (select count(*) from tblt_timesheet_cal where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1))>0 then

#get late_early

set @late_early :=(select tblt_timesheet_cal.late_early from tblt_timesheet_cal  where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1);
#end late_early
SET @start_time := (select tblt_timesheet_cal.start_time from tblt_timesheet_cal where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1);
SET @end_time :=new.date_time1;

set @diff=(select TIME_TO_SEC(TIMEDIFF(@end_time,@start_time)));
#if diff entry but starttime <
if @diff=0 then
update tblt_timesheet_cal set tblt_timesheet_cal.punchingcode=new.punchingcode,tblt_timesheet_cal.date=date(new.date_time1),tblt_timesheet_cal.start_time=new.date_time1,shift_id=new.shift_id,shift_name=(select name from employee_shift where id=new.shift_id limit 1),shift_start_time=(select start_time from employee_shift where id=new.shift_id limit 1) ,shift_end_time=(select end_time from employee_shift where id=new.shift_id limit 1) ,shift_working_hours=(select working_hours from employee_shift where id=new.shift_id limit 1) ,shift_gross_time=(select gross_time from employee_shift where id=new.shift_id limit 1) ,shift_half_day=(select half_day_time from employee_shift where id=new.shift_id limit 1),emp_id=(select id from employees where employees.biometric_id=new.punchingcode limit 1) where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1);
	#update late or early
update tblt_timesheet_cal set late_early=((TIME_TO_SEC(time(tblt_timesheet_cal.start_time)))-((TIME_TO_SEC(tblt_timesheet_cal.shift_start_time))+(SUBSTR(tblt_timesheet_cal.shift_gross_time,-2)*60))) where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1);

update tblt_timesheet_cal set tblt_timesheet_cal.shift_working_hr_sec =((SUBSTR(tblt_timesheet_cal.shift_working_hours,1,2)+0)*60*60+(SUBSTR(tblt_timesheet_cal.shift_working_hours,-2)+0))  where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1);

elseif @diff < 0 then
update tblt_timesheet_cal set tblt_timesheet_cal.punchingcode=new.punchingcode,tblt_timesheet_cal.date=date(new.date_time1),tblt_timesheet_cal.start_time=new.date_time1,shift_id=new.shift_id,shift_name=(select name from employee_shift where id=new.shift_id limit 1),shift_start_time=(select start_time from employee_shift where id=new.shift_id limit 1) ,shift_end_time=(select end_time from employee_shift where id=new.shift_id limit 1) ,shift_working_hours=(select working_hours from employee_shift where id=new.shift_id limit 1) ,shift_gross_time=(select gross_time from employee_shift where id=new.shift_id limit 1) ,shift_half_day=(select half_day_time from employee_shift where id=new.shift_id limit 1),emp_id=(select id from employees where employees.biometric_id=new.punchingcode limit 1) where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1);
	#update late or early
update tblt_timesheet_cal set late_early=((TIME_TO_SEC(time(tblt_timesheet_cal.start_time)))-((TIME_TO_SEC(tblt_timesheet_cal.shift_start_time))+(SUBSTR(tblt_timesheet_cal.shift_gross_time,-2)*60))) where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1);

update tblt_timesheet_cal set tblt_timesheet_cal.shift_working_hr_sec =((SUBSTR(tblt_timesheet_cal.shift_working_hours,1,2)+0)*60*60+(SUBSTR(tblt_timesheet_cal.shift_working_hours,-2)+0))  where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1);

#if diff entry but endtime >
	elseif @diff>0 then
	
	update tblt_timesheet_cal set tblt_timesheet_cal.end_time=new.date_time1,tblt_timesheet_cal.total_working_hr=TIMEDIFF(new.date_time1,tblt_timesheet_cal.start_time) where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1);
	
	
end if;

#END if diff entry but endtime >

#new entry
elseif (select count(*) from tblt_timesheet_cal where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1))<=0 then

insert into tblt_timesheet_cal set tblt_timesheet_cal.punchingcode=new.punchingcode,tblt_timesheet_cal.date=date(new.date_time1),tblt_timesheet_cal.start_time=new.date_time1,shift_id=new.shift_id,shift_name=(select name from employee_shift where id=new.shift_id limit 1),shift_start_time=(select start_time from employee_shift where id=new.shift_id limit 1) ,shift_end_time=(select end_time from employee_shift where id=new.shift_id limit 1) ,shift_working_hours=(select working_hours from employee_shift where id=new.shift_id limit 1) ,shift_gross_time=(select gross_time from employee_shift where id=new.shift_id limit 1) ,shift_half_day=(select half_day_time from employee_shift where id=new.shift_id limit 1),emp_id=(select id from employees where employees.biometric_id=new.punchingcode limit 1);

#update late or early
update tblt_timesheet_cal set late_early=((TIME_TO_SEC(time(tblt_timesheet_cal.start_time)))-((TIME_TO_SEC(tblt_timesheet_cal.shift_start_time))+(SUBSTR(tblt_timesheet_cal.shift_gross_time,-2)*60))) where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1);

update tblt_timesheet_cal set tblt_timesheet_cal.shift_working_hr_sec =((SUBSTR(tblt_timesheet_cal.shift_working_hours,1,2)+0)*60*60+(SUBSTR(tblt_timesheet_cal.shift_working_hours,-2)+0))  where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1);
end if;





#get values 
set @shift_id =0;
set @late_early =0;
set @is_null_late_early=0 ;
set @punch_out_diff = 0;
set @shift_id=0;
set @diff=0;
set @half_wrk_in_hr=0;

set @diff :=(select tblt_timesheet_cal.late_early from tblt_timesheet_cal  where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) and tblt_timesheet_cal.late_early is not NULL limit 1);

set @shift_id=(select tblt_timesheet_cal.shift_id from tblt_timesheet_cal  where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1);
set @punch_out_diff=0;

set @punch_out_diff=(select if( time(tblt_timesheet_cal.end_time)>=time(tblt_timesheet_cal.shift_end_time),1,0) from tblt_timesheet_cal   where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1 );

set @half_wrk_in_hr=( select if( TIME_TO_SEC(tblt_timesheet_cal.total_working_hr)>= (tblt_timesheet_cal.shift_working_hr_sec)/2,1,0 )  from tblt_timesheet_cal  where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1   );

set @is_null_late_early=0;
set @is_null_late_early=(select if( time(tblt_timesheet_cal.late_early) is NULL,0,1) from tblt_timesheet_cal   where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1 );
#end get values

update tblt_timesheet_cal set tblt_timesheet_cal.total_working_hr_sec = CONCAT('shift id=',@shift_id,' Late-early',@diff,' Punch Out DIff=',@punch_out_diff,' Half_Working=',@half_wrk_in_hr)  where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1 ;
##################################condition check #######################################

#---------------- 1.0/0.5 --------------------------------------#
if @shift_id >0 then
	if @diff <0 then
		
			if @punch_out_diff = 1 then
				#diff <= 0 punchout =1 
				update tblt_timesheet_cal set tblt_timesheet_cal.day_count='1.0' where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1 ;
			#end  @punch_out_dif = 1
			elseif @punch_out_diff = 0 then
			#check half day working
			if @half_wrk_in_hr=1 then
				#diff <= 0 punchout =0 and half working =1
			update tblt_timesheet_cal set tblt_timesheet_cal.day_count='0.5' where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1 ;
			elseif @half_wrk_in_hr=0 then
			#diff <= 0 punchout =0 and half working =0
			update tblt_timesheet_cal set tblt_timesheet_cal.day_count='0.0' where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1 ;
			end if;
			#end checking
			end if;
		
	#end @diff<=0
	
	elseif @diff >0 then
	#diff >0
			if @punch_out_diff = 1 then
				if @half_wrk_in_hr=1 then
				#diff > 0 punchout =1 and half working =1
				update tblt_timesheet_cal set tblt_timesheet_cal.day_count='0.5' where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1 ;
				elseif @half_wrk_in_hr=0 then
				#diff > 0 punchout =1 and half working =0
				update tblt_timesheet_cal set tblt_timesheet_cal.day_count='0.0' where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1 ;
				end if ;
			elseif  	@punch_out_diff = 0 then
			#diff > 0 punchout =0 
				if @half_wrk_in_hr=1 then
				#diff > 0 punchout =0 and half working =1
				update tblt_timesheet_cal set tblt_timesheet_cal.day_count='0.5' where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1 ;
				elseif @half_wrk_in_hr=0 then
				#diff > 0 punchout =0 and half working =0
				update tblt_timesheet_cal set tblt_timesheet_cal.day_count='0.0' where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1 ;
				end if ;
			end if;
	end if;
#end @shift_id
end if;
############## end 1.0 ################################



################ no shift id ####################
if @shift_id =0 then
	update tblt_timesheet_cal set tblt_timesheet_cal.day_count='0.0' where tblt_timesheet_cal.punchingcode=new.punchingcode and date(tblt_timesheet_cal.date)=date(new.date_time1) limit 1 ;
end if;
############### end no shift id ##################



#################################end update daycount ####################################




END;



CREATE  TRIGGER `apply_od_present_after_update` AFTER UPDATE ON `apply_od_present` FOR EACH ROW BEGIN
if new.approved='1' then
set @biomatrix_id := (select employees.biometric_id from employees where employees.user_id=new.employee_id limit 1);

set @sql1 :=(select if((select next_day  as var1 from employee_shift where id=(SELECT tbl_hrm_shift.shift_id FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id= @biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id= @biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (SELECT SUBDATE(new.date,1)) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (SELECT SUBDATE(new.date,1))))) and employee_shift.punchout_time >(new.start_time) limit 1 ),(select next_day  as var1 from employee_shift where id=(SELECT tbl_hrm_shift.shift_id FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id= @biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id= @biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (SELECT SUBDATE(new.date,1)) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (SELECT SUBDATE(new.date,1))))) and employee_shift.punchout_time >(new.start_time) limit 1 ),0 ) );

set @sql2 :=(select if((SELECT tbl_hrm_shift.shift_id as var3 FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (SELECT SUBDATE(new.date,1)) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (SELECT SUBDATE(new.date,1)))) limit 1),(SELECT tbl_hrm_shift.shift_id as var3 FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (SELECT SUBDATE(new.date,1)) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (SELECT SUBDATE(new.date,1)))) limit 1),0 ));


set @sql3 :=(select if((SELECT tbl_hrm_shift.shift_id  as var2 FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (new.date) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (new.date))) limit 1),(SELECT tbl_hrm_shift.shift_id  as var2 FROM tbl_hrm_shift WHERE (tbl_hrm_shift.emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1) OR (tbl_hrm_shift.type='1' AND tbl_hrm_shift.type_id= (SELECT group_id FROM tbl_employee_group WHERE emp_id=(select id from employees where biometric_id=@biomatrix_id limit 1)))) AND ((DATE_FORMAT(tbl_hrm_shift.start_date,'%Y-%m-%d') <= (new.date) AND DATE_FORMAT(tbl_hrm_shift.end_date,'%Y-%m-%d') >= (new.date))) limit 1),0 ));

set @shift_id=0;

if @sql1=0 && @sql3=0 then
set @shift_id=0;

elseif @sql1=1 then
set @shift_id=@sql2;
elseif @sql1=0 then
set @shift_id=@sql3;
end if;

#inser into tbltimesheet
insert into tblt_timesheet set tblt_timesheet.punchingcode=@biomatrix_id,  tblt_timesheet.date=new.date,tblt_timesheet.date_time1=concat(new.date,' ',new.start_time),tblt_timesheet.shift_id=@shift_id,tblt_timesheet.attendence_type='OD',tblt_timesheet.time=new.start_time;

insert into tblt_timesheet set tblt_timesheet.punchingcode=@biomatrix_id,  tblt_timesheet.date=new.date,tblt_timesheet.date_time1=concat(new.date,' ',new.end_time),tblt_timesheet.shift_id=@shift_id,tblt_timesheet.attendence_type='OD',tblt_timesheet.time=new.end_time;

end if;

END;