<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script src="https://code.jquery.com/jquery-3.3.1.js"></script>
<script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.19/js/dataTables.jqueryui.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.19/css/dataTables.jqueryui.min.css">


<script>

var url ="../webapi/api/index.php/";


$(document).ready(function() {
$('#call_type').hide();
employee_list_show();
activity_list_show();
call_type_list();
});

$(function() {
  $('input[name="daterange"]').daterangepicker({
    opens: 'left'
  }, function(start, end, label) {
    console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
  });
});



function activity_list_show()
{
	$.ajax({
		type : "POST",
		dataType : "json",
		url: url+'activity_list',
		
		success: function(data) 
		{ 
			var countlength=data.data.length;
			
			for(var i=0;i<countlength;i++)
			{
				var opt="<option value='"+data.data[i].close_id+"'>"+data.data[i].close_status+"</option>";
				$("#activiy_name").append(opt);
			}
		}
	});
}

function call_type_list()
{
	$.ajax({
		type : "POST",
		dataType : "json",
		url: url+'call_type_list',
		
		success: function(data) 
		{ 
			var countlength=data.data.length;
			
			for(var i=0;i<countlength;i++)
			{
				var opt="<option value='"+data.data[i].business_call_type+"'>"+data.data[i].business_call_type+"</option>";
				$("#call_type").append(opt);
			}
		}
	});
}

function employee_list_show()
{
	$.ajax({
		type : "POST",
		dataType : "json",
		url: url+'lists_employees',
		
		success: function(data) 
		{ 
			var countlength=data.data.length;
			
			for(var i=0;i<countlength;i++)
			{
				var opt="<option value='"+data.data[i].mobile_no+"'>"+data.data[i].employee_name+"</option>";
				$("#emp_name").append(opt);
				$("#agent_name").append(opt);
			}
		}
	});
}
function fetch_data(act_id,typ_id)
{
	$('#typ_id').val(typ_id);
	$('#act_id').val(act_id);
	var daterange="";
	if(act_id==0){
		$('#call_type').show();
	}
	else{
		$('#call_type').hide();
	}
	
	$.ajax({
		type : "POST",
		dataType : "json",
		url: url+'data_list',
		data:JSON.stringify({"act_id":act_id,"typ_id":typ_id,"daterange":daterange}),
		success: function (data) { 
	
			var table ='<table class="table table-bordered table-hover" id="example1"><thead class="alert-info"><tr><th width="4%">Sr. No.</th><th class="text-nowrap" width="10%">Customer Name</th><th class="text-nowrap" width="10%">Customer Email</th><th class="text-nowrap" width="10%">Customer Mobile</th><th class="text-nowrap" width="10%">Date</th><th class="text-nowrap" width="10%">Agent Assign<br><input type="checkbox" name="checkAll" id="checkAll" onclick="select_all()">Select All</th></tr></thead><tbody class="alert-primary">';
			var tr="";
			if(data.status==1){
			var countlength=data.data.length;
			
			if(countlength>0)
			{
				var j=1;
				for(var i=0;i<countlength;i++)
				{
					var even_tr='<tr><td class="f-s-600 text-inverse">'+j+'</td><td>'+data.data[i].cust_name+'</td><td>'+data.data[i].cust_email+'</td><td>'+data.data[i].mob+'</td><td>'+data.data[i].dat+'</td><td><div class="checkbox"><label><input type="checkbox" name="asgn" value='+data.data[i].log_id+'>Assign</label></div></td></tr>';
			
					tr=tr+even_tr;
					j++;
						
				}
				table=table+tr+"</tbody></table>";
				$("#no_more_tables").html(table);
				$("#example1").DataTable();
			}
			
	}
			else
			{
				tr='<tr><td colspan="6" style="text-align:center;">No Record Found</td></tr>';
				table=table+tr+"</tbody></table>";
				$("#no_more_tables").html(table);
			
			}
			
		}
	});
}

function search_dat()
{
	var daterange=$('#daterange').val();
	var typ_id=$('#typ_id').val();
	var act_id=$('#act_id').val();

	$.ajax({
		type : "POST",
		dataType : "json",
		url: url+'date_by_search',
		data:JSON.stringify({"act_id":act_id,"typ_id":typ_id,"daterange":daterange}),
		success: function (data) { 

			var table ='<table class="table table-bordered table-hover" id="example1"><thead class="alert-info"><tr><th width="4%">Sr. No.</th><th class="text-nowrap" width="10%">Customer Name</th><th class="text-nowrap" width="10%">Customer Email</th><th class="text-nowrap" width="10%">Customer Mobile</th><th class="text-nowrap" width="10%">Date</th><th class="text-nowrap" width="10%">Agent Assign<br><input type="checkbox" name="checkAll" id="checkAll" onclick="select_all()">Select All</th></tr></thead><tbody class="alert-primary">';
			var tr="";
			if(data.status==1){
			var countlength=data.data.length;
			
			if(countlength>0)
			{
				var j=1;
				for(var i=0;i<countlength;i++)
				{
					var even_tr='<tr><td class="f-s-600 text-inverse">'+j+'</td><td>'+data.data[i].cust_name+'</td><td>'+data.data[i].cust_email+'</td><td>'+data.data[i].mob+'</td><td>'+data.data[i].dat+'</td><td><div class="checkbox"><label><input type="checkbox" name="asgn" value='+data.data[i].log_id+'>Assign</label></div></td></tr>';
			
					tr=tr+even_tr;
					j++;
						
				}
				table=table+tr+"</tbody></table>";
				$("#no_more_tables").html(table);
				$("#example1").DataTable();
			}
			
	}
			else
			{
				tr='<tr><td colspan="6" style="text-align:center;">No Record Found</td></tr>';
				table=table+tr+"</tbody></table>";
				$("#no_more_tables").html(table);
			
			}
			
		}
	});
}


function bluk_assign()
{
	var agent_mob=$('#emp_mob').val()
	var cust_id = [];
            $.each($("input[name='asgn']:checked"), function(){            
                cust_id.push($(this).val());
            });
	if(agent_mob=='' || agent_mob==null){
		swal("Please Select Activity and Agent");
		
	}
	else if(cust_id=='' || cust_id==null){
		swal("Please Checked Agent");
		
	}
	else{
	$.ajax({
		type : "POST",
		dataType : "json",
		url: url+'bulk_agent_assign',
		data:JSON.stringify({"agent_mob":agent_mob,"cust_id":cust_id}),
		success: function (data) 
		{ 
			if(data.status==1)
			{
				swal("Agent Assign Successfully","","success");
			}
			else{
				swal("something went wrong");
			}
		}
	});
	
	}
}

function emp_mob_no(mob)
{
	$('#emp_mob').val(mob);
}

function select_all(){

  if (! $('input:checkbox').is('checked')) {
      $('input:checkbox').attr('checked','checked');
  } else {
      $('input:checkbox').removeAttr('checked');
  }       
}


</script>
<aside class="right-side">
	<!-- Content Header (Page header) -->
	<section class="content-header">
		<h1>Bulk Agent Assign</h1>
		
	</section>
	<input type="hidden" id="typ_id"></input>
	<input type="hidden" id="act_id"></input>
	<input type="hidden" id="emp_mob"></input>
	<!-- Main content -->
	<section class="content">
		<div class="row">
			<div class="col-xs-12">
				<div class="box box-primary">
					<div class="box-body">
						<div class="row">
							<div class="col-sm-12 col-lg-12">
							<div class="form-group">
									<label for="inputEmail" class="col-md-2">Select Activity:</label>
									<div class="col-md-3">
										<select id="activiy_name" class="validate[required] form-control" onchange="fetch_data(this.value,0)">
											<option value="">Select Activity</option>
											<option value="0">IVR Call</option>
										</select>
									</div>
									<div class="col-md-3">
										<select id="call_type" class="validate[required] form-control" onchange="fetch_data(0,this.value)">
											<option value="0">Select Call Type</option>
										</select>
									</div>
									<div class="col-md-3">
									
										</div>
								</div><br>
								<div class="form-group">
									<label for="inputEmail" class="col-md-2">Select Agent:</label>
									<div class="col-md-3">
										<select id="emp_name" class="validate[required] form-control" onchange="emp_mob_no(this.value)">
											<option value="">Select Agent</option>
										</select>
									</div>
									<div class="form-group">
									<div class="col-md-5">
										
										<div class="col-md-6">
										
										</div>
										<a class="btn btn-success"  style="float:right" id="btnExport" style="color:white;margin:right">Export</a>
									</div>
								</div>
								</div> <br><br>
								<div class="form-group">
									<label for="inputEmail" class="col-md-2">Search By Date:</label>
									<div class="col-md-3">
										<input type="text" placeholder="Search By Date Range" name="daterange" id="daterange" class="form-control"/><br>
										<button type="button" onclick="search_dat()" class="btn btn-btn">Search Date</button>
									</div>
									<div class="form-group">
									<div class="col-md-5">
										<button type="button" onclick="bluk_assign()" class="btn btn-primary ">Agent Assign</button>
									
									</div>
								</div>
								</div> 
							
						</div><br>
						<div id="no_more_tables" class="table-responsive"></div>
					</div>
				</div>
			</div>	
		</div>
	</section>
</aside>

<script>
var tableToExcel = (function() {
  var uri = 'data:application/vnd.ms-excel;base64,'
    , template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body><table>{table}</table></body></html>'
    , base64 = function(s) { return window.btoa(unescape(encodeURIComponent(s))) }
    , format = function(s, c) { return s.replace(/{(\w+)}/g, function(m, p) { return c[p]; }) }
  return function(table, name) {
    if (!table.nodeType) table = document.getElementById(table)
    var ctx = {worksheet: name || 'Worksheet', table: table.innerHTML}
    var blob = new Blob([format(template, ctx)]);
  var blobURL = window.URL.createObjectURL(blob);
    return blobURL;
	}
})()

 $("#btnExport").click(function () {
    var reportName ='bulk_assign_report';
    var blobURL = tableToExcel('example1');
    $(this).attr('download',reportName+'.xls')
    $(this).attr('href',blobURL);
});
</script>