<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script>
var url = "webapi/api1/";

$(document).ready(function() {
	show_added_account();
});

function insert_account(){
	var acc_type = $("#acc_type").val();
	
	$.ajax({
		type : "POST",
		dataType : "json",
            url: url+'add_account_type',
            data:JSON.stringify({"acc_type":acc_type,"sess_id":'<?php echo $_SESSION["ADMIN_ID"];?>'}),
            
			success: function (data) {
				if(data.status == 1){
					swal("Account Added Successfully");
				}
				else
				{
					swal("Account Type Already Exists");
				}
				show_added_account()
			}
	
	});
		$("#acc_type").val('');
}	


function show_added_account(){
	
	$.ajax({
		type : "POST",
		dataType : "json",
            url: url+'get_inserted_account_type',
            
			success: function (data) {
			
				var table='<table id="data-table-buttons" class="table table-striped table-bordered table-hover "><thead style="background-color:#3c8dbc;color:white;"><tr><th width="1%">S.no</th><th class="text-nowrap">Account Type Name</th><th class="text-nowrap">Action</th></tr></thead><tbody>';
				var tr="";
				var countlength=data.data.length;

				if(countlength>0)
				{
					var j=1;
					for(var i=0;i<countlength;i++)
						{
					
						var even_tr='<tr><td width="1%" class="f-s-600 text-inverse">'+j+'</td><td>'+data.data[i].account_type+'</td><td><span class="btn btn-primary launch-modal" data-target="#myModal" data-toggle="modal" onclick="edit_data('+data.data[i].type_id+')">Edit</span>'+'&nbsp;&nbsp;&nbsp;'+'<span class="btn btn-danger" onclick="delete_data('+data.data[i].type_id+')">Delete</span></td></tr>';
								
						tr=tr+even_tr;
						j++;
						
						}
				}
				 else
				{
				 
					tr='<tr><td colspan="3" style="text-align:center;">No Record Found<td></tr>';
				}
				        table=table+tr+"</tbody></table>";
						$("#no-more-tables").html(table);
						
			
			
			}
	
	});
		
}


function edit_data(type_id){
	
	$("#hid").val(type_id);
		
			$.ajax({
				type : "POST",
				dataType : "json",
				url: url+'edit_inserted_account_type',
				data:JSON.stringify({"id":type_id}),
				success: function (data) { 
				
					$("#account_type").val(data.data[0].account_type);
					
				}
				
			});
			
	}
	
function update_account()
{
	var id = $("#hid").val();
	var account=$("#account_type").val();
	
	if($("#account_type").val()=='' || $("#account_type").val()==false)
	{
		alert("Please Enter Account Type!");
		account.focus();
		return false;
	}
	
	
		$.ajax({
				type : "POST",
				dataType : "json",
				url: url+'update_account_type',
				data:JSON.stringify({"id":id,"account":account}),
				success: function (data) { 
				if(data.status == 1){
					swal("Account Added Successfully");
				}
				else
				{
					swal("Account Type Already Exists");
				}
				
				show_added_account();
				}
				
			});
}


function delete_data(type_id)
	{

		if (confirm("Are you sure you want to delete?")) {
					$.ajax({
					type : "POST",
					dataType : "json",
					url: url+'delete_account_type',
					data:JSON.stringify({"id":type_id}),
					success: function (data) { 
					show_added_account();
					}
					
				});
					
					return false;
						
		}	
			
	}
	

function export_data()
	{
  
	$("#btn").css("display","none");
	$("#btnExport").css("display","none");
	window.open('data:application/vnd.ms-excel,' + encodeURIComponent( $('div[id$=no-more-tables]').html()));
    $("#btn").css("display","");
	$("#btnExport").css("display","");

	}
</script>

<aside class="right-side">
	<!-- Content Header (Page header) -->
	<section class="content-header">
		<h1>Add Account Type</h1>
		<p>
			<ol class="breadcrumb">
				<li><button id="btnExport" class="btn btn-primary" style="float:right;" onclick="export_data()"><i style="color:white;">Export All Data</i></a></li>
			</ol>
		</p>
	</section>
	<!-- Main content -->
	<section class="content">
		<div class="row">
			<div class="box box-primary"><br>
				<div class="col-xs-6">
					<label for="inputEmail" class="col-md-3 control-label">Account Type:</label>
					<div class="col-md-6">
						<input type="text" class="form-control validate[required]" value="" id="acc_type"  placeholder="Add Account Type">
					</div>
				</div>	
				<button type="button" id="save" class="btn btn-success" onclick="insert_account()">Save</button>
			</div>
		</div>
		<center><h3>Already Added Account Types</h3></center>
		<div id="no-more-tables"></div>
	</section>
</aside>


<!--Edit Model Starts Here-->
	<div class="modal fade" id="myModal" role="dialog">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal">&times;</button>
					<h2 class="modal-title" align="center">Update: Account Type</h2>
				</div>
				<div class="modal-body">
					<div class="row">
						<div class="form-group">
							<label for="inputEmail" class="col-md-4 control-label">Account Type:</label>
							<div class="col-md-6">
								<input type="text" class="form-control" id="account_type" value="">
							</div>
						</div>
					</div>
				</div></br>
					<input type="hidden" id="hid"/>
				<div class="modal-footer">
					<button type="button" class="btn btn-primary" data-dismiss="modal" onclick="update_account();">Update</button>
					<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
				</div>
			</div>
		</div>
	</div>
