<?php

require_once __DIR__ . '/vendor/autoload.php';

use Slim\Http\Request;
use Slim\Http\Response;
use Slim\Http\UploadedFile;

$app = new \Slim\App();

$container = $app->getContainer();
$container['upload_directory'] = '../../assets/user_image/employee_image/emp_document';

$app->post('/', function(Request $request, Response $response, array $args) {
	
    $directory = $this->get('upload_directory');
     $data = $request->getParsedBody();
     $filename=$data['emp_name'].'_pan';
    $uploadedFiles = $request->getUploadedFiles();

    // handle single input with single file upload
    $uploadedFile = $uploadedFiles['example1'];
    if ($uploadedFile->getError() === UPLOAD_ERR_OK) {
        $filename = moveUploadedFile($directory, $uploadedFile,$filename);
        //$response->write('PAN uploaded DONE');
		$status["status"] = 1;
		$status["message"] = 'PAN uploaded DONE';
		$status["filename"] =$filename;
		$final=json_encode($status);
				
        $response->write($final);
		
    }
else
	{
		$status["status"] = 0;
		$status["message"] = "uploaded Fail!";
		$status["filename"] =$filename;
		$final=json_encode($status);
				
        $response->write($final);
	}

});

/**
 * Moves the uploaded file to the upload directory and assigns it a unique name
 * to avoid overwriting an existing uploaded file.
 *
 * @param string $directory directory to which the file is moved
 * @param UploadedFile $uploaded file uploaded file to move
 * @return string filename of moved file
 */
function moveUploadedFile($directory, UploadedFile $uploadedFile,$filename)
{
    $extension = pathinfo($uploadedFile->getClientFilename(), PATHINFO_EXTENSION);
    //$basename = bin2hex(random_bytes(8)); // see http://php.net/manual/en/function.random-bytes.php
    $filename = sprintf('%s.%0.8s', $filename, $extension);

    $uploadedFile->moveTo($directory . DIRECTORY_SEPARATOR . $filename);

    return $filename;
}

$app->run();